/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.structure;

import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.selectiontree.AbstractBaseConditionProfile;
import com.ericsson.ere.selectiontree.HierarchicalFieldFilter;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.conditions.field.FieldConditionProfileHandler;
import com.ericsson.ere.selectiontree.conditions.field.FieldProfileModel;
import com.ericsson.ere.selectiontree.conditions.structure.CollectionContainsConditionConfiguration;
import com.ericsson.ere.selectiontree.conditions.structure.CollectionContainsConditionProfileContract;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.ItemListModel;
import ericsson.vareditor.variable.ItemListVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Constrainable(contractClass=CollectionContainsConditionProfileContract.class)
public class CollectionContainsConditionProfile
extends AbstractBaseConditionProfile
implements FieldMappable {
    private static final String COND_LABEL = "Subconditions";

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> list = new ArrayList<Variable>();
        FieldConditionProfileHandler handler = new FieldConditionProfileHandler(this.myRepository.getFieldRepository().getFieldByName(this.getFieldName()), this.myRepository);
        ItemListModel ilm = new ItemListModel();
        list.add(new ItemListVariable(COND_LABEL, ilm, handler));
        return list;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ClassRepositoryHelper helper = new ClassRepositoryHelper(this.myRepository);
        ArrayList<Variable> list = new ArrayList<Variable>();
        FieldConditionProfileHandler handler = new FieldConditionProfileHandler(this.myRepository.getFieldRepository().getFieldByName(this.getFieldName()), this.myRepository);
        CollectionContainsConditionConfiguration conf = (CollectionContainsConditionConfiguration)CollectionContainsConditionConfiguration.create(new ParseContextAdapter(this.myRepository, iterator, null));
        Element fieldElement = XMLUtil.getFirstElementNamed("Field", (Element)iterator);
        String scopeFieldName = XMLUtil.getAttributeFromElement(fieldElement, "field", null);
        FieldHierarchyNode scopeField = this.myRepository.getFieldRepository().getFieldByName(scopeFieldName);
        List<Element> configs = conf.getSubConditionConfigs();
        ItemListModel ilm = new ItemListModel();
        for (Element config : configs) {
            ilm.add(new FieldProfileModel(scopeField, config, helper));
        }
        list.add(new ItemListVariable(COND_LABEL, ilm, handler));
        return list;
    }

    protected List<String> getSupportedFieldNameList(ClassRepository repository) {
        AvailableFieldListBuilder builder = AvailableFieldListBuilder.createAvailableFieldListBuilder(repository);
        builder.withHierarchicalFields();
        builder.withFilter(this.createFieldFilter());
        return builder.buildFieldNameList();
    }

    protected HierarchicalFieldFilter createFieldFilter() {
        return new GeneralFieldFilter();
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        ItemListVariable var = (ItemListVariable)VarListUtil.getVariableForName(variables, COND_LABEL);
        ItemListModel model = var.getModel();
        Element element = null;
        try {
            element = XMLUtil.buildDocumentFromString("<Dummy/>").getDocumentElement();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < model.getSize(); ++i) {
            FieldProfileModel fpm = (FieldProfileModel)model.getElementAt(i);
            fpm.appendXML(element);
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            out.println(DomWriter.elementToString((Element)nodes.item(i)));
        }
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String fieldName = VarListUtil.getValueStringForName(variables, "Selected field");
        return "CollectionContains (" + fieldName + ")";
    }

    private class GeneralFieldFilter
    implements HierarchicalFieldFilter {
        private GeneralFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldHierarchyNode field) {
            return !field.isLeaf();
        }
    }
}

