/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.structure;

import com.ericsson.ere.selectiontree.AnnotationBasedPluginConfiguration;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.interfaces.PluginConfiguration;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CollectionContainsConditionConfiguration
extends AnnotationBasedPluginConfiguration {
    private List<Element> mySubConditions;

    CollectionContainsConditionConfiguration(ParseContext context) {
        super(context);
        Element xml = (Element)context.getXMLNode();
        this.mySubConditions = new ArrayList<Element>();
        List<Element> children = XMLUtil.getElementNodesNamed("SubCondition", xml.getChildNodes());
        for (Element child : children) {
            Element copy = (Element)child.cloneNode(true);
            child.getOwnerDocument().renameNode(copy, null, "Condition");
            this.mySubConditions.add(copy);
        }
    }

    public static PluginConfiguration create(ParseContext context) {
        return new CollectionContainsConditionConfiguration(context);
    }

    @Override
    public void appendXML(Node parent) {
        for (Element child : this.mySubConditions) {
            Element copy = (Element)child.cloneNode(true);
            copy.getOwnerDocument().renameNode(copy, null, "SubCondition");
            parent.appendChild(XMLUtil.adoptNode(parent.getOwnerDocument(), copy));
        }
    }

    public List<Element> getSubConditionConfigs() {
        return this.mySubConditions;
    }
}

