/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.string.AbstractImmutableStringCondition;
import com.ericsson.ere.selectiontree.conditions.string.CharacterTree;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import com.ericsson.ere.selectiontree.interfaces.TraceContext;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.util.Arrays;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Immutable
public final class StringList
extends AbstractImmutableStringCondition
implements FieldMappable,
TraceableV2,
ContextCondition {
    private static final String SPLIT_REGEXP = "\n|\t|\r|;|,";
    private final boolean myMatchCase;
    private final int myComparation;
    private final CharacterTree myCompareTree;
    private final String[] mySplits;
    public static final String TAG_TYPE = "Type";
    public static final String TAG_COMPARATION = "Comparation";
    public static final String TAG_STRING = "String";
    public static final String TAG_CASE = "MatchCase";
    public static final int TAG_COMPARE_BEGINS_WITH = 0;
    public static final int TAG_COMPARE_ENDS_WITH = 1;
    public static final int TAG_COMPARE_CONTAINS = 2;
    public static final int TAG_COMPARE_EXACT_MATCH = 3;
    private int myHashCodeCache;

    public static StringList create(ParseContext ctx, TariffStructureNode[] children) {
        return new StringList(ctx);
    }

    private StringList(ParseContext ctx) {
        super(ctx);
        NodeList children = ctx.getXMLNode().getChildNodes();
        String strings = XMLUtil.getFirstTextContent(XMLUtil.getNamedElement(TAG_STRING, children));
        Element caseNode = XMLUtil.getNamedElement(TAG_CASE, children);
        this.myMatchCase = Boolean.valueOf(XMLUtil.getFirstTextContent(caseNode));
        if (!this.myMatchCase) {
            strings = strings.toLowerCase();
        }
        strings = XMLUtil.unEscape(strings);
        this.mySplits = strings.split(SPLIT_REGEXP);
        Element comparisonType = XMLUtil.getNamedElement(TAG_COMPARATION, children);
        this.myComparation = comparisonType != null ? Integer.parseInt(XMLUtil.getFirstTextContent(comparisonType)) : 0;
        if (this.myComparation == 0 || this.myComparation == 1) {
            if (this.myComparation == 1) {
                StringBuilder b = new StringBuilder(strings);
                strings = b.reverse().toString();
            }
            this.myCompareTree = new CharacterTree(strings);
        } else {
            this.myCompareTree = null;
        }
        this.myHashCodeCache = this.internalHashCode();
    }

    private int internalHashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + this.myComparation;
        result = 31 * result + (this.myCompareTree == null ? 0 : this.myCompareTree.hashCode());
        result = 31 * result + (this.myMatchCase ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.mySplits);
        return result;
    }

    public int hashCode() {
        return this.myHashCodeCache;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringList other = (StringList)obj;
        if (this.myHashCodeCache != other.myHashCodeCache) {
            return false;
        }
        if (this.myComparation != other.myComparation) {
            return false;
        }
        if (this.myCompareTree == null ? other.myCompareTree != null : !this.myCompareTree.equals(other.myCompareTree)) {
            return false;
        }
        if (this.myMatchCase != other.myMatchCase) {
            return false;
        }
        return Arrays.equals(this.mySplits, other.mySplits);
    }

    @Override
    public boolean test(DataSet data) {
        boolean retVal = false;
        try {
            String stringToCheck = this.getStringValue(data);
            retVal = this.doTest(stringToCheck);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        String stringToCheck = (String)exeCtx.getValue(DataType.STRING);
        return this.doTest(stringToCheck);
    }

    private boolean doTest(String stringToCheck) {
        boolean result = false;
        if (!StringUtil.isEmptyString(stringToCheck)) {
            if (!this.myMatchCase) {
                stringToCheck = stringToCheck.toLowerCase();
            }
            if (this.myComparation == 2) {
                for (int i = 0; i < this.mySplits.length && !(result = stringToCheck.contains(this.mySplits[i])); ++i) {
                }
            } else if (this.myComparation == 3) {
                for (int i = 0; i < this.mySplits.length && !(result = this.mySplits[i].equals(stringToCheck)); ++i) {
                }
            } else if (this.myComparation == 0) {
                result = this.myCompareTree.checkString(stringToCheck);
            } else {
                StringBuilder rev = new StringBuilder(stringToCheck);
                result = this.myCompareTree.checkString(rev.reverse().toString());
            }
        }
        return result;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String fieldNameString = this.describeFieldName(dataSet);
        String dataSetFieldValue = null;
        try {
            dataSetFieldValue = this.getStringValue(dataSet);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doDescribeTrace(dataSet, fieldNameString, dataSetFieldValue);
    }

    @Override
    public String describeTrace(TraceContext traceCtx) {
        return this.doDescribeTrace(TraceDataSet.createPreDataSet(traceCtx.getTracePoint()), traceCtx.getFieldDescription(), traceCtx.getTraceValue());
    }

    private String doDescribeTrace(TraceDataSet dataSet, String selectedFieldName, String testedFieldValue) {
        String fieldValue = this.describeStringValue(testedFieldValue, dataSet);
        return this.createTraceDescriptionText("StringList", selectedFieldName, fieldValue, this.describeComparation(), "an entry in list");
    }

    private String describeComparation() {
        String operationText = "";
        switch (this.myComparation) {
            case 0: {
                operationText = "begins with";
                break;
            }
            case 1: {
                operationText = "ends with";
                break;
            }
            case 2: {
                operationText = "is contained in";
                break;
            }
            case 3: {
                operationText = "exactly matches";
            }
        }
        operationText = operationText + (this.myMatchCase ? " (case sensitive)" : " (case insensitive)");
        return operationText;
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }
}

