/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.string.AbstractImmutableStringCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.interfaces.TraceContext;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Immutable
public final class RegularExpressionCondition
extends AbstractImmutableStringCondition
implements TraceableV2,
ContextCondition {
    public static final String TAG_EXPRESSION = "Expression";
    private final String myExpression;
    private final Pattern myPattern;

    public static RegularExpressionCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new RegularExpressionCondition(ctx);
    }

    private RegularExpressionCondition(ParseContext ctx) {
        super(ctx);
        String expressionString = RegularExpressionCondition.getNodeTextValue(TAG_EXPRESSION, ctx.getXMLNode().getChildNodes());
        this.myExpression = expressionString.replaceAll("\\s", "");
        this.myPattern = Pattern.compile(this.myExpression);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myExpression == null ? 0 : this.myExpression.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegularExpressionCondition other = (RegularExpressionCondition)obj;
        return !(this.myExpression == null ? other.myExpression != null : !this.myExpression.equals(other.myExpression));
    }

    private static String getNodeTextValue(String tag, NodeList theNodeList) {
        Element aNode = XMLUtil.getNamedElement(tag, theNodeList);
        if (aNode != null && aNode.hasChildNodes() && aNode.getFirstChild().getNodeType() == 3) {
            return aNode.getFirstChild().getNodeValue();
        }
        return null;
    }

    @Override
    public boolean test(DataSet theData) {
        String value = null;
        try {
            value = this.getStringValue(theData);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doTest(value);
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        String value = (String)exeCtx.getValue(DataType.STRING);
        return this.doTest(value);
    }

    private boolean doTest(String value) {
        return value != null && this.myPattern.matcher(value).matches();
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String selectedFieldName = this.describeFieldName(dataSet);
        String testedFieldValue = null;
        try {
            String dataSetFieldValue = this.getStringValue(dataSet);
            String describedFieldValue = this.describeValue(dataSetFieldValue, dataSet);
            testedFieldValue = dataSetFieldValue == describedFieldValue ? "\"" + describedFieldValue + "\"" : describedFieldValue;
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doDescribeTrace(selectedFieldName, testedFieldValue);
    }

    @Override
    public String describeTrace(TraceContext traceCtx) {
        return this.doDescribeTrace(traceCtx.getFieldDescription(), traceCtx.getTraceValue());
    }

    private String doDescribeTrace(String selectedFieldName, String testedFieldValue) {
        String config = "\"" + this.myExpression.replace("|", " OR ") + "\"";
        return this.createTraceDescriptionText("RegularExpression", selectedFieldName, testedFieldValue, "match", config);
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }
}

