/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.StatusPanel;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.documents.OctetHexStringListDocument;
import ericsson.vareditor.documents.StringListDocument;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.text.PlainDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresNonMapField
public class OctetStringListProfile
extends AbstractConditionProfileV2
implements TestCaseGenerationConditionInterface,
FieldMappable {
    private static final String LABEL_STRING = "Strings";
    private static final String LABEL_MODE = "Mode";
    private static final String ASCII_MODE = "Ascii";
    private static final String HEX_MODE = "Hex";
    private static final String[] myModes = new String[]{"Ascii", "Hex"};
    private static final char[] SEPARATOR_VALUES = OctetStringListProfile.sortSeparator(new char[]{',', '\t', '\n', '\r', '\u0000'});
    private FieldDefinition myFieldDefinition;
    private String myOldStringValue;

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        TypedDropDownVariable<String> modeVar = new TypedDropDownVariable<String>(LABEL_MODE, myModes, ASCII_MODE);
        String defaultString = "";
        StringListDocument doc = new StringListDocument(defaultString.getClass());
        MultilineStringVariable stringsVar = new MultilineStringVariable(LABEL_STRING, defaultString, doc);
        l.add(modeVar);
        l.add(stringsVar);
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        TypedDropDownVariable<String> modeVar;
        MultilineStringVariable stringsVar;
        ArrayList<Variable> l = new ArrayList<Variable>();
        String strings = "";
        String mode = ASCII_MODE;
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            NodeList value;
            if (children.item(aa).getNodeType() != 1) continue;
            String k = children.item(aa).getNodeName();
            if (k.equalsIgnoreCase("String") && (value = children.item(aa).getChildNodes()).getLength() > 0) {
                strings = value.item(0).getNodeValue();
            }
            if (!k.equalsIgnoreCase(LABEL_MODE) || (value = children.item(aa).getChildNodes()).getLength() <= 0) continue;
            mode = value.item(0).getNodeValue();
        }
        if (mode.equals(myModes[1])) {
            OctetHexStringListDocument doc = new OctetHexStringListDocument(SEPARATOR_VALUES);
            stringsVar = new MultilineStringVariable(LABEL_STRING, strings, doc);
            modeVar = new TypedDropDownVariable<String>(LABEL_MODE, myModes, HEX_MODE);
            l.add(modeVar);
            l.add(stringsVar);
        } else {
            StringListDocument doc = new StringListDocument(strings.getClass());
            stringsVar = new MultilineStringVariable(LABEL_STRING, strings, doc);
            modeVar = new TypedDropDownVariable<String>(LABEL_MODE, myModes, ASCII_MODE);
            l.add(modeVar);
            l.add(stringsVar);
        }
        return l;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        return name + " = ...";
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String mode = VarListUtil.getValueStringForName(variables, LABEL_MODE);
        String text = VarListUtil.getValueStringForName(variables, LABEL_STRING);
        String info = "<b>" + this.getName() + "</b>\n";
        info = info + LABEL_STRING + " = " + text + "\n";
        info = info + LABEL_MODE + " = " + mode + "\n";
        info = info + this.getComment(variables);
        return this.multilineTooltipWrapper(info);
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String strings = VarListUtil.getValueStringForName(variables, LABEL_STRING);
        out.println("<String>" + strings + "</" + "String" + ">");
        String mode = VarListUtil.getValueStringForName(variables, LABEL_MODE);
        if (mode.equals(ASCII_MODE)) {
            out.println("<Mode>Ascii</Mode>");
        } else if (mode.equals(HEX_MODE)) {
            out.println("<Mode>Hex</Mode>");
        }
    }

    @Override
    public boolean parameterChanged(String ref, Variable value, List<Variable> vars) {
        boolean ret = false;
        if (LABEL_MODE.equals(ref)) {
            String newStrings;
            ret = true;
            String newSelection = value.getValueString();
            String oldStrings = VarListUtil.getStringValueForName(vars, LABEL_STRING);
            if (this.myOldStringValue != null && oldStrings.isEmpty()) {
                newStrings = this.myOldStringValue;
                this.myOldStringValue = null;
            } else {
                newStrings = "";
                String seperatorString = new String(SEPARATOR_VALUES);
                StringTokenizer next = new StringTokenizer(oldStrings, seperatorString, true);
                while (next.hasMoreTokens()) {
                    String token = next.nextToken();
                    if (this.isSeparator(token)) {
                        newStrings = newStrings + token;
                        continue;
                    }
                    if (newSelection.equals(ASCII_MODE)) {
                        OctetString octet;
                        try {
                            octet = OctetString.valueOf(token);
                        }
                        catch (IllegalArgumentException e) {
                            ret = false;
                            break;
                        }
                        if (!OctetString.isDisplayableUSAscii(octet)) {
                            newStrings = "";
                            this.myOldStringValue = oldStrings;
                            StatusPanel.getInstance().setStatusMsg("The string '" + octet + "' contains non-printable characters");
                            break;
                        }
                        newStrings = newStrings + octet.toAscii();
                        continue;
                    }
                    OctetString oStr = OctetString.fromAscii(token);
                    newStrings = newStrings + oStr.toString();
                }
            }
            if (ret) {
                PlainDocument doc = newSelection.equals(HEX_MODE) ? new OctetHexStringListDocument(SEPARATOR_VALUES) : new StringListDocument(newStrings.getClass());
                MultilineStringVariable stringsVar = new MultilineStringVariable(LABEL_STRING, newStrings, doc);
                VarListUtil.replaceVariableByLabel(vars, LABEL_STRING, stringsVar);
            }
        }
        return ret;
    }

    private boolean isSeparator(String theToken) {
        return theToken.length() == 1 && Arrays.binarySearch(SEPARATOR_VALUES, theToken.charAt(0)) >= 0;
    }

    private static char[] sortSeparator(char[] separator) {
        Arrays.sort(separator);
        return separator;
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element stringElement = XMLUtil.getFirstElementNamed("String", (Element)variableValueIterator);
        Element settingsElement = XMLUtil.getFirstElementNamed("Settings", (Element)testSettingsIterator);
        Element modeElement = XMLUtil.getFirstElementNamed(LABEL_MODE, (Element)variableValueIterator);
        ArrayList<String> testList = new ArrayList<String>();
        if (stringElement != null && settingsElement != null && modeElement != null) {
            String theString = XMLUtil.getFirstTextContent(stringElement);
            String settingsString = XMLUtil.getFirstTextContent(settingsElement);
            String mode = XMLUtil.getFirstTextContent(modeElement);
            StringTokenizer tokenizer = new StringTokenizer(theString, ",\t\n\r\u0000");
            ArrayList<String> stringList = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.length() <= 0) continue;
                stringList.add(token);
            }
            for (int i = 0; i < stringList.size(); ++i) {
                String hexString = (String)stringList.get(i);
                if (mode.equals(ASCII_MODE)) {
                    hexString = OctetString.fromAscii(hexString).toString();
                }
                testList.add(hexString);
                if (settingsString.equals("Single case")) break;
            }
        }
        if (testList.size() == 0) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        HashMap<String, Object> fieldInformation = new HashMap<String, Object>();
        fieldInformation.put(this.myFieldDefinition.getFieldName(), testList.toArray());
        return fieldInformation;
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        Element settingElement = XMLUtil.getFirstElementNamed("Settings", (Element)testSettingsIterator);
        String defaultString = "Single case";
        if (settingElement != null) {
            defaultString = XMLUtil.getFirstTextContent(settingElement);
        }
        TypedDropDownVariable<String> testSettingsDD = new TypedDropDownVariable<String>("Cases", new String[]{"Single case", "All cases"}, defaultString);
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        l.add(testSettingsDD);
        return l;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
        out.print("<TestSettings>");
        out.print("<Settings>" + vars.get(0).getValueString() + "</Settings>");
        out.print("</TestSettings>");
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myFieldDefinition = fieldDefinition;
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }
}

