/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.selectiontree.AbstractBaseConditionProfile;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.OctetStringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresNonMapField
public class OctetStringConditionProfile
extends AbstractBaseConditionProfile
implements FieldMappable,
TestCaseGenerationConditionInterface {
    private static String LABEL_COMPARATION = "Comparison";
    private static String LABEL_TEXT = "Text";
    private String[] myComparationChoices = new String[]{"Begins with", "Ends with", "Contains", "Exact match"};
    private FieldDefinition myFieldDef;

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        this.addInputVariables(l, "0", null, null);
        return l;
    }

    private void addInputVariables(List<Variable> l, String selection, String value, String modeValue) {
        Variable inputVariable;
        String varValue = value;
        if ("Ascii".equalsIgnoreCase(modeValue)) {
            varValue = OctetString.fromAscii(value).toString();
        }
        if (this.supportsInequalityOperators(inputVariable = this.createInputVariable(LABEL_TEXT, null, varValue, DataType.OCTETSTRING))) {
            ((OctetStringVariable)inputVariable).setModeAsString(modeValue);
            l.add(new DropDownVariable(LABEL_COMPARATION, (Object)selection, 1, this.myComparationChoices));
        }
        l.add(inputVariable);
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        NodeList children = iterator.getChildNodes();
        String comp = this.getElementValue("Comparation", children, "0");
        String text = this.getElementValue("Text", children, "");
        String modeValue = this.getElementValue("Mode", children, "Hex");
        this.addInputVariables(l, comp, text, modeValue);
        return l;
    }

    private String getElementValue(String tag, NodeList children, String defaultValue) {
        Element e = XMLUtil.getNamedElement(tag, children);
        return e != null ? XMLUtil.getFirstTextContent(e) : defaultValue;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = this.getName();
        String text = VarListUtil.getVariableForName(variables, LABEL_TEXT).toString();
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARATION);
        comp = comp == null ? this.myComparationChoices[3].toLowerCase() : ("-1".equals(comp) ? "Invalid" : this.myComparationChoices[Integer.valueOf(comp)].toLowerCase());
        return name + " " + comp + " " + text;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        OctetStringVariable var = (OctetStringVariable)VarListUtil.getVariableForName(variables, LABEL_TEXT);
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARATION);
        String text = var.getMode() ? var.getValueString() : ((OctetString)var.getValueObject()).toAscii();
        out.println(XMLUtil.wrapInTag("Text", text));
        out.println(XMLUtil.wrapInTag("Mode", var.getModeAsString()));
        out.println(XMLUtil.wrapInTag("Comparation", comp));
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String desc = this.getDescription(variables);
        return GuiUtil.descriptionToTooltip(desc, this.getName(), this.getComment(variables));
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element textElement = XMLUtil.getFirstElementNamed("Text", (Element)variableValueIterator);
        String mode = XMLUtil.getFirstTextContent(XMLUtil.getFirstElementNamed("Mode", (Element)variableValueIterator));
        HashMap<String, Object> fieldInformation = new HashMap<String, Object>();
        OctetString testValue = null;
        if (textElement != null) {
            if (mode.equals("Hex")) {
                testValue = new OctetString(XMLUtil.getFirstTextContent(textElement));
            } else if (mode.equals("Ascii")) {
                testValue = OctetString.fromAscii(XMLUtil.getFirstTextContent(textElement));
            }
        }
        if (testValue == null) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        fieldInformation.put(this.myFieldDef.getFieldName(), testValue);
        return fieldInformation;
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        return null;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myFieldDef = fieldDefinition;
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }
}

