/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.selectiontree.AbstractBaseConditionProfile;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.documents.DigitStringDocument;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresNonMapField
public class NumberStringConditionProfile
extends AbstractBaseConditionProfile
implements FieldMappable,
TestCaseGenerationConditionInterface {
    ClassRepository myRepository;
    FieldDefinition myFieldDef;
    private static String LABEL_COMPARATION = "Comparison";
    private static String LABEL_TEXT = "Text";
    private final String[] myComparationChoices = new String[]{"Begins with", "Ends with", "Contains", "Exact match"};

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        this.addInputVariables(l, "0", null);
        return l;
    }

    private void addInputVariables(List<Variable> l, String selection, String value) {
        Variable inputVariable = this.createInputVariable(LABEL_TEXT, null, value, DataType.STRING);
        if (this.supportsInequalityOperators(inputVariable)) {
            l.add(new DropDownVariable(LABEL_COMPARATION, (Object)selection, 1, this.myComparationChoices));
            String factoryDefault = inputVariable.getValueString();
            inputVariable = new StringVariable(LABEL_TEXT, factoryDefault, new DigitStringDocument());
        }
        l.add(inputVariable);
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String comp = "0";
        String text = null;
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            NodeList value;
            int bb;
            if (children.item(aa).getNodeType() != 1) continue;
            String k = children.item(aa).getNodeName();
            if (k.equalsIgnoreCase("Comparation") && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                comp = value.item(bb).getNodeValue();
            }
            if (!k.equalsIgnoreCase("Text") || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
            text = value.item(bb).getNodeValue();
        }
        this.addInputVariables(l, comp, text);
        return l;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        if (name == null) {
            name = this.getName();
        }
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARATION);
        comp = this.getDisplayableValueForComparison(comp);
        String text = VarListUtil.getVariableForName(variables, LABEL_TEXT).toString();
        return name + " " + comp + " " + text;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String text = VarListUtil.getValueStringForName(variables, LABEL_TEXT);
        out.println("<Text>" + text + "</" + "Text" + ">");
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARATION);
        if (comp == null) {
            comp = "3";
        }
        out.println("<Comparation>" + comp + "</" + "Comparation" + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARATION);
        comp = this.getDisplayableValueForComparison(comp);
        String text = VarListUtil.getVariableForName(variables, LABEL_TEXT).toString();
        String info = "<b>" + this.getName() + "</b> (" + comp + " " + text + ")";
        info = info + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    private String getDisplayableValueForComparison(String comp) {
        comp = comp == null ? this.myComparationChoices[3] : (comp.equals("-1") ? "Invalid" : this.myComparationChoices[Integer.valueOf(comp)].toLowerCase());
        return comp;
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element textElement = XMLUtil.getFirstElementNamed("Text", (Element)variableValueIterator);
        HashMap<String, Object> fieldInformation = new HashMap<String, Object>();
        String fieldName = this.myFieldDef.getFieldName();
        String testValue = null;
        if (textElement != null) {
            testValue = XMLUtil.getFirstTextContent(textElement);
            if (this.myFieldDef.getDataType().equals("OctetString")) {
                OctetString octetStringValue = new OctetString(testValue);
                fieldInformation.put(fieldName, octetStringValue);
            } else if (this.myFieldDef.getDataType().equals("BcdString")) {
                BcdString bcdStringValue = new BcdString(testValue);
                fieldInformation.put(fieldName, bcdStringValue);
            } else {
                fieldInformation.put(fieldName, testValue);
            }
        }
        if (fieldInformation.size() == 0) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        return fieldInformation;
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        return null;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myFieldDef = fieldDefinition;
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }
}

