/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.selectiontree.AbstractBaseConditionProfile;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.conditions.string.IPVersion;
import com.ericsson.ere.selectiontree.conditions.string.IPv6AddressConditionConfiguration;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import com.ericsson.vareditor.document.IPv4AddressSubnetDocument;
import com.ericsson.vareditor.document.IPv6AddressSubnetDocument;
import com.ericsson.vareditor.document.LimitingDocument;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.MultiBoolVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import org.w3c.dom.Node;

@RequiresNonMapField
public class IPv6AddressConditionProfile
extends AbstractBaseConditionProfile
implements FieldMappable {
    private static final String LABEL_VERSION = "Version";
    private static final String LABEL_SUBNET = "Subnet";
    private static final String KEY_SUBNET = "SubnetVar";

    @Override
    public List<Variable> getVariables() {
        return this.createInputVariables(null, null);
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        IPv6AddressConditionConfiguration conf = new IPv6AddressConditionConfiguration(new ParseContextAdapter(null, iterator, null));
        return this.createInputVariables(conf.getIPVersion(), conf.getSubnetString());
    }

    private List<Variable> createInputVariables(IPVersion theIPVersion, String theIPValue) {
        IPVersion ipVersion = theIPVersion != null ? theIPVersion : IPVersion.IPv4;
        LimitingDocument doc = ipVersion == IPVersion.IPv4 ? new IPv4AddressSubnetDocument() : new IPv6AddressSubnetDocument();
        String ipValue = theIPValue != null ? theIPValue : this.getFieldDefinition().getDefaultValue();
        Variable stringVar = this.createSubnetVariable(LABEL_SUBNET, doc, ipValue);
        MultiBoolVariable radioButton = new MultiBoolVariable(LABEL_VERSION, (Enum[])IPVersion.values(), (Enum[])new IPVersion[]{ipVersion}, false, true);
        ArrayList<Variable> varList = new ArrayList<Variable>();
        varList.add(radioButton);
        varList.add(stringVar);
        return varList;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        return this.getName() + " " + this.getVariableStringInfo(variables);
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        Variable typeVar = VarListUtil.getVariableForName(variables, LABEL_VERSION);
        String ipValue = VarListUtil.getValueStringForKey(variables, KEY_SUBNET);
        PluginConfigurationHelper.writeXML(new IPv6AddressConditionConfiguration(this.getIPVersion(typeVar), ipValue), out, indentLevel, indentMarker);
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        StringBuilder strBuilder = new StringBuilder("<b>").append(this.getName()).append("</b> (").append((CharSequence)this.getVariableStringInfo(variables)).append(")").append("\n").append(this.getComment(variables));
        return GuiUtil.multilineTooltipWrapper(strBuilder.toString());
    }

    @Override
    public boolean parameterChanged(String reference, Variable value, List<Variable> vars) {
        boolean varCreated = false;
        if (LABEL_VERSION.equals(reference) && value instanceof MultiBoolVariable) {
            LimitingDocument doc = this.getIPVersion(value) == IPVersion.IPv4 ? new IPv4AddressSubnetDocument() : new IPv6AddressSubnetDocument();
            this.resetDocument(doc);
            Variable var = this.createSubnetVariable(LABEL_SUBNET, doc, "");
            varCreated = VarListUtil.replaceVariableByKey(vars, KEY_SUBNET, var);
        }
        return varCreated;
    }

    private void resetDocument(Document doc) {
        try {
            doc.insertString(0, "", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Variable createSubnetVariable(String label, Document doc, String defaultValue) {
        StringVariable var = new StringVariable(label, defaultValue, doc);
        ((Variable)var).setKey(KEY_SUBNET);
        return var;
    }

    private StringBuilder getVariableStringInfo(List<Variable> variables) {
        Variable subnetVar = VarListUtil.getVariableForKey(variables, KEY_SUBNET);
        Variable versionVar = VarListUtil.getVariableForName(variables, LABEL_VERSION);
        StringBuilder strBuilder = new StringBuilder();
        String fieldValue = VarListUtil.getValueStringForName(variables, "Selected field");
        if (fieldValue != null) {
            strBuilder.append("(").append(fieldValue).append(") ");
        }
        return strBuilder.append(this.getIPVersion(versionVar).toString()).append(" ").append(LABEL_SUBNET).append(" = ").append(subnetVar);
    }

    private IPVersion getIPVersion(Variable typeVar) {
        return ((List)typeVar.getValueObject()).contains((Object)IPVersion.IPv4) ? IPVersion.IPv4 : IPVersion.IPv6;
    }
}

