/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.conditions.string.IPVersion;
import com.ericsson.ere.selectiontree.conditions.string.IPv6AddressConditionConfiguration;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexUser;
import com.ericsson.ere.selectiontree.util.SubNet;
import com.ericsson.ere.selectiontree.util.SubNetIPv4;
import com.ericsson.ere.selectiontree.util.SubNetIPv6;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.util.StringUtil;
import java.util.Objects;

@Immutable
public final class IPv6AddressCondition
extends ImmutableFieldMappableCondition
implements FieldKeyIndexUser,
TraceableV2 {
    private final SubNet mySubNet;
    private final String mySubNetString;
    private final DataType myFieldsDataType;
    private final IPVersion myIPVersion;

    private IPv6AddressCondition(ParseContext ctx) {
        super(ctx);
        IPv6AddressConditionConfiguration theIPv6Configuration = new IPv6AddressConditionConfiguration(ctx);
        this.myIPVersion = theIPv6Configuration.getIPVersion();
        if (Objects.isNull((Object)this.myIPVersion)) {
            throw new PluginCreationException("Faulty or missing IP version");
        }
        this.mySubNetString = theIPv6Configuration.getSubnetString();
        SubNet subNet = this.mySubNet = this.myIPVersion == IPVersion.IPv4 ? SubNetIPv4.parseIPv4SubNetFromString(this.mySubNetString) : SubNetIPv6.parseIPv6SubNetFromString(this.mySubNetString);
        if (this.mySubNet == null) {
            throw new PluginCreationException("Faulty or missing subnet value");
        }
        if (StringUtil.isEmptyString(this.key)) {
            throw new PluginCreationException("Field value is missing");
        }
        FieldDefinition ipAddressField = ctx.getClassRepository().getFieldDefinitionByName(this.key);
        this.myFieldsDataType = ipAddressField.getTypedDataType();
        if (this.myFieldsDataType != DataType.STRING && this.myFieldsDataType != DataType.OCTETSTRING) {
            throw new PluginCreationException("Field data type is not supported");
        }
    }

    public static IPv6AddressCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new IPv6AddressCondition(ctx);
    }

    @Override
    public boolean test(DataSet theData) {
        String ipAddressStringFieldValue = null;
        try {
            Object ipAddressFieldValue = this.extractFieldValueFromDataSet(theData, this.myField);
            ipAddressStringFieldValue = ipAddressFieldValue.toString();
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.mySubNet.containsIP(ipAddressStringFieldValue, this.myFieldsDataType);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (Objects.isNull(this.myFieldsDataType) ? 0 : this.myFieldsDataType.hashCode());
        result = 31 * result + (Objects.isNull(this.mySubNet) ? 0 : this.mySubNet.hashCode());
        result = 31 * result + (Objects.isNull(this.mySubNetString == null) ? 0 : this.mySubNetString.hashCode());
        result = 31 * result + (Objects.isNull((Object)this.myIPVersion) ? 0 : this.myIPVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (Objects.isNull(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass() || !super.equalsImpl(obj)) {
            return false;
        }
        IPv6AddressCondition other = (IPv6AddressCondition)obj;
        if (this.myFieldsDataType != other.myFieldsDataType) {
            return false;
        }
        if (Objects.isNull(this.mySubNet) ? Objects.nonNull(other.mySubNet) : !this.mySubNet.equals(other.mySubNet)) {
            return false;
        }
        if (Objects.isNull(this.mySubNetString) ? Objects.nonNull(other.mySubNetString) : !this.mySubNetString.equals(other.mySubNetString)) {
            return false;
        }
        return !(Objects.isNull((Object)this.myIPVersion) ? Objects.nonNull((Object)other.myIPVersion) : !this.myIPVersion.equals((Object)other.myIPVersion));
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String conditionConfigValue = this.formatDescribedValue(this.describeValue(this.mySubNetString, dataSet), this.mySubNetString);
        String fieldValue = null;
        try {
            Object dataSetFieldValue = this.extractFieldValueFromDataSet(dataSet, this.myField);
            if (Objects.nonNull(dataSetFieldValue)) {
                fieldValue = this.formatDescribedValue(this.describeValue(dataSetFieldValue, dataSet), dataSetFieldValue.toString());
            }
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.createTraceDescriptionText(this.myIPVersion.toString() + "Address", this.describeFieldName(dataSet), fieldValue, "matches", conditionConfigValue);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
    }

    private String formatDescribedValue(String describedValue, String compareString) {
        return describedValue.equals(compareString) ? "\"" + describedValue + "\"" : describedValue;
    }
}

