/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.numberseries;

import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.dataset.DefaultDataDescriber;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.selectiontree.AbstractBaseConditionProfile;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.conditions.numberseries.ValueInCollectionConditionConfiguration;
import com.ericsson.ere.selectiontree.conditions.numberseries.ValueInCollectionConditionProfileContract;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.util.StringUtil;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

@RequiresNonMapField
@Constrainable(contractClass=ValueInCollectionConditionProfileContract.class)
public class ValueInCollectionConditionProfile
extends AbstractBaseConditionProfile
implements FieldMappable {
    public static final String LBL_COLLECTION = "Collection field";
    public static final String LBL_OPERATOR = "Operator";
    private static final String MSG_NO_FIELDS_EXIST = "No available fields found";

    @Override
    public List<Variable> getVariables() {
        return this.createVariables(null, null);
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ValueInCollectionConditionConfiguration conf = new ValueInCollectionConditionConfiguration(new ParseContextAdapter(null, iterator, null));
        return this.createVariables(conf.getField(), conf.getOperator().name());
    }

    private List<Variable> createVariables(String field, String operator) {
        BaseVariable collectionInputVariable;
        ArrayList<Variable> variableList = new ArrayList<Variable>(2);
        FieldDefinition fieldDefinition = this.myRepository.getFieldDefinitionByName(this.getFieldName());
        List<FieldDefinition> fieldNames = this.extractFieldNames(fieldDefinition.getTypedDataType());
        if (fieldNames.isEmpty()) {
            collectionInputVariable = new NotAllowedVariable(LBL_COLLECTION, MSG_NO_FIELDS_EXIST);
        } else {
            FieldDefinition fieldNameToSelect = this.extractFieldNameToSelect(fieldNames, field);
            collectionInputVariable = FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(LBL_COLLECTION, null, fieldNames, fieldNameToSelect);
        }
        TypedDropDownVariable<String> operatorInputVariable = operator != null ? new TypedDropDownVariable<String>(LBL_OPERATOR, ValueInCollectionConditionConfiguration.ValueInCollectionConditionOperator.getSupportedOperationsLabels(), ValueInCollectionConditionConfiguration.ValueInCollectionConditionOperator.getSupportedOperations(), operator) : new TypedDropDownVariable<String>(LBL_OPERATOR, ValueInCollectionConditionConfiguration.ValueInCollectionConditionOperator.getSupportedOperationsLabels(), (T[])ValueInCollectionConditionConfiguration.ValueInCollectionConditionOperator.getSupportedOperations());
        variableList.add(operatorInputVariable);
        variableList.add(collectionInputVariable);
        return variableList;
    }

    private FieldDefinition extractFieldNameToSelect(List<FieldDefinition> allFields, String fieldName) {
        FieldDefinition defaultFieldName = allFields.get(0);
        if (!StringUtil.isEmptyString(fieldName)) {
            defaultFieldName = this.myRepository.getFieldDefinitionByName(fieldName);
        }
        return defaultFieldName;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        ValueInCollectionConditionConfiguration conf = new ValueInCollectionConditionConfiguration(VarListUtil.getValueStringForName(variables, LBL_COLLECTION), VarListUtil.getStringValueForName(variables, LBL_OPERATOR));
        PluginConfigurationHelper.writeXML(conf, out, indentLevel, indentMarker);
    }

    @Override
    public String getDescription(List<Variable> variables) {
        DefaultDataDescriber dataDescriber = new DefaultDataDescriber();
        Object valueObject = VarListUtil.getValueForName(variables, LBL_COLLECTION);
        String value = dataDescriber.describeObject(valueObject, DataType.STRING);
        Variable operationVariable = VarListUtil.getVariableForName(variables, LBL_OPERATOR);
        StringBuilder sb = new StringBuilder(super.getDescription(variables));
        return sb.append(" ").append(operationVariable.getValueString()).append(" in ").append(value).toString();
    }

    private List<FieldDefinition> extractFieldNames(DataType dataType) {
        return AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myRepository).withFilter(this.createFieldFilter(dataType)).withConstraints(this, null).buildFieldDefinitionList();
    }

    private List<FieldDefinition> getSupportedFieldList(ClassRepository classRepository, DataType dataType) {
        return FieldOrientedPluginProfileUtil.getSupportedFields(ClassRepositoryHelper.extractVisibleFields(classRepository), this.createFieldFilter(dataType));
    }

    protected List<FieldDefinition> getSupportedFieldList(ClassRepository classRepository) {
        return this.getSupportedFieldList(classRepository, null);
    }

    protected FieldFilter createFieldFilter(DataType dataType) {
        return new GeneralFieldFilter(dataType);
    }

    protected class GeneralFieldFilter
    implements FieldFilter {
        private final DataType myDataType;

        GeneralFieldFilter(DataType dataType) {
            this.myDataType = dataType;
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            boolean retVal;
            boolean bl = retVal = field.isComplexType() && (FieldOrientedPluginProfileUtil.fieldIsParameterTypeIn(field) || FieldOrientedPluginProfileUtil.fieldIsParameterTypeOut(field) || FieldOrientedPluginProfileUtil.fieldIsParameterTypeVariable(field));
            if (retVal) {
                if (this.myDataType != null) {
                    retVal &= this.myDataType == field.getTypedDataType();
                } else {
                    boolean supportedDataType = false;
                    for (DataType type : ValueInCollectionConditionConfiguration.getSupportedDataTypes()) {
                        if (type != field.getTypedDataType()) continue;
                        supportedDataType = true;
                        break;
                    }
                    retVal &= supportedDataType;
                }
            }
            return retVal;
        }
    }
}

