/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.numberseries;

import com.ericsson.ere.selectiontree.AnnotationBasedPluginConfiguration;
import com.ericsson.ere.selectiontree.ParseContext;
import ericsson.ere.datatype.DataType;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ValueInCollectionConditionConfiguration
extends AnnotationBasedPluginConfiguration {
    public static final String TAG_COLLECTION_FIELD = "CollectionField";
    public static final String TAG_OPERATOR = "Operator";
    private String myField;
    private ValueInCollectionConditionOperator myOperator;

    public ValueInCollectionConditionConfiguration(ParseContext ctx) {
        super(ctx);
        Element fieldNode = XMLUtil.getFirstElementNamed(TAG_COLLECTION_FIELD, (Element)ctx.getXMLNode());
        this.myField = fieldNode != null ? XMLUtil.getFirstTextContent(fieldNode) : null;
        Element operatorNode = XMLUtil.getFirstElementNamed(TAG_OPERATOR, (Element)ctx.getXMLNode());
        String operator = operatorNode != null ? XMLUtil.getFirstTextContent(operatorNode) : "";
        try {
            this.myOperator = ValueInCollectionConditionOperator.valueOf(operator);
        }
        catch (IllegalArgumentException e) {
            this.myOperator = null;
        }
    }

    public ValueInCollectionConditionConfiguration(String field, String operator) {
        super(null);
        this.myField = field;
        try {
            this.myOperator = ValueInCollectionConditionOperator.valueOf(operator);
        }
        catch (IllegalArgumentException e) {
            this.myOperator = null;
        }
    }

    @Override
    public void appendXML(Node parent) {
        Element valueElement = parent.getOwnerDocument().createElement(TAG_COLLECTION_FIELD);
        valueElement.setTextContent(this.myField);
        parent.appendChild(valueElement);
        valueElement = parent.getOwnerDocument().createElement(TAG_OPERATOR);
        valueElement.setTextContent(this.myOperator.name());
        parent.appendChild(valueElement);
    }

    public String getField() {
        return this.myField;
    }

    public ValueInCollectionConditionOperator getOperator() {
        return this.myOperator;
    }

    public static DataType[] getSupportedDataTypes() {
        return new DataType[]{DataType.STRING, DataType.INTEGER};
    }

    public static enum ValueInCollectionConditionOperator {
        StartsWith{

            @Override
            String getOperationLabel() {
                return "Starts with any collection entry";
            }

            @Override
            public String getPrintString() {
                return "starts with entry in";
            }
        }
        ,
        EndsWith{

            @Override
            String getOperationLabel() {
                return "Ends with any collection entry";
            }

            @Override
            public String getPrintString() {
                return "ends with entry in";
            }
        }
        ,
        Equals{

            @Override
            String getOperationLabel() {
                return "Equal to any collection entry";
            }

            @Override
            public String getPrintString() {
                return "is equal to entry in";
            }
        };


        abstract String getOperationLabel();

        abstract String getPrintString();

        public static String[] getSupportedOperations() {
            return new String[]{StartsWith.name(), EndsWith.name(), Equals.name()};
        }

        public static String[] getSupportedOperationsLabels() {
            return new String[]{StartsWith.getOperationLabel(), EndsWith.getOperationLabel(), Equals.getOperationLabel()};
        }
    }
}

