/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.numberseries;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.conditions.numberseries.NumberSeriesConditionConfiguration;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import com.ericsson.vareditor.document.DigitListDocument;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@RequiresNonMapField
public class NumberSeriesConditionProfile
extends AbstractConditionProfileV2
implements FieldMappable,
TestCaseGenerationConditionInterface {
    static String LABEL_NUMBER = "Numbers";
    @Deprecated
    public static final char[] ALLOWED_CHARS = new char[]{' ', '-', ',', '\t', '\n', '\r', '\u0000', '#', '*', 'A', 'B', 'C', 'D', 'E', 'F', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Pattern SEPARATORS = Pattern.compile("[ ,\\t\\n\\r]");
    private FieldDefinition myTestFieldDefinition;

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String number = VarListUtil.getValueStringForName(variables, LABEL_NUMBER);
        NumberSeriesConditionConfiguration conf = new NumberSeriesConditionConfiguration(number);
        PluginConfigurationHelper.writeXML(conf, out, indentLevel, indentMarker);
    }

    @Override
    public String getDescription(List<Variable> variables) {
        return VarListUtil.getValueStringForName(variables, "Name") + " = ...";
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String text = VarListUtil.getValueStringForName(variables, LABEL_NUMBER);
        String info = "<b>" + name + "</b>\n";
        info = info + LABEL_NUMBER + " = " + text + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public List<Variable> getVariables() {
        return this.getVariables("");
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        NumberSeriesConditionConfiguration conf = new NumberSeriesConditionConfiguration(new ParseContextAdapter(null, iterator, null));
        return this.getVariables(conf.getNumbers());
    }

    private List<Variable> getVariables(String number) {
        DigitListDocument doc = new DigitListDocument(SEPARATORS);
        MultilineStringVariable var = new MultilineStringVariable(LABEL_NUMBER, number, doc);
        return Arrays.asList(var);
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        Element settingElement = XMLUtil.getFirstElementNamed("Settings", (Element)testSettingsIterator);
        String defaultString = "Single values and boundaries";
        if (settingElement != null) {
            defaultString = XMLUtil.getFirstTextContent(settingElement);
        }
        DropDownVariable testSettingsDD = new DropDownVariable("Cases", (Object)defaultString, (Object[])new String[]{"Single case", "Single values and boundaries", "All cases"});
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        l.add(testSettingsDD);
        return l;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
        out.print("<TestSettings>");
        out.print("<Settings>" + vars.get(0).getValueString() + "</Settings>");
        out.print("</TestSettings>");
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element numberElement = XMLUtil.getFirstElementNamed("Number", (Element)variableValueIterator);
        Element settingsElement = XMLUtil.getFirstElementNamed("Settings", (Element)testSettingsIterator);
        ArrayList<String> valueList = new ArrayList<String>();
        if (numberElement != null && settingsElement != null) {
            String settings = XMLUtil.getFirstTextContent(settingsElement);
            String numberString = XMLUtil.getFirstTextContent(numberElement);
            StringTokenizer tokenizer = new StringTokenizer(numberString, " ,\n\t\r\u0000");
            if (tokenizer.countTokens() > 0) {
                if (settings.equals("Single case")) {
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.length() <= 0) continue;
                        if (token.contains("-")) {
                            String[] rangeBoundaries = token.split("-");
                            valueList.add(rangeBoundaries[0]);
                        } else {
                            valueList.add(token);
                        }
                        break;
                    }
                } else if (settings.equals("Single values and boundaries")) {
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.contains("-")) {
                            String[] rangeBoundaries = token.split("-");
                            valueList.add(rangeBoundaries[0]);
                            valueList.add(rangeBoundaries[1]);
                            continue;
                        }
                        valueList.add(token);
                    }
                } else {
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.contains("-")) {
                            valueList.addAll(this.getAllStringsInIntervall(token));
                            continue;
                        }
                        valueList.add(token);
                    }
                }
            }
        }
        if (valueList.size() == 0) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        return Collections.singletonMap(this.myTestFieldDefinition.getFieldName(), valueList.toArray());
    }

    private ArrayList<String> getAllStringsInIntervall(String valueString) {
        String[] rangeBoundaries = valueString.split("-");
        ArrayList<String> testValues = new ArrayList<String>();
        BigInteger fromValue = new BigInteger(rangeBoundaries[0]);
        BigInteger toValue = new BigInteger(rangeBoundaries[1]);
        if (fromValue.compareTo(toValue) <= 0) {
            while (fromValue.compareTo(toValue) <= 0) {
                testValues.add(fromValue.toString());
                fromValue = fromValue.add(BigInteger.ONE);
            }
        }
        return testValues;
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myTestFieldDefinition = fieldDefinition;
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }
}

