/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.numberlist;

import com.ericsson.ere.selectiontree.conditions.field.NumberRangeEditorSupport;
import com.ericsson.ere.selectiontree.conditions.numberlist.AbstractNumberListCondition;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.interfaces.SimulationEditor;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.NumberRangeEditor;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.documents.UnsignedNumberDocument;
import ericsson.vareditor.documents.UnsignedNumberListDocument;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.UIntegerVariable;
import ericsson.vareditor.variable.ULongVariable;
import ericsson.vareditor.variable.UShortVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractUnsignedNumberListConditionProfile
extends AbstractConditionProfileV2
implements NumberRangeEditorSupport {
    public static final String LBL_VALUE = "Values";
    public static final String SHORT_LABEL = "Values";
    private BigInteger min_value = UnsignedNumberDocument.BIGINT_ZERO;
    private BigInteger max_value = UnsignedNumberDocument.MAX_ULONG;
    public static final char[] ALLOWED_CHARS = new char[]{' ', ',', '\n', '\r', '\u0000'};
    private ClassRepository myRepository = null;
    private Variable myNumberRangeVariable = null;

    @Override
    public List<Variable> getVariables() {
        this.setMinMaxValue();
        ArrayList<Variable> l = new ArrayList<Variable>();
        String str = "";
        UnsignedNumberListDocument doc = new UnsignedNumberListDocument(this.min_value, this.max_value, ALLOWED_CHARS, true);
        l.add(new MultilineStringVariable("Values", str, doc));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        this.setMinMaxValue();
        String value = AbstractNumberListCondition.getValuesString(iterator);
        ArrayList<Variable> l = new ArrayList<Variable>();
        UnsignedNumberListDocument doc = new UnsignedNumberListDocument(this.min_value, this.max_value, ALLOWED_CHARS, true);
        l.add(new MultilineStringVariable("Values", value, doc));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String text = VarListUtil.getValueStringForName(variables, "Values");
        out.println("<Values>" + text + "</" + "Values" + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String text = VarListUtil.getValueStringForName(variables, "Values");
        String info = "<b>" + name + "</b>\n";
        info = info + "Values = " + text + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public String getDescription(List<Variable> variables) {
        return VarListUtil.getValueStringForName(variables, "Name") + " = ...";
    }

    @Override
    public Map<String, Object> getDisplayValues(Node iterator, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev == null ? new HashMap<String, Object>() : prev;
        String value = "";
        NodeList children = iterator.getChildNodes();
        Element node = XMLUtil.getNamedElement("Values", children);
        if (node != null && (value = XMLUtil.getFirstTextContent(node)) == null) {
            value = "";
        }
        displayValuesMap.put("Values", value);
        return displayValuesMap;
    }

    @Override
    public boolean needsRepository() {
        return true;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        this.myRepository = repository;
    }

    private void setMinMaxValue() {
        try {
            if (this.myRepository != null) {
                String fieldName = this.myRepository.getConditionFieldName(this.getName());
                FieldDefinition fieldDef = this.myRepository.getFieldDefinitionByName(fieldName);
                XMLInitializable editComponent = fieldDef.createUtil("EditComponent");
                if (editComponent != null) {
                    SimulationEditor simEdit = (SimulationEditor)((Object)editComponent);
                    simEdit.setFieldDefinition(fieldDef);
                    if (simEdit instanceof NumberRangeEditor) {
                        this.min_value = new BigInteger(((NumberRangeEditor)simEdit).getMinValueString());
                        this.max_value = new BigInteger(((NumberRangeEditor)simEdit).getMaxValueString());
                    }
                }
            } else if (this.myNumberRangeVariable != null) {
                if (this.myNumberRangeVariable instanceof ULongVariable) {
                    this.min_value = ((ULongVariable)this.myNumberRangeVariable).getMinValue();
                    this.max_value = ((ULongVariable)this.myNumberRangeVariable).getMaxValue();
                } else if (this.myNumberRangeVariable instanceof UIntegerVariable) {
                    this.min_value = ((UIntegerVariable)this.myNumberRangeVariable).getMinValue();
                    this.max_value = ((UIntegerVariable)this.myNumberRangeVariable).getMaxValue();
                } else if (this.myNumberRangeVariable instanceof UShortVariable) {
                    this.min_value = ((UShortVariable)this.myNumberRangeVariable).getMinValue();
                    this.max_value = ((UShortVariable)this.myNumberRangeVariable).getMaxValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setNumberRangeVariable(Variable rangeVariable) {
        this.myNumberRangeVariable = rangeVariable;
    }
}

