/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.numberlist;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.numberlist.AbstractNumberListCondition;
import ericsson.ere.datatype.DataType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

@Immutable
public abstract class AbstractUnsignedNumberListCondition
extends AbstractNumberListCondition {
    public AbstractUnsignedNumberListCondition(ParseContext ctx, DataType dataType) {
        super(ctx, dataType);
    }

    @Override
    protected List<Number> extractNumbersFromRange(String startNumberString, String stopNumberString, DataType dataType) {
        BigInteger start = new BigInteger(startNumberString);
        BigInteger stop = new BigInteger(stopNumberString);
        ArrayList<Number> numberList = new ArrayList<Number>();
        BigInteger theNumber = start;
        while (theNumber.compareTo(stop) <= 0) {
            Number number;
            switch (dataType) {
                case UNSIGNEDSHORT: {
                    number = theNumber.shortValue();
                    break;
                }
                case UNSIGNEDINT: {
                    number = theNumber.intValue();
                    break;
                }
                case UNSIGNEDLONG: {
                    number = theNumber.longValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Data type: " + dataType + " is not supported");
                }
            }
            numberList.add(number);
            theNumber = theNumber.add(BigInteger.ONE);
        }
        return numberList;
    }

    @Override
    protected Number interpretNumber(String aNumber, DataType aDataType) {
        Number number;
        BigInteger bigInt = new BigInteger(aNumber);
        switch (aDataType) {
            case UNSIGNEDSHORT: {
                number = bigInt.shortValue();
                break;
            }
            case UNSIGNEDINT: {
                number = bigInt.intValue();
                break;
            }
            case UNSIGNEDLONG: {
                number = bigInt.longValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type: " + aDataType + " is not supported");
            }
        }
        return number;
    }

    @Override
    protected boolean rangeIsValid(String startNumberString, String stopNumberString) {
        BigInteger start = new BigInteger(startNumberString);
        BigInteger stop = new BigInteger(stopNumberString);
        return start.compareTo(stop) <= 0;
    }

    @Override
    public boolean test(DataSet dataset) {
        try {
            Number theNumber = (Number)this.myField.getValueFromDataSet(dataset);
            return this.myNumbers.contains(theNumber);
        }
        catch (DataSetValueNotFoundException e) {
            return false;
        }
    }
}

