/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.numberlist;

import com.ericsson.ere.selectiontree.conditions.numberlist.AbstractNumberListCondition;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.interfaces.SimulationEditor;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.NumberRangeEditor;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.vareditor.documents.NumberListDocument;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public abstract class AbstractNumberListConditionProfile
extends AbstractConditionProfileV2 {
    public static final String LBL_VALUE = "Values";
    public static final String SHORT_LABEL = "Values";
    private long min_value = Long.MIN_VALUE;
    private long max_value = Long.MAX_VALUE;
    public static final char[] ALLOWED_CHARS = new char[]{' ', ',', '\n', '\r', '\u0000'};
    private ClassRepository myRepository;

    @Override
    public List<Variable> getVariables() {
        this.setMinMaxValue();
        ArrayList<Variable> l = new ArrayList<Variable>();
        String str = "";
        NumberListDocument doc = new NumberListDocument(this.min_value, this.max_value, ALLOWED_CHARS, true);
        l.add(new MultilineStringVariable("Values", str, doc));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        this.setMinMaxValue();
        String value = AbstractNumberListCondition.getValuesString(iterator);
        ArrayList<Variable> l = new ArrayList<Variable>();
        NumberListDocument doc = new NumberListDocument(this.min_value, this.max_value, ALLOWED_CHARS, true);
        l.add(new MultilineStringVariable("Values", value, doc));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String text = VarListUtil.getValueStringForName(variables, "Values");
        out.println("<Values>" + text + "</" + "Values" + ">");
    }

    @Override
    public String getDescription(List<Variable> variables) {
        return VarListUtil.getValueStringForName(variables, "Name") + " = ...";
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String text = VarListUtil.getValueStringForName(variables, "Values");
        String info = "<b>" + name + "</b>\n";
        info = info + "Values = " + text + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public Map<String, Object> getDisplayValues(Node iterator, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev == null ? new HashMap<String, Object>() : prev;
        displayValuesMap.put("Values", AbstractNumberListCondition.getValuesString(iterator));
        return displayValuesMap;
    }

    @Override
    public boolean needsRepository() {
        return true;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        this.myRepository = repository;
    }

    private void setMinMaxValue() {
        try {
            String fieldName = this.myRepository.getConditionFieldName(this.getName());
            FieldDefinition fieldDef = this.myRepository.getFieldDefinitionByName(fieldName);
            XMLInitializable editComponent = fieldDef.createUtil("EditComponent");
            if (editComponent != null) {
                SimulationEditor simEdit = (SimulationEditor)((Object)editComponent);
                simEdit.setFieldDefinition(fieldDef);
                if (simEdit instanceof NumberRangeEditor) {
                    this.min_value = ((NumberRangeEditor)simEdit).getLongMinValue();
                    this.max_value = ((NumberRangeEditor)simEdit).getLongMaxValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

