/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.numberlist;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public abstract class AbstractNumberListCondition
extends ImmutableCondition
implements TraceableV2 {
    static final String TAG_VALUES = "Values";
    protected final Set<Number> myNumbers;
    protected final DataSetField myField;

    protected AbstractNumberListCondition(ParseContext ctx, DataType dataType) {
        super(ctx);
        String values = AbstractNumberListCondition.getValuesString(ctx.getXMLNode());
        FieldDefinition def = ctx.getClassRepository().getFieldDefinitionByName(this.key);
        this.myField = def == null ? new DataSetField(this.key, this.tag, this.tagIsSet, dataType, false) : new DataSetField(def, dataType);
        this.myNumbers = Collections.unmodifiableSortedSet(this.extractNumbers(values));
        if (def == null) {
            throw new PluginCreationException("Referenced field " + this.key + " does not exist.");
        }
    }

    protected static String getValuesString(Node iterator) {
        String[] tags;
        for (String tagToTest : tags = new String[]{TAG_VALUES, "Class", "Type", "Id", "K", "Zone"}) {
            if (((Element)iterator).getElementsByTagName(tagToTest).getLength() <= 0) continue;
            return XMLUtil.getFirstTextContent(XMLUtil.getNamedElement(tagToTest, iterator.getChildNodes()));
        }
        throw new PluginCreationException("No valid tag for value was found.");
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myField == null ? 0 : this.myField.hashCode());
        result = 31 * result + (this.myNumbers == null ? 0 : this.myNumbers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNumberListCondition other = (AbstractNumberListCondition)obj;
        if (this.myField == null ? other.myField != null : !this.myField.equals(other.myField)) {
            return false;
        }
        return !(this.myNumbers == null ? other.myNumbers != null : !this.myNumbers.equals(other.myNumbers));
    }

    @Override
    public boolean test(DataSet dataset) {
        try {
            Number theNumber = (Number)this.myField.getValueFromDataSet(dataset);
            return this.myNumbers.contains(theNumber.longValue());
        }
        catch (DataSetValueNotFoundException e) {
            return false;
        }
    }

    private TreeSet<Number> extractNumbers(String theNumbers) {
        TreeSet<Number> numbers = new TreeSet<Number>();
        StringTokenizer next = new StringTokenizer(theNumbers, " ,\t\n\r\u0000", false);
        while (next.hasMoreTokens()) {
            String token = next.nextToken();
            int rangeIndicatorPos = token.indexOf("-");
            if (rangeIndicatorPos == -1) {
                try {
                    Number number = this.interpretNumber(token, this.myField.getDataType());
                    numbers.add(number);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new PluginCreationException("Failed to parse number '" + token + "'", nfe);
                }
            }
            try {
                String firstNumber = token.substring(0, rangeIndicatorPos);
                String lastNumber = token.substring(rangeIndicatorPos + 1, token.length());
                if (this.rangeIsValid(firstNumber, lastNumber)) {
                    numbers.addAll(this.extractNumbersFromRange(firstNumber, lastNumber, this.myField.getDataType()));
                    continue;
                }
                throw new PluginCreationException("Invalid format of input " + firstNumber + "-" + lastNumber + ", incorrect number range");
            }
            catch (NumberFormatException nfe) {
                throw new PluginCreationException("Could not parse number range '" + token + "', malformed input.", nfe);
            }
            catch (NullPointerException npe) {
                throw new PluginCreationException("Could not parse number range '" + token + "', malformed input.", npe);
            }
        }
        return numbers;
    }

    protected Number interpretNumber(String aNumber, DataType aDataType) {
        Long number = Long.parseLong(aNumber);
        return number;
    }

    protected boolean rangeIsValid(String startNumberString, String stopNumberString) {
        long stopValue;
        long startValue = (Long)DataType.LONG.parseValue(startNumberString);
        return startValue < (stopValue = ((Long)DataType.LONG.parseValue(stopNumberString)).longValue());
    }

    protected List<Number> extractNumbersFromRange(String startNumberString, String stopNumberString, DataType dataType) {
        if (dataType != DataType.SHORT && dataType != DataType.INTEGER && dataType != DataType.LONG) {
            throw new IllegalArgumentException("Data type: " + dataType + " is not supported");
        }
        long startValue = (Long)this.interpretNumber(startNumberString, dataType);
        long stopValue = (Long)this.interpretNumber(stopNumberString, dataType);
        ArrayList<Number> numbers = new ArrayList<Number>();
        for (long currentValue = startValue; currentValue <= stopValue; ++currentValue) {
            numbers.add(currentValue);
        }
        return numbers;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String fieldValueString = null;
        try {
            Object fieldValue = this.myField.getValueFromDataSet(dataSet);
            fieldValueString = this.describeValue(fieldValue, dataSet);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.createTraceDescriptionText(this.getConditionNameForTrace(), this.getKey(), fieldValueString, "is found", "in list");
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, null, tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    public String getConditionNameForTrace() {
        return "";
    }
}

