/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.number;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public final class UnsIntInArrayCondition
extends ImmutableFieldMappableCondition
implements TraceableV2 {
    private final long myValue;
    private static final Object MAP = new Object();

    private UnsIntInArrayCondition(ParseContext context) {
        super(context);
        Node config = context.getXMLNode();
        String theValue = "";
        String TAG = "Value".toLowerCase();
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().toLowerCase().equals(TAG)) continue;
            theValue = XMLUtil.getFirstTextContent(child);
            break;
        }
        this.myValue = Long.parseLong(theValue);
    }

    public static UnsIntInArrayCondition create(ParseContext context, TariffStructureNode[] children) {
        return new UnsIntInArrayCondition(context);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (int)(this.myValue ^ this.myValue >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnsIntInArrayCondition other = (UnsIntInArrayCondition)obj;
        return this.myValue == other.myValue;
    }

    @Override
    public boolean test(DataSet theData) {
        Map<?, ?> data;
        try {
            data = this.getMapFromDataSet(theData);
        }
        catch (DataSetValueNotFoundException e) {
            return false;
        }
        boolean result = false;
        for (Object value : data.values()) {
            Number testValue = (Number)value;
            if (testValue == null || testValue.longValue() != this.myValue) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String describedConditionValue = this.describeValue(this.myValue, dataSet);
        String testedFieldValue = tp.getInfo(MAP) != null ? "<ARRAY>" : null;
        return this.createTraceDescriptionText("UnsIntInArray", this.describeFieldName(dataSet), testedFieldValue, "contains", describedConditionValue);
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        try {
            LinkedHashMap map = new LinkedHashMap(this.getMapFromDataSet(tp.getPreDataSet()));
            tp.addInfo(MAP, map);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    private Map<?, ?> getMapFromDataSet(DataSet theData) {
        if (this.tagIsSet) {
            return theData.getDataAsMap(this.tag, (DataType)null);
        }
        return theData.getDataAsMap(this.key, null);
    }
}

