/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.number;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.number.AbstractImmutableNumberCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public final class UIntegerCondition
extends AbstractImmutableNumberCondition<Integer>
implements ContextCondition {
    protected static final String[] tagsToTest = new String[]{"IntValue", "ShortValue", "Case", "Code", "Status", "Type"};

    private UIntegerCondition(ParseContext context) {
        super(context, "UInteger", DataType.UNSIGNEDINT);
    }

    public static UIntegerCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new UIntegerCondition(ctx);
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.UNSIGNEDINT);
    }

    @Override
    protected String getValueString(Node config) {
        for (String tagToTest : tagsToTest) {
            if (((Element)config).getElementsByTagName(tagToTest).getLength() <= 0) continue;
            return XMLUtil.getFirstTextContent(XMLUtil.getNamedElement(tagToTest, config.getChildNodes()));
        }
        throw new NullPointerException();
    }

    @Deprecated
    public boolean isFloat() {
        return false;
    }

    @Override
    protected Integer parseValue(String value) {
        return Long.valueOf(value).intValue();
    }

    @Override
    protected String getValueAsString(Integer value) {
        return DataType.UIntegerParser(value);
    }

    @Override
    protected Integer getValueFromDataSet(DataSet dataset) {
        return this.fetchNumberFromDataSet(dataset).intValue();
    }

    @Override
    protected boolean evaluate(Integer value, Integer dataSetValue) throws Exception {
        return this.compareUnsignedNumbers(value.intValue(), dataSetValue.intValue());
    }

    @Override
    protected String describeValue(Object value, DataSet dataSet) {
        ClassRepository repo = UIntegerCondition.getClassRepository(dataSet);
        FieldDefinition field = repo.getFieldDefinitionByName(this.key);
        return field.getTypedDataType() == DataType.UNSIGNEDINT ? super.describeValue(value, dataSet) : this.getValueAsString((Integer)value);
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        return this.doTest((Integer)exeCtx.getValue(DataType.INTEGER));
    }
}

