/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.number;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.number.AbstractImmutableNumberCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.util.TreeParseUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public final class ShortCondition
extends AbstractImmutableNumberCondition<Short>
implements ContextCondition {
    protected static final String[] tagsToTest = new String[]{"IntValue", "ShortValue", "Case", "Code", "Status", "Type"};

    protected ShortCondition(ParseContext ctx) {
        super(ctx, "Short", DataType.SHORT);
    }

    public static ShortCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new ShortCondition(ctx);
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.SHORT);
    }

    @Override
    protected String getValueString(Node config) {
        for (String tagToTest : tagsToTest) {
            if (((Element)config).getElementsByTagName(tagToTest).getLength() <= 0) continue;
            return XMLUtil.getFirstTextContent(XMLUtil.getNamedElement(tagToTest, config.getChildNodes()));
        }
        throw new NullPointerException();
    }

    @Deprecated
    public boolean isFloat() {
        return false;
    }

    @Override
    protected Short parseValue(String value) {
        return TreeParseUtil.parseShort(value);
    }

    @Override
    protected String getValueAsString(Short value) {
        return Short.toString(value);
    }

    @Override
    protected Short getValueFromDataSet(DataSet dataset) {
        return this.getShortFromDataSet(dataset);
    }

    private short getShortFromDataSet(DataSet dataset) {
        return this.fetchNumberFromDataSet(dataset).shortValue();
    }

    @Override
    protected boolean evaluate(Short value, Short dataSetValue) throws Exception {
        return this.compareSignedNumbers(value.shortValue(), dataSetValue.shortValue());
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        return this.doTest((Short)exeCtx.getValue(DataType.SHORT));
    }
}

