/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.number;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.math.RatingDecimalUtil;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.number.AbstractImmutableNumberCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Node;

@Immutable
public final class RatingDecimalCondition
extends AbstractImmutableNumberCondition<RatingDecimal>
implements ContextCondition {
    private RatingDecimalCondition(ParseContext context) {
        super(context, "RatingDecimal", DataType.RATINGDECIMAL);
    }

    public static RatingDecimalCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new RatingDecimalCondition(ctx);
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.RATINGDECIMAL);
    }

    @Override
    protected String getValueString(Node config) {
        return XMLUtil.getFirstTextContent(XMLUtil.getNamedElement("RatingDecimalValue", config.getChildNodes()));
    }

    @Override
    protected RatingDecimal parseValue(String value) {
        return new RatingDecimal(value);
    }

    @Override
    protected String getValueAsString(RatingDecimal value) {
        return value.toString();
    }

    @Override
    protected boolean evaluate(RatingDecimal value, RatingDecimal dataSetValue) throws Exception {
        return this.testRatingDecimal(value, dataSetValue);
    }

    @Override
    protected RatingDecimal getValueFromDataSet(DataSet dataset) {
        return RatingDecimalUtil.createRatingDecimalFromNumericValue(this.fetchNumberFromDataSet(dataset));
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        return this.doTest((RatingDecimal)exeCtx.getValue(DataType.RATINGDECIMAL));
    }

    protected boolean testRatingDecimal(RatingDecimal ratingDecimalToTest, RatingDecimal ratingDecimalToCheck) {
        int result = ratingDecimalToCheck.compareTo(ratingDecimalToTest);
        switch (this.operator()) {
            case EQ: {
                return result == 0;
            }
            case GT: {
                return result > 0;
            }
            case LT: {
                return result < 0;
            }
            case GTE: {
                return result >= 0;
            }
            case LTE: {
                return result <= 0;
            }
        }
        return false;
    }
}

