/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.number;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.number.AbstractImmutableNumberCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.util.TreeParseUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Node;

@Immutable
public final class IntegerCondition
extends AbstractImmutableNumberCondition<Integer>
implements ContextCondition {
    private IntegerCondition(ParseContext context) {
        super(context, "Integer", DataType.INTEGER);
    }

    public static IntegerCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new IntegerCondition(ctx);
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.INTEGER);
    }

    @Override
    protected String getValueString(Node config) {
        return XMLUtil.getFirstTextContent(XMLUtil.getNamedElement("IntValue", config.getChildNodes()));
    }

    @Override
    protected Integer parseValue(String value) {
        return TreeParseUtil.parseInt(value);
    }

    @Override
    protected String getValueAsString(Integer value) {
        return Integer.toString(value);
    }

    @Override
    protected boolean evaluate(Integer value, Integer dataSetValue) throws Exception {
        return this.compareSignedNumbers(value.intValue(), dataSetValue.intValue());
    }

    @Override
    protected Integer getValueFromDataSet(DataSet ds) {
        return this.fetchNumberFromDataSet(ds).intValue();
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        return this.doTest((Integer)exeCtx.getValue(DataType.INTEGER));
    }
}

