/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.number;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.number.AbstractImmutableNumberCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.util.TreeParseUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public final class DoubleCondition
extends AbstractImmutableNumberCondition<Double>
implements ContextCondition {
    private DoubleCondition(ParseContext ctx) {
        super(ctx, "Double", DataType.DOUBLE);
    }

    public static DoubleCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new DoubleCondition(ctx);
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.DOUBLE);
    }

    @Override
    protected String getValueString(Node config) {
        Element n = XMLUtil.getNamedElement("IntValue", config.getChildNodes());
        if (n == null) {
            n = XMLUtil.getNamedElement("DoubleValue", config.getChildNodes());
        }
        return XMLUtil.getFirstTextContent(n);
    }

    @Deprecated
    public boolean isFloat() {
        return true;
    }

    @Override
    protected Double parseValue(String value) {
        return TreeParseUtil.parseDouble(value);
    }

    @Override
    protected String getValueAsString(Double value) {
        return Double.toString(value);
    }

    @Override
    protected boolean evaluate(Double value, Double dataSetValue) throws Exception {
        return this.testDouble(value, dataSetValue);
    }

    @Override
    protected Double getValueFromDataSet(DataSet ds) {
        return this.fetchNumberFromDataSet(ds).doubleValue();
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        return this.doTest((Double)exeCtx.getValue(DataType.DOUBLE));
    }

    private boolean testDouble(double doubleToTest, double doubleToCheck) {
        switch (this.operator()) {
            case EQ: {
                return doubleToCheck == doubleToTest;
            }
            case GT: {
                return doubleToCheck > doubleToTest;
            }
            case LT: {
                return doubleToCheck < doubleToTest;
            }
            case GTE: {
                return doubleToCheck >= doubleToTest;
            }
            case LTE: {
                return doubleToCheck <= doubleToTest;
            }
        }
        return false;
    }
}

