/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.number;

import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.selectiontree.AbstractBaseConditionProfile;
import com.ericsson.ere.selectiontree.conditions.number.UnsignedIntCondition;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractUnsignedIntConditionProfile
extends AbstractBaseConditionProfile
implements FieldMappable,
TestCaseGenerationConditionInterface {
    protected static final String LBL_OPERATOR = "Operator";
    protected static final String LBL_VALUE = "Value";
    protected static final String[] numericOperatorArr = new String[]{"=", ">", "<", ">=", "<="};
    private static final String[] tokenOperatorArr = new String[]{"=", "GT", "LT", "GTE", "LTE"};
    protected FieldDefinition myFieldDefinition;

    protected String operatorToToken(String operator) {
        for (int i = 0; i < numericOperatorArr.length; ++i) {
            if (!numericOperatorArr[i].equals(operator)) continue;
            return tokenOperatorArr[i];
        }
        return operator;
    }

    protected String tokenToOperator(String token) {
        for (int i = 0; i < tokenOperatorArr.length; ++i) {
            if (!tokenOperatorArr[i].equals(token)) continue;
            return numericOperatorArr[i];
        }
        return token;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        if (name == null) {
            name = this.getName();
        }
        String op = this.getOperatorFromVariables(variables);
        String value = VarListUtil.getVariableForName(variables, LBL_VALUE).toString();
        StringBuilder builder = new StringBuilder();
        builder.append(name).append(" ");
        builder.append(op).append(" ");
        builder.append(value);
        return builder.toString();
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = this.getName();
        String op = this.getOperatorFromVariables(variables);
        String value = VarListUtil.getVariableForName(variables, LBL_VALUE).toString();
        StringBuilder builder = new StringBuilder();
        builder.append("<b>").append(name).append("</b> (");
        builder.append(GuiUtil.replaceSubString(op, "<", "&lt;")).append(" ");
        builder.append(value).append(")\n");
        builder.append(this.getComment(variables));
        return GuiUtil.multilineTooltipWrapper(builder.toString());
    }

    protected String getTagName(String fieldName) {
        String tagName = "LongValue";
        return tagName;
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node iterator) {
        return null;
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myFieldDefinition = fieldDefinition;
    }

    public String getMaximumValue() {
        Element theElement = (Element)this.myFieldDefinition.getDefinitionNode();
        if (XMLUtil.containsElementNamed(theElement, "Range")) {
            Element rangeElement = XMLUtil.getFirstElementNamed("Range", theElement);
            return XMLUtil.getAttributeFromElement(rangeElement, "max", this.getSpecificMaximumValue());
        }
        return this.getSpecificMaximumValue();
    }

    private String getSpecificMaximumValue() {
        String dataType = this.myFieldDefinition.getDataType();
        if (dataType.equals("UnsignedInt8")) {
            return "255";
        }
        if (dataType.equals("UnsignedInt16")) {
            return "65535";
        }
        return "4294967295";
    }

    public String getMinimumValue() {
        Element theElement = (Element)this.myFieldDefinition.getDefinitionNode();
        if (XMLUtil.containsElementNamed(theElement, "Range")) {
            Element rangeElement = XMLUtil.getFirstElementNamed("Range", theElement);
            return XMLUtil.getAttributeFromElement(rangeElement, "min", "0");
        }
        return "0";
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev == null ? new HashMap<String, Object>() : prev;
        this.storeOperatorFromVariables(displayValuesMap, variables);
        String value = VarListUtil.getVariableForName(variables, LBL_VALUE).toString();
        displayValuesMap.put(LBL_VALUE, value);
        return displayValuesMap;
    }

    protected abstract String makeDisplayString(String var1);

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev == null ? new HashMap<String, Object>() : prev;
        this.storeOperatorFromNode(displayValuesMap, data);
        String value = this.getValueString(data);
        displayValuesMap.put(LBL_VALUE, value);
        return displayValuesMap;
    }

    private void storeOperatorFromVariables(Map<String, Object> store, List<Variable> variables) {
        String operator = this.getOperatorFromVariables(variables);
        store.put(LBL_OPERATOR, operator);
    }

    private void storeOperatorFromNode(Map<String, Object> store, Node data) {
        Element operatorElement = XMLUtil.getNamedElement(LBL_OPERATOR, data.getChildNodes());
        String operator = operatorElement == null ? numericOperatorArr[0] : operatorElement.getTextContent();
        store.put(LBL_OPERATOR, operator);
    }

    private String getValueString(Node data) {
        String text = XMLUtil.getNamedElement("LongValue", data.getChildNodes()).getTextContent();
        return this.makeDisplayString(text);
    }

    private String getOperatorFromVariables(List<Variable> variables) {
        String operator = VarListUtil.getValueStringForName(variables, LBL_OPERATOR);
        if (operator == null) {
            operator = numericOperatorArr[0];
        }
        return operator;
    }

    protected void addInputVariables(List<Variable> l, String selection, String value, DataType dataType) {
        Variable inputVarriable = this.createInputVariable(LBL_VALUE, null, value, dataType);
        if (this.supportsInequalityOperators(inputVarriable)) {
            l.add(new DropDownVariable(LBL_OPERATOR, (Object)selection, (Object[])numericOperatorArr));
        }
        l.add(inputVarriable);
    }

    @Override
    public void cachedPrint(PrintWriter out, int indentLevel, String indent, TariffStructureNode tsNode, Node xmlNode) {
    }

    @Override
    public boolean handlesCachedPrint(Node xmlNode) {
        return false;
    }

    protected ArrayList<Variable> addInputVariablesFromNode(Node iterator, DataType dataType) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String tagName = "LongValue";
        String operator = numericOperatorArr[0];
        String valueStr = null;
        NodeList children = iterator.getChildNodes();
        for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
            int gChildren;
            NodeList value;
            if (children.item(childIndex).getNodeType() != 1) continue;
            String nodeName = children.item(childIndex).getNodeName();
            if (nodeName.equalsIgnoreCase(tagName = this.getTagName(nodeName))) {
                value = children.item(childIndex).getChildNodes();
                for (gChildren = 0; gChildren < value.getLength(); ++gChildren) {
                    valueStr = value.item(gChildren).getNodeValue();
                }
                continue;
            }
            if (!nodeName.equalsIgnoreCase(LBL_OPERATOR)) continue;
            value = children.item(childIndex).getChildNodes();
            for (gChildren = 0; gChildren < value.getLength(); ++gChildren) {
                String token = value.item(gChildren).getNodeValue();
                operator = this.tokenToOperator(token);
            }
        }
        this.addInputVariables(l, operator, valueStr, dataType);
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        Variable inputVariable = VarListUtil.getVariableForName(variables, LBL_VALUE);
        String value = inputVariable.getValueString();
        String operator = !this.supportsInequalityOperators(inputVariable) ? UnsignedIntCondition.numericOperatorArr[0] : this.operatorToToken(VarListUtil.getValueStringForName(variables, LBL_OPERATOR));
        out.println("<Operator>" + operator + "</" + LBL_OPERATOR + ">");
        out.println("<LongValue>" + value + "</" + "LongValue" + ">");
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element operatorNode = XMLUtil.getFirstElementNamed(LBL_OPERATOR, (Element)variableValueIterator);
        Element valueNode = XMLUtil.getFirstElementNamed("LongValue", (Element)variableValueIterator);
        HashMap<String, Object> testCaseData = new HashMap<String, Object>(2);
        if (operatorNode != null && valueNode != null) {
            String operatorString = operatorNode.getTextContent();
            String valueString = valueNode.getTextContent();
            String fieldName = this.myFieldDefinition.getFieldName();
            if (operatorString.equals("GT")) {
                if (!valueString.equals(this.getMaximumValue())) {
                    testCaseData.put(fieldName, new Object[]{this.getMaximumValue()});
                }
            } else if (operatorString.equals("LT")) {
                if (!valueString.equals(this.getMinimumValue())) {
                    testCaseData.put(fieldName, new Object[]{this.getMinimumValue()});
                }
            } else {
                testCaseData.put(fieldName, new Object[]{valueString});
            }
        }
        if (testCaseData.size() == 0) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        return testCaseData;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
        out.print("<TestSettings></TestSettings>");
    }
}

