/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.number;

import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationDefs;
import com.ericsson.ere.selectiontree.AbstractBaseConditionProfile;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractNumberConditionProfile
extends AbstractBaseConditionProfile
implements FieldMappable,
TestCaseGenerationConditionInterface {
    private static final BigInteger BIGINTEGER_TWO = BigInteger.valueOf(2L);
    public static final String LBL_VALUE = "Value";
    public static final String LBL_OPERATOR = "Operator";
    protected static final String TAG_VALUE = "Value";
    protected static final String TAG_OPERATOR = "Operator";
    private static final String[] numericOperatorArr = new String[]{"=", ">", "<", ">=", "<="};
    private static final String[] tokenOperatorArr = new String[]{"=", "GT", "LT", "GTE", "LTE"};
    protected FieldDefinition myFieldDefinition;
    private final DataType myDataType;

    protected abstract String getValueString(Node var1);

    protected AbstractNumberConditionProfile(boolean handlesBitPatternEditor) {
        this(handlesBitPatternEditor, null);
    }

    protected AbstractNumberConditionProfile(boolean handlesBitPatternEditor, DataType type) {
        this.myDataType = type;
    }

    private String operatorToToken(String operator) {
        for (int i = 0; i < numericOperatorArr.length; ++i) {
            if (!numericOperatorArr[i].equals(operator)) continue;
            return tokenOperatorArr[i];
        }
        return operator;
    }

    private String tokenToOperator(String token) {
        for (int i = 0; i < tokenOperatorArr.length; ++i) {
            if (!tokenOperatorArr[i].equals(token)) continue;
            return numericOperatorArr[i];
        }
        return token;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        int i;
        Variable inputVariable = this.createInputVariable("Value", null, null, this.myDataType);
        String operator = this.supportsInequalityOperators(inputVariable) ? VarListUtil.getValueStringForName(variables, "Operator") : numericOperatorArr[0];
        String token = this.operatorToToken(operator);
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<Operator>" + token + "</" + "Operator" + ">");
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        this.printValueTag(out, indentLevel, indentMarker, variables);
    }

    protected void printValueTag(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String value = VarListUtil.getValueStringForName(variables, "Value");
        out.println("<IntValue>" + value + "</" + "IntValue" + ">");
    }

    @Override
    public final String getDescription(List<Variable> variables) {
        String name = VarListUtil.getVariableForName(variables, "Name").toString();
        String comp = this.getOperatorFromVariables(variables);
        String val = VarListUtil.getVariableForName(variables, "Value").toString();
        return name + " " + comp + " " + val;
    }

    @Override
    public final String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getVariableForName(variables, "Name").toString();
        String desc = this.getDescription(variables);
        String rest = desc.substring(name.length() + 1);
        desc = name + " (" + rest + ")";
        return GuiUtil.descriptionToTooltip(desc, name, this.getComment(variables));
    }

    public String getSpecificMaximumValue() {
        int dataType = this.myFieldDefinition.getDatatype();
        switch (dataType) {
            case 9: {
                return Short.toString((short)Short.MAX_VALUE);
            }
            case 15: {
                return new BigInteger("32767").multiply(BIGINTEGER_TWO).add(BigInteger.ONE).toString();
            }
            case 10: {
                return Integer.toString(Integer.MAX_VALUE);
            }
            case 16: {
                return new BigInteger("2147483647").multiply(BIGINTEGER_TWO).add(BigInteger.ONE).toString();
            }
            case 11: {
                return Long.toString(Long.MAX_VALUE);
            }
            case 17: {
                return new BigInteger("9223372036854775807").multiply(BIGINTEGER_TWO).add(BigInteger.ONE).toString();
            }
            case 12: {
                return Double.toString(Double.MAX_VALUE);
            }
        }
        return "0";
    }

    public String getSpecificMinimumValue() {
        int dataType = this.myFieldDefinition.getDatatype();
        switch (dataType) {
            case 9: {
                return Short.toString((short)Short.MIN_VALUE);
            }
            case 15: {
                return "0";
            }
            case 10: {
                return Integer.toString(Integer.MIN_VALUE);
            }
            case 16: {
                return "0";
            }
            case 11: {
                return Long.toString(Long.MIN_VALUE);
            }
            case 17: {
                return "0";
            }
            case 12: {
                return Double.toString(Double.MIN_VALUE);
            }
        }
        return "0";
    }

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        this.addInputVariables(l, numericOperatorArr[0], null);
        return l;
    }

    private void addInputVariables(List<Variable> l, String selection, String value) {
        Variable inputVariable = this.createInputVariable("Value", null, value, this.myDataType);
        if (this.supportsInequalityOperators(inputVariable)) {
            l.add(new DropDownVariable("Operator", (Object)selection, (Object[])numericOperatorArr));
        }
        l.add(inputVariable);
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        NodeList children = iterator.getChildNodes();
        String valueStr = this.getValueString(iterator);
        String operator = "=";
        try {
            Element operatorNode = XMLUtil.getNamedElement("Operator", children);
            operator = this.tokenToOperator(XMLUtil.getFirstTextContent(operatorNode));
        }
        catch (NullPointerException operatorNode) {
            // empty catch block
        }
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        this.addInputVariables(l, operator, valueStr);
        return l;
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        String element;
        Element operatorNode = XMLUtil.getFirstElementNamed("Operator", (Element)variableValueIterator);
        Element valueNode = null;
        String[] stringArray = TestCaseGenerationDefs.NUMBER_TAG_ARRAY;
        int n = stringArray.length;
        for (int i = 0; i < n && (valueNode = XMLUtil.getFirstElementNamed(element = stringArray[i], (Element)variableValueIterator)) == null; ++i) {
        }
        String fieldName = this.myFieldDefinition.getFieldName();
        HashMap<String, Object> testCaseData = new HashMap<String, Object>(2);
        if (operatorNode != null && valueNode != null) {
            String operatorString = operatorNode.getTextContent();
            String valueString = valueNode.getTextContent();
            if (operatorString.equals("GT")) {
                if (!valueString.equals(this.getMaximumValue())) {
                    testCaseData.put(fieldName, this.getMaximumValue());
                }
            } else if (operatorString.equals("LT")) {
                if (!valueString.equals(this.getMinimumValue())) {
                    testCaseData.put(fieldName, this.getMinimumValue());
                }
            } else {
                testCaseData.put(fieldName, valueString);
            }
        }
        if (testCaseData.size() == 0) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        return testCaseData;
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node iterator) {
        return null;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myFieldDefinition = fieldDefinition;
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }

    public String getMaximumValue() {
        Element theElement = (Element)this.myFieldDefinition.getDefinitionNode();
        if (XMLUtil.containsElementNamed(theElement, "Range")) {
            Element rangeElement = XMLUtil.getFirstElementNamed("Range", theElement);
            return XMLUtil.getAttributeFromElement(rangeElement, "max", this.getSpecificMaximumValue());
        }
        return this.getSpecificMaximumValue();
    }

    public String getMinimumValue() {
        Element theElement = (Element)this.myFieldDefinition.getDefinitionNode();
        if (XMLUtil.containsElementNamed(theElement, "Range")) {
            Element rangeElement = XMLUtil.getFirstElementNamed("Range", theElement);
            return XMLUtil.getAttributeFromElement(rangeElement, "min", this.getSpecificMinimumValue());
        }
        return this.getSpecificMinimumValue();
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev == null ? new HashMap<String, Object>() : prev;
        this.storeOperatorFromVariables(displayValuesMap, variables);
        String value = VarListUtil.getVariableForName(variables, "Value").toString();
        displayValuesMap.put("Value", value);
        return displayValuesMap;
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev == null ? new HashMap<String, Object>() : prev;
        this.storeOperatorFromNode(displayValuesMap, data);
        String value = this.makeDisplayString(this.getValueString(data), this.myDataType);
        displayValuesMap.put("Value", value);
        return displayValuesMap;
    }

    private void storeOperatorFromVariables(Map<String, Object> store, List<Variable> variables) {
        store.put("Operator", this.getOperatorFromVariables(variables));
    }

    private void storeOperatorFromNode(Map<String, Object> store, Node data) {
        Element operatorElement = XMLUtil.getNamedElement("Operator", data.getChildNodes());
        String operator = operatorElement == null ? numericOperatorArr[0] : operatorElement.getTextContent();
        store.put("Operator", operator);
    }

    private String getOperatorFromVariables(List<Variable> variables) {
        String comp = VarListUtil.getValueStringForName(variables, "Operator");
        if (comp == null) {
            comp = numericOperatorArr[0];
        }
        return comp;
    }

    @Override
    public void cachedPrint(PrintWriter out, int indentLevel, String indent, TariffStructureNode tsNode, Node xmlNode) {
    }

    @Override
    public boolean handlesCachedPrint(Node xmlNode) {
        return false;
    }
}

