/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.number;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.conditions.AbstractCondition;
import com.ericsson.ere.selectiontree.conditions.util.EnumParser;
import com.ericsson.ere.selectiontree.interfaces.EnumMap;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexSupport;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TracePoint;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.xml.XMLUtil;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Deprecated
public abstract class AbstractNumberCondition
extends AbstractCondition
implements FieldMappable,
EnumMap,
FieldKeyIndexSupport {
    protected static final String TESTED_VALUE = "Tested_Value";
    private int myOperatorId;
    private static final String[] numericOpertorArr = new String[]{"=", "GT", "LT", "GTE", "LTE"};
    private ClassRepository myRepository;
    protected Map<String, String> myEnumMap = null;
    protected FieldIndexKeyContainer myKeyContainer;

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        this.setEnumMap(EnumParser.extractEnumMap(this.myRepository, this.getKey()));
        String theValue = "";
        String operator = "=";
        this.setConditionName(iterator.getChildNodes().item(0).getNodeValue().trim());
        theValue = this.getValueString(iterator);
        Element e = XMLUtil.getNamedElement("Operator", iterator.getChildNodes());
        operator = e != null ? XMLUtil.getFirstTextContent(e) : "=";
        this.parseValue(theValue);
        this.setOperatorId(operator);
        return this;
    }

    @Override
    protected int hashCodeImpl() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myEnumMap == null ? 0 : this.myEnumMap.hashCode());
        result = 31 * result + (this.myKeyContainer == null ? 0 : this.myKeyContainer.hashCode());
        result = 31 * result + this.myOperatorId;
        result = 31 * result + (this.myRepository == null ? 0 : this.myRepository.hashCode());
        return result;
    }

    @Override
    protected boolean equalsImpl(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNumberCondition other = (AbstractNumberCondition)obj;
        if (this.myEnumMap == null ? other.myEnumMap != null : !this.myEnumMap.equals(other.myEnumMap)) {
            return false;
        }
        if (this.myOperatorId != other.myOperatorId) {
            return false;
        }
        if (this.myKeyContainer == null ? other.myKeyContainer != null : this.myKeyContainer != other.myKeyContainer) {
            return false;
        }
        return !(this.myRepository == null ? other.myRepository != null : !this.myRepository.equals(other.myRepository));
    }

    protected abstract void parseValue(String var1);

    protected abstract String getTypeText();

    protected abstract String getValueString(Node var1);

    @Override
    public boolean needsFieldToBeSet() {
        return true;
    }

    @Override
    public void setFieldName(String fieldName) {
        this.setKey(fieldName);
    }

    protected boolean testUInteger(long longToTest, long numberToCheck) {
        switch (this.myOperatorId) {
            case 0: {
                return numberToCheck == longToTest;
            }
            case 1: {
                return this.compareUnsignedGT(longToTest, numberToCheck);
            }
            case 2: {
                return this.compareUnsignedLT(longToTest, numberToCheck);
            }
            case 3: {
                return numberToCheck == longToTest || this.compareUnsignedGT(longToTest, numberToCheck);
            }
            case 4: {
                return numberToCheck == longToTest || this.compareUnsignedLT(longToTest, numberToCheck);
            }
        }
        return false;
    }

    private boolean compareUnsignedGT(long longToTest, long numberToCheck) {
        if (longToTest >= 0L && numberToCheck >= 0L || longToTest < 0L && numberToCheck < 0L) {
            return numberToCheck > longToTest;
        }
        return numberToCheck <= longToTest;
    }

    private boolean compareUnsignedLT(long longToTest, long numberToCheck) {
        if (longToTest >= 0L && numberToCheck >= 0L || longToTest < 0L && numberToCheck < 0L) {
            return numberToCheck < longToTest;
        }
        return numberToCheck >= longToTest;
    }

    protected boolean testInteger(long longToTest, long numberToCheck) {
        switch (this.myOperatorId) {
            case 0: {
                return numberToCheck == longToTest;
            }
            case 1: {
                return numberToCheck > longToTest;
            }
            case 2: {
                return numberToCheck < longToTest;
            }
            case 3: {
                return numberToCheck >= longToTest;
            }
            case 4: {
                return numberToCheck <= longToTest;
            }
        }
        return false;
    }

    protected boolean testDouble(double doubleToTest, double doubleToCheck) {
        switch (this.myOperatorId) {
            case 0: {
                return doubleToCheck == doubleToTest;
            }
            case 1: {
                return doubleToCheck > doubleToTest;
            }
            case 2: {
                return doubleToCheck < doubleToTest;
            }
            case 3: {
                return doubleToCheck >= doubleToTest;
            }
            case 4: {
                return doubleToCheck <= doubleToTest;
            }
        }
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    private void setOperatorId(String operator) {
        for (int i = 0; i < numericOpertorArr.length; ++i) {
            if (!operator.equals(numericOpertorArr[i])) continue;
            this.myOperatorId = i;
        }
    }

    protected int getOperatorId() {
        return this.myOperatorId;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        StringBuffer buf = new StringBuffer();
        String result = (Boolean)tp.getInfo(TraceNodeInterface.TEST_RESULT) != false ? "TRUE" : "FALSE";
        String testType = "";
        switch (this.myOperatorId) {
            case 0: {
                testType = " == ";
                break;
            }
            case 1: {
                testType = " > ";
                break;
            }
            case 2: {
                testType = " < ";
                break;
            }
            case 3: {
                testType = " >= ";
                break;
            }
            case 4: {
                testType = " <= ";
            }
        }
        if (this.myOperatorId >= 0 && this.myOperatorId <= 4) {
            String usedValue = this.getUsedValueAsString();
            String testedValue = (String)tp.getInfo(TESTED_VALUE);
            if (this.myEnumMap != null) {
                String enumUsedValue = this.myEnumMap.get(usedValue);
                String enumTestedValue = this.myEnumMap.get(testedValue);
                if (enumUsedValue != null) {
                    usedValue = enumUsedValue;
                }
                if (enumTestedValue != null) {
                    testedValue = enumTestedValue;
                }
            }
            DataSet theData = tp.getPostDataSet();
            String fieldNameString = FieldOrientedPluginUtil.formatFieldNameWithKeyInformation(this.key, this.myKeyContainer, theData);
            buf.append("\t" + this.getTypeText() + ".test == " + result + " (" + fieldNameString + " (" + testedValue + ")" + testType + usedValue + ")");
        } else {
            buf.append("\tCould not perform condition operatorId " + this.myOperatorId + " unknown ");
        }
        return buf.toString();
    }

    protected abstract String getUsedValueAsString();

    @Override
    public void setEnumMap(Map<String, String> enumMap) {
        this.myEnumMap = enumMap;
    }

    @Override
    public boolean needsClassRepository() {
        return true;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        this.myRepository = repository;
        FieldDefinition fd = this.myRepository.getFieldDefinitionByName(this.getKey());
        this.tagIsSet = fd.usesTagNumber();
        if (this.tagIsSet) {
            this.tag = fd.getTagNumber();
        }
    }

    @Override
    public void setKeyIndex(FieldIndexKeyContainer keyContainer) {
        this.myKeyContainer = keyContainer;
    }

    public void setIndex(int index) {
    }

    protected Number fetchNumberFromDataSet(DataSet theData) {
        Number resultingNumber = this.myKeyContainer == null ? (Number)(this.tagIsSet ? (Number)((Number)theData.getDataAsObject(this.tag)) : (Number)((Number)theData.getDataAsObject(this.key))) : (Number)(this.tagIsSet ? (Number)((Number)theData.getDataAsTypedObjectForKey(this.tag, this.myKeyContainer.getFirstKey(theData), (DataType)null)) : (Number)((Number)theData.getDataAsTypedObjectForKey(this.key, this.myKeyContainer.getFirstKey(theData), null)));
        return resultingNumber;
    }
}

