/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic.util;

import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.selectiontree.conditions.logic.util.AmountField;
import com.ericsson.ere.selectiontree.conditions.logic.util.BCDStringField;
import com.ericsson.ere.selectiontree.conditions.logic.util.BooleanField;
import com.ericsson.ere.selectiontree.conditions.logic.util.DateField;
import com.ericsson.ere.selectiontree.conditions.logic.util.DecimalField;
import com.ericsson.ere.selectiontree.conditions.logic.util.DoubleField;
import com.ericsson.ere.selectiontree.conditions.logic.util.Field;
import com.ericsson.ere.selectiontree.conditions.logic.util.IntegerField;
import com.ericsson.ere.selectiontree.conditions.logic.util.LongField;
import com.ericsson.ere.selectiontree.conditions.logic.util.MonetaryUnitsField;
import com.ericsson.ere.selectiontree.conditions.logic.util.ObjectField;
import com.ericsson.ere.selectiontree.conditions.logic.util.OctetStringField;
import com.ericsson.ere.selectiontree.conditions.logic.util.RatingDecimalField;
import com.ericsson.ere.selectiontree.conditions.logic.util.ShortField;
import com.ericsson.ere.selectiontree.conditions.logic.util.StringField;
import com.ericsson.ere.selectiontree.conditions.logic.util.TimeField;
import com.ericsson.ere.selectiontree.conditions.logic.util.UIntegerField;
import com.ericsson.ere.selectiontree.conditions.logic.util.ULongField;
import com.ericsson.ere.selectiontree.conditions.logic.util.UShortField;
import com.ericsson.ere.selectiontree.conditions.logic.util.UnsignedInt16Field;
import com.ericsson.ere.selectiontree.conditions.logic.util.UnsignedInt32Field;
import com.ericsson.ere.selectiontree.conditions.logic.util.UnsignedInt8Field;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;

public final class FieldFactory {
    private FieldFactory() {
    }

    public static Field<?> createFieldFor(FieldDefinition aField, String aValue, ClassRepository aRep, FieldIndexKeyContainer aFieldIndexKeyCont) {
        return FieldFactory.createFieldFor(FieldDefinitionUtil.createValueResolver(aRep, aField), aValue);
    }

    public static Field<?> createFieldFor(DataType dataType, String value) {
        return FieldFactory.createFieldFor((ValueResolver)dataType, value);
    }

    private static Field<?> createFieldFor(ValueResolver resolver, String strValue) {
        Object value = resolver.parseValueString(strValue);
        assert (value != null) : String.format("Failed to parse '%s' for data type %s", strValue, resolver.getDataType().getTypeName());
        switch (resolver.getDataType()) {
            case BOOLEAN: {
                return new BooleanField(value);
            }
            case STRING: {
                return new StringField(value);
            }
            case LONG: {
                return new LongField(value);
            }
            case UNSIGNEDLONG: {
                return new ULongField(value);
            }
            case INTEGER: {
                return new IntegerField(value);
            }
            case UNSIGNEDINT: {
                return new UIntegerField(value);
            }
            case SHORT: {
                return new ShortField(value);
            }
            case UNSIGNEDSHORT: {
                return new UShortField(value);
            }
            case UNSIGNEDINT32: {
                return new UnsignedInt32Field(value);
            }
            case UNSIGNEDINT16: {
                return new UnsignedInt16Field(value);
            }
            case UNSIGNEDINT8: {
                return new UnsignedInt8Field(value);
            }
            case DOUBLE: {
                return new DoubleField(value);
            }
            case DATE: {
                return new DateField(value);
            }
            case TIME: {
                return new TimeField(value);
            }
            case MONETARYUNITS: {
                return new MonetaryUnitsField(value);
            }
            case BCDSTRING: {
                return new BCDStringField(value);
            }
            case OCTETSTRING: {
                return new OctetStringField(value);
            }
            case DECIMAL: {
                return new DecimalField(value);
            }
            case RATINGDECIMAL: {
                return new RatingDecimalField(value);
            }
            case AMOUNT: {
                return new AmountField(value);
            }
            case OBJECT: {
                return new ObjectField(value);
            }
        }
        return null;
    }

    public static Field<?> initField(DataType dType, String name, boolean useTag, int theTag, FieldIndexKeyContainer keyContainer) {
        switch (dType) {
            case BOOLEAN: {
                return new BooleanField(name, useTag, theTag, keyContainer);
            }
            case STRING: {
                return new StringField(name, useTag, theTag, keyContainer);
            }
            case LONG: {
                return new LongField(name, useTag, theTag, keyContainer);
            }
            case UNSIGNEDLONG: {
                return new ULongField(name, useTag, theTag, keyContainer);
            }
            case INTEGER: {
                return new IntegerField(name, useTag, theTag, keyContainer);
            }
            case UNSIGNEDINT: {
                return new UIntegerField(name, useTag, theTag, keyContainer);
            }
            case SHORT: {
                return new ShortField(name, useTag, theTag, keyContainer);
            }
            case UNSIGNEDSHORT: {
                return new UShortField(name, useTag, theTag, keyContainer);
            }
            case UNSIGNEDINT32: {
                return new UnsignedInt32Field(name, useTag, theTag, keyContainer);
            }
            case UNSIGNEDINT16: {
                return new UnsignedInt16Field(name, useTag, theTag, keyContainer);
            }
            case UNSIGNEDINT8: {
                return new UnsignedInt8Field(name, useTag, theTag, keyContainer);
            }
            case DOUBLE: {
                return new DoubleField(name, useTag, theTag, keyContainer);
            }
            case DATE: {
                return new DateField(name, useTag, theTag, keyContainer);
            }
            case TIME: {
                return new TimeField(name, useTag, theTag, keyContainer);
            }
            case MONETARYUNITS: {
                return new MonetaryUnitsField(name, useTag, theTag, keyContainer);
            }
            case BCDSTRING: {
                return new BCDStringField(name, useTag, theTag, keyContainer);
            }
            case OCTETSTRING: {
                return new OctetStringField(name, useTag, theTag, keyContainer);
            }
            case DECIMAL: {
                return new DecimalField(name, useTag, theTag, keyContainer);
            }
            case RATINGDECIMAL: {
                return new RatingDecimalField(name, useTag, theTag, keyContainer);
            }
            case AMOUNT: {
                return new AmountField(name, useTag, theTag, keyContainer);
            }
            case OBJECT: {
                return new ObjectField(name, useTag, theTag, keyContainer);
            }
        }
        return null;
    }
}

