/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic.util;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.selectiontree.conditions.logic.util.AbstractField;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import ericsson.ere.datatype.DataType;
import java.util.Comparator;

public class DateField
extends AbstractField<EREDate> {
    private static AbstractField.Operator[] operators = new AbstractField.Operator[]{AbstractField.Operator.EQUALS, AbstractField.Operator.LESS_THAN, AbstractField.Operator.GREATER_THAN, AbstractField.Operator.LESS_THAN_EQUALS, AbstractField.Operator.GREATER_THAN_EQUALS};

    public DateField(String value) {
        super(DataType.DATE.parseValue(value), DataType.DATE, new DateComparator());
    }

    public DateField(Object value) {
        super(value, DataType.DATE, new DateComparator());
    }

    public DateField(String name, boolean useTag, int tag, FieldIndexKeyContainer keyContainer) {
        super(name, useTag, tag, keyContainer, DataType.DATE, new DateComparator());
    }

    public static String[] getOperatorArray() {
        return AbstractField.Operator.toStringArray(operators);
    }

    @Override
    public EREDate getValue(DataSet data) {
        if (this.haveValueSet()) {
            return (EREDate)super.getValue(data);
        }
        Key key = this.useKey() ? FieldOrientedPluginUtil.extractFirstKeyFromSet(this.getFieldKeyContainer().getKeySet(data)) : null;
        return this.useTag() ? EREDateUtil.getDataAsEREDate(data, this.getTag(), key) : EREDateUtil.getDataAsEREDate(data, this.getFieldName(), key);
    }

    @Override
    protected AbstractField.Operator[] getOrderedOperators() {
        return operators;
    }

    private static class DateComparator
    implements Comparator<EREDate> {
        private DateComparator() {
        }

        @Override
        public int compare(EREDate o1, EREDate o2) {
            return o1.compareTo(o2);
        }
    }
}

