/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.StatusPanel;
import ericsson.ere.gui.ratingrules.nodes.ContextAwareValidator;
import ericsson.ere.gui.ratingrules.nodes.TSCondition;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CompoundBooleanConditionProfile
extends AbstractConditionProfileV2
implements ContextAwareValidator {
    public static final String[] OPERATORS = new String[]{"AND", "OR", "NOT", "XOR"};
    public static final String TAG_OPERATION = "Operation";

    @Override
    public List<Variable> getVariables() {
        return this.getVariables(null);
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        Element op;
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        String selectedOperator = OPERATORS[0];
        if (iterator != null && (op = XMLUtil.getFirstElementNamed(TAG_OPERATION, (Element)iterator)) != null) {
            selectedOperator = XMLUtil.getFirstTextContent(op).toUpperCase().trim();
        }
        l.add(new DropDownVariable(TAG_OPERATION, (Object)selectedOperator, (Object[])OPERATORS));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String operation = VarListUtil.getValueStringForName(variables, TAG_OPERATION);
        for (int i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.print("<Operation>");
        out.print(operation);
        out.println("</Operation>");
    }

    @Override
    public boolean needsRepository() {
        return false;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String operation = VarListUtil.getValueStringForName(variables, TAG_OPERATION);
        return name + " (" + operation + ")";
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String operation = VarListUtil.getValueStringForName(variables, TAG_OPERATION);
        name = "<b>" + name + "</b> (" + operation + ")<p>";
        name = name + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(name);
    }

    public boolean validate(TSCondition condition) {
        return this.validateContext(condition);
    }

    @Override
    public boolean validateContext(TSElement element) {
        boolean isValid = false;
        isValid = element.getChildCount() == 0 ? false : (element.state().hasVariables() ? this.validateInitializedElement(element) : this.validateUninitializedElement(element));
        return isValid;
    }

    private boolean validateInitializedElement(TSElement element) {
        List<Variable> vars = element.getVariablesForEditing(null);
        boolean isValid = true;
        Variable op = VarListUtil.getVariableForName(vars, TAG_OPERATION);
        if (op != null && op.getValueString().equals("NOT") && this.hasSeveralChildren(element)) {
            isValid = false;
        }
        return isValid;
    }

    private boolean validateUninitializedElement(TSElement element) {
        Node xml = element.state().getXMLConfig();
        boolean isValid = true;
        if (xml == null) {
            return isValid;
        }
        Element e = XMLUtil.getFirstElementNamed(TAG_OPERATION, (Element)xml);
        if (e == null || e.getTextContent().equals("NOT") && this.hasSeveralChildren(element)) {
            isValid = false;
            StatusPanel.getInstance().setStatusMsg("Boolean Operator 'NOT' must contain exactly one condition");
        }
        return isValid;
    }

    private boolean hasSeveralChildren(TSElement element) {
        return element.getChildCount() > 1;
    }
}

