/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.conditions.logic.CompareDateWithMaskConfiguration;
import com.ericsson.ere.selectiontree.conditions.logic.CompareFieldProfile;
import com.ericsson.ere.selectiontree.conditions.logic.CompareFieldProfileContract;
import com.ericsson.ere.selectiontree.conditions.logic.DatePart;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.util.StringUtil;
import ericsson.vareditor.variable.MultiBoolVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.List;
import org.w3c.dom.Node;

@Constrainable(contractClass=CompareFieldProfileContract.class)
public class CompareDateWithMaskProfile
extends CompareFieldProfile {
    public static final String LBL_COMPARE_USING = "Compare using";
    private static final DatePart[] ALL_DATE_PARTS = new DatePart[]{DatePart.Year, DatePart.Month, DatePart.Day};

    @Override
    public List<Variable> getVariables() {
        List<Variable> variables = super.getVariables();
        if (VarListUtil.areAllValid(variables)) {
            variables.add(this.createMaskVariable(ALL_DATE_PARTS));
        }
        return variables;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        List<Variable> variables = super.getVariables(iterator);
        if (VarListUtil.areAllValid(variables)) {
            CompareDateWithMaskConfiguration conf = new CompareDateWithMaskConfiguration(new ParseContextAdapter(null, iterator, null));
            variables.add(this.createMaskVariable(conf.getSelectedDateParts()));
        }
        return variables;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        super.printParametersImpl(out, indentLevel, indentMarker, variables);
        CompareDateWithMaskConfiguration conf = new CompareDateWithMaskConfiguration(this.getSelected(variables));
        PluginConfigurationHelper.writeXML(conf, out, indentLevel, indentMarker);
    }

    @Override
    public boolean parameterChanged(String reference, Variable value, List<Variable> vars) {
        boolean maskVariableMissing;
        boolean updated = super.parameterChanged(reference, value, vars);
        boolean bl = maskVariableMissing = null == VarListUtil.getVariableForName(vars, LBL_COMPARE_USING);
        if (maskVariableMissing) {
            vars.add(this.createMaskVariable(ALL_DATE_PARTS));
        }
        return updated || maskVariableMissing;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        StringBuilder buf = new StringBuilder(super.getDescription(variables));
        DatePart[] selected = this.getSelected(variables);
        if (selected != null) {
            buf.append(" comparing ");
            buf.append(StringUtil.join((Object[])selected, ", "));
        }
        return buf.toString();
    }

    @Override
    protected List<FieldDefinition> getSupportedFirstOperandFieldList(ClassRepository repository) {
        List<FieldDefinition> superSupportedFirstOperandFieldList = super.getSupportedFirstOperandFieldList(repository);
        return FieldOrientedPluginProfileUtil.getSupportedFields(superSupportedFirstOperandFieldList, new DateFieldFilter());
    }

    @Override
    protected List<FieldFilter> getSupportedFilters() {
        List<FieldFilter> filters = super.getSupportedFilters();
        filters.add(new DateFieldFilter());
        return filters;
    }

    private MultiBoolVariable<DatePart> createMaskVariable(DatePart[] selected) {
        return new MultiBoolVariable(LBL_COMPARE_USING, (Enum[])ALL_DATE_PARTS, (Enum[])selected, true, true);
    }

    private DatePart[] getSelected(List<Variable> variables) {
        DatePart[] selectedArray = null;
        List selected = (List)VarListUtil.getValueForName(variables, LBL_COMPARE_USING);
        if (selected != null) {
            selectedArray = selected.toArray(new DatePart[selected.size()]);
        }
        return selectedArray;
    }

    private class DateFieldFilter
    implements FieldFilter {
        private DateFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            DataType theType = field.getTypedDataType();
            return CompareDateWithMaskProfile.this.mySupportDateTimeInteroperability ? theType == DataType.DATE || theType == DataType.TIME : theType == DataType.DATE;
        }
    }
}

