/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import com.ericsson.ere.annotations.ConfigurationClass;
import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateFactory;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.logic.CompareDateWithMaskConfiguration;
import com.ericsson.ere.selectiontree.conditions.logic.CompareField;
import com.ericsson.ere.selectiontree.conditions.logic.DatePart;
import com.ericsson.ere.selectiontree.conditions.logic.util.DateField;
import com.ericsson.ere.selectiontree.util.OperatorUtil;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.util.StringUtil;
import java.util.Arrays;
import java.util.EnumSet;

@Immutable
@ConfigurationClass(value=CompareDateWithMaskConfiguration.class)
public final class CompareDateWithMask
extends CompareField {
    private final EnumSet<DatePart> myMask;
    private final OperatorUtil.Operator myOperatorAsEnum;

    private CompareDateWithMask(ParseContext ctx) {
        super(ctx);
        CompareDateWithMaskConfiguration conf = new CompareDateWithMaskConfiguration(ctx);
        DatePart[] mask = conf.getSelectedDateParts();
        this.checkFieldTypeAndMask(mask);
        this.myMask = EnumSet.copyOf(Arrays.asList(mask));
        String operatorString = DateField.getOperatorArray()[this.myOperator];
        this.myOperatorAsEnum = OperatorUtil.getOperatorAsEnum(operatorString);
    }

    private void checkFieldTypeAndMask(DatePart[] mask) {
        String errorMessage = null;
        if (this.myFieldDataType != DataType.DATE && this.myFieldDataType != DataType.TIME || !this.myFieldsAreCompatible) {
            errorMessage = "Only Date or Time fields are allowed.";
        } else if (this.myOperator < 0) {
            errorMessage = "Operator not found.";
        } else if (mask == null || mask.length == 0) {
            errorMessage = "Date mask is not valid. Allowed date parts are: " + StringUtil.join((Object[])DatePart.values(), ",");
        }
        if (errorMessage != null) {
            throw new PluginCreationException(errorMessage);
        }
    }

    public static CompareDateWithMask create(ParseContext ctx, TariffStructureNode[] notused) {
        return new CompareDateWithMask(ctx);
    }

    @Override
    public boolean test(DataSet theData) {
        boolean returnValue = false;
        try {
            EREDate date1 = (EREDate)this.myField1.getValue(theData);
            EREDate date2 = (EREDate)this.myField2.getValue(theData);
            returnValue = this.testDatesWithMask(date1, date2);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return returnValue;
    }

    private boolean testDatesWithMask(EREDate date1, EREDate date2) {
        boolean maskContainsYear = this.myMask.contains((Object)DatePart.Year);
        int date1Year = maskContainsYear ? date1.getFullYear() : 2000;
        int date2Year = maskContainsYear ? date2.getFullYear() : 2000;
        boolean maskContainsMonth = this.myMask.contains((Object)DatePart.Month);
        int date1Month = maskContainsMonth ? date1.getMonthOfYear() : 1;
        int date2Month = maskContainsMonth ? date2.getMonthOfYear() : 1;
        boolean maskContainsDay = this.myMask.contains((Object)DatePart.Day);
        int date1Day = maskContainsDay ? date1.getDayOfMonth() : 1;
        int date2Day = maskContainsDay ? date2.getDayOfMonth() : 1;
        EREDate maskedDate1 = EREDateFactory.createFromYearMonthDay(date1Year, date1Month, date1Day);
        EREDate maskedDate2 = EREDateFactory.createFromYearMonthDay(date2Year, date2Month, date2Day);
        return this.myOperatorAsEnum.test(maskedDate1.compareTo(maskedDate2), 0L);
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        StringBuilder buf = new StringBuilder("CompareDateWithMask : ").append(this.myField1.describeTrace(this.myOperator, this.myField2, dataSet)).append(" comparing ").append(StringUtil.join((Object[])this.myMask.toArray(new DatePart[this.myMask.size()]), ", "));
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myMask == null ? 0 : this.myMask.hashCode());
        result = 31 * result + (this.myOperatorAsEnum == null ? 0 : this.myOperatorAsEnum.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompareDateWithMask other = (CompareDateWithMask)obj;
        if (this.myMask == null ? other.myMask != null : !this.myMask.equals(other.myMask)) {
            return false;
        }
        return this.myOperatorAsEnum == other.myOperatorAsEnum;
    }
}

