/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.field;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.LegacyAutoConditionMapProfile;
import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresMapField;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresSetField;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.interfaces.ProductTagClassProfile;
import com.ericsson.ere.selectiontree.HierarchicalFieldFilter;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.conditions.AbstractFieldOrientedConditionProfile;
import com.ericsson.ere.selectiontree.conditions.field.FieldSelectionConditionConfiguration;
import com.ericsson.ere.selectiontree.conditions.field.FieldSelectionConditionProfileContract;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldListBuilderWithLegacySupport;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import com.ericsson.ere.selectiontree.util.TreeParseUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.StatusPanel;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.IndexVariableFactory;
import ericsson.ere.interfaces.ClassProfile;
import ericsson.ere.interfaces.ClassProfileV2;
import ericsson.ere.interfaces.ConditionProfile;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.LazyFieldDropDownVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldUser;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldUser2;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Constrainable(contractClass=FieldSelectionConditionProfileContract.class)
@LegacyAutoConditionMapProfile
public class FieldSelectionConditionProfile
extends AbstractFieldOrientedConditionProfile
implements TestCaseGenerationConditionInterface {
    private static final String INDEX_VARIABLE_MAP_SUPPORT_FEATURE = "Index_Variable_Map_Support";
    private static final String MAP_AND_ARRAY_BASE_CONDITION_SUPPORT = "Map_and_Array_Base_Condition_Support";
    private static final String DATE_TIME_INTEROPERABILITY_FEATURE = "Date_Time_Interoperability_Support";
    private static final String[] SUPPORTED_FEATURES = new String[]{"Index_Variable_Map_Support", "Map_and_Array_Base_Condition_Support", "Date_Time_Interoperability_Support"};
    private static final String LBL_CONTEXT = "Context";
    public static final String LBL_FIELD = "Selected field";
    private static final String LBL_USE_INDEX = "Use index";
    public static String LBL_INDEX = "Index";
    private static final String LBL_PROFILE = "Condition";
    private static String LBL_ERROR = "Error";
    private ClassRepositoryHelper myHelper;
    private ConditionProfile mySelectedProfile;
    private NotAllowedVariable myNoAvailableFieldsVar = new NotAllowedVariable("Field", " No available fields found");
    private NotAllowedVariable myNoAvailableConditionsVar = new NotAllowedVariable("Condition", " No available conditions found");
    private boolean myNewIndexSupportEnabled;
    private boolean myArrayBaseConditionSupport;
    private boolean mySupportDateTimeInteroperability;

    @Override
    public List<Variable> getVariables() {
        return this.getVariables(null, null, null, null, null);
    }

    @Override
    public List<Variable> getVariables(Node configNode) {
        boolean fieldExistsInService;
        FieldSelectionConditionConfiguration config = new FieldSelectionConditionConfiguration(new ParseContextAdapter(this.myClassRepository, configNode, null));
        String context = config.getContextName();
        String fieldName = config.getFieldName();
        String condition = config.getBaseConditionName();
        ValueFieldCompositeObject indexObject = config.getIndexObject();
        ArrayList<Variable> varList = new ArrayList<Variable>();
        if ("null".equals(fieldName) && "null".equals(condition)) {
            return this.getVariables();
        }
        this.addOptionalContextVariable(context, varList);
        FieldHierarchyNode field = this.myClassRepository.getFieldRepository().getFieldByName(fieldName);
        FieldListBuilderWithLegacySupport builder = (FieldListBuilderWithLegacySupport)new FieldListBuilderWithLegacySupport(this.myClassRepository).withLegacyField(field).withHierarchicalFields().withConstraints(this, null).withFilter(new FieldSelectionFilter());
        if (context != null) {
            builder.withContext(context);
        }
        if (!builder.filtersAllow(field)) {
            List<FieldHierarchyNode> fieldList = builder.buildList();
            if (!fieldList.isEmpty()) {
                varList.add(FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(LBL_FIELD, null, fieldList, fieldName));
            } else {
                varList.add(this.myNoAvailableFieldsVar);
            }
        } else {
            varList.add(new LazyFieldDropDownVariable(LBL_FIELD, builder, fieldName));
        }
        boolean useIndex = fieldName == null && condition == null;
        boolean selectSingleValueConditions = this.addIndexVariableIfFieldIsComplexType(fieldName, indexObject, varList, useIndex);
        Object[] profileNames = this.extractConditionList(fieldName, selectSingleValueConditions);
        Object[] profileAliases = this.fetchConditionAliases((String[])profileNames);
        boolean bl = fieldExistsInService = this.lookupFieldByName(fieldName) != null;
        if (profileNames.length > 0 && fieldExistsInService) {
            String profileName = condition != null ? condition : this.getDefaultProfileName(this, fieldName, (String[])profileNames);
            varList.add(new DropDownVariable(LBL_PROFILE, profileAliases, profileNames, (Object)profileName));
            varList.addAll(this.getVariablesForConditionProfile(fieldName, profileName, configNode, selectSingleValueConditions));
        } else {
            varList.add(this.myNoAvailableConditionsVar);
        }
        return varList;
    }

    private FieldDefinition lookupField(String name) {
        return this.myClassRepository.getFieldDefinitionByName(name);
    }

    FieldHierarchyNode lookupFieldByName(String fieldName) {
        return this.myClassRepository.getFieldRepository().getFieldByName(fieldName);
    }

    private boolean hasFields(List<Variable> variables) {
        return VarListUtil.getVariableForName(variables, LBL_FIELD) != null;
    }

    private boolean isArrayOrMapAndIsSupported(String fieldName) {
        FieldDefinition field = this.lookupField(fieldName);
        return this.myArrayBaseConditionSupport && field != null && (field.isMap() || field.isArray());
    }

    private boolean isSet(String fieldName) {
        FieldDefinition field = this.lookupField(fieldName);
        return field != null ? field.isSet() : false;
    }

    private boolean isFieldStructure(String fieldName) {
        FieldHierarchyNode fieldNode = this.lookupFieldByName(fieldName);
        return fieldNode != null && !fieldNode.isLeaf();
    }

    private IndexVariableFactory createIndexVariableFactory() {
        return IndexVariableFactory.buildFactory().withHierarchicalFieldSupport(true).withDateTimeInteroperability(this.mySupportDateTimeInteroperability).withFilterableFieldVariable(true).andRepository(this.myClassRepository);
    }

    private boolean addIndexVariableIfFieldIsComplexType(String fieldName, ValueFieldCompositeObject indexObject, List<Variable> l, boolean forceUseIndex) {
        boolean selectSingleValueConditions = false;
        if (this.isFieldStructure(fieldName)) {
            selectSingleValueConditions = true;
        } else {
            Variable indexVariable = null;
            FieldDefinition field = this.lookupField(fieldName);
            if (this.myNewIndexSupportEnabled) {
                indexVariable = this.createIndexVariableFactory().createIndexVariableForField(LBL_INDEX, LBL_INDEX, field, indexObject);
            } else {
                FieldIndexKeyContainer.KeyType keyType = FieldOrientedPluginUtil.getKeyTypeForField(fieldName, this.myClassRepository);
                ValueFieldCompositeObject vfco = indexObject;
                if (keyType != null) {
                    if (vfco == null) {
                        vfco = new ValueFieldCompositeObject(ValueFieldCompositeObject.Mode.Value, "0");
                    }
                    switch (keyType) {
                        case VALUE_LIST: {
                            assert (vfco.getMode() == ValueFieldCompositeObject.Mode.Value) : "In this state the index must not be a field";
                            int index = TreeParseUtil.parseInt(vfco.getFieldOrValueAsString());
                            indexVariable = new IntegerVariable(LBL_INDEX, index, 0, Integer.MAX_VALUE);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("This key type is not handled in FieldSelection: " + (Object)((Object)keyType)));
                        }
                    }
                }
            }
            if (this.isArrayOrMapAndIsSupported(fieldName)) {
                Boolean addIndexVariable = VarListUtil.getBooleanValueForName(l, LBL_USE_INDEX);
                if (addIndexVariable == null) {
                    addIndexVariable = indexObject != null || forceUseIndex;
                    l.add(new BoolVariable(LBL_USE_INDEX, addIndexVariable));
                }
                if (addIndexVariable.booleanValue()) {
                    l.add(indexVariable);
                    selectSingleValueConditions = true;
                }
            } else if (indexVariable != null) {
                l.add(indexVariable);
                selectSingleValueConditions = true;
            }
        }
        return selectSingleValueConditions;
    }

    private void addFieldIfValidation(String fieldName, List<FieldHierarchyNode> fields) {
        FieldDefinition field = this.myClassRepository.getFieldDefinitionByName(fieldName);
        if (field != null && "VALIDATION".equals(field.getParameterType())) {
            fields.add(field);
        }
    }

    private List<Variable> getVariables(String context, String field, String condition, ValueFieldCompositeObject indexObject, Node config) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String selectedContext = this.addOptionalContextVariable(context, l);
        List<FieldHierarchyNode> fieldList = this.extractFields(selectedContext);
        if (!fieldList.isEmpty()) {
            boolean fieldExistsInService;
            if ("null".equals(field) && "null".equals(condition)) {
                return this.getVariables();
            }
            String fieldName = field != null ? field : fieldList.get(0).getCanonicalName();
            this.addFieldIfValidation(fieldName, fieldList);
            l.add(FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(LBL_FIELD, null, fieldList, fieldName));
            boolean useIndex = field == null && condition == null;
            boolean selectSingleValueConditions = this.addIndexVariableIfFieldIsComplexType(fieldName, indexObject, l, useIndex);
            Object[] profileNames = this.extractConditionList(fieldName, selectSingleValueConditions);
            Object[] profileAliases = this.fetchConditionAliases((String[])profileNames);
            boolean bl = fieldExistsInService = this.lookupFieldByName(fieldName) != null;
            if (profileNames.length > 0 && fieldExistsInService) {
                String profileName = condition != null ? condition : this.getDefaultProfileName(this, fieldName, (String[])profileNames);
                l.add(new DropDownVariable(LBL_PROFILE, profileAliases, profileNames, (Object)profileName));
                l.addAll(this.getVariablesForConditionProfile(fieldName, profileName, config, selectSingleValueConditions));
            } else {
                l.add(this.myNoAvailableConditionsVar);
            }
        } else {
            l.add(this.myNoAvailableFieldsVar);
        }
        return l;
    }

    private String addOptionalContextVariable(String context, List<Variable> l) {
        String selectedContext = context;
        if (selectedContext == null || selectedContext.trim().length() == 0) {
            selectedContext = "ALL fields";
        }
        if (this.myHelper.hasContext()) {
            Object[] contexts = this.myHelper.getAllContext();
            l.add(new DropDownVariable(LBL_CONTEXT, (Object)selectedContext, contexts));
        }
        return selectedContext;
    }

    private String[] extractConditionList(String field, boolean selectSingleValueConditions) {
        List<String> supportedConditionList = !selectSingleValueConditions && this.isArrayOrMapAndIsSupported(field) ? FieldSelectionConditionProfile.getSupportedArrayConditionList(this.myHelper, field) : (this.isSet(field) ? FieldSelectionConditionProfile.getSupportedSetConditionList(this.myHelper, field) : (this.isFieldStructure(field) ? this.myHelper.getSupportedFieldStructureConditionProfileNamesForField(field) : FieldSelectionConditionProfile.getSupportedSingleValueConditionList(this.myHelper, field)));
        ConstraintContext ctx = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, field).build();
        List<String> constrainedConditionList = ConstraintService.constrainItems(this, ctx, ConstraintTargetType.CONDITION, this.myClassRepository, supportedConditionList);
        return constrainedConditionList.toArray(new String[constrainedConditionList.size()]);
    }

    private String[] fetchConditionAliases(String[] conditionNames) {
        ArrayList<String> conditionAliasesOrNames = new ArrayList<String>();
        for (String conditionName : conditionNames) {
            String aliasOrName = this.myClassRepository.getBaseConditionAliasOrName(conditionName);
            if (aliasOrName != null) {
                conditionAliasesOrNames.add(aliasOrName);
            }
            if ((aliasOrName = this.myClassRepository.getFieldStructureBaseConditionAliasOrName(conditionName)) == null) continue;
            conditionAliasesOrNames.add(aliasOrName);
        }
        return conditionAliasesOrNames.toArray(new String[conditionAliasesOrNames.size()]);
    }

    static List<String> getSupportedConditionList(ClassRepositoryHelper helper, String fieldName) {
        FieldDefinition def = helper.getClassRepository().getFieldDefinitionByName(fieldName);
        if (def != null) {
            return Arrays.asList(helper.getFieldMappableProfileNamesForField(fieldName));
        }
        return Arrays.asList(helper.getAllFieldMappableProfileNames());
    }

    static List<String> getSupportedSingleValueConditionList(ClassRepositoryHelper helper, String fieldName) {
        ArrayList<String> returnConditions = new ArrayList<String>();
        FieldHierarchyNode def = helper.getClassRepository().getFieldRepository().getFieldByName(fieldName);
        if (def != null) {
            if (def.isLeaf()) {
                returnConditions.addAll(Arrays.asList(helper.getFieldMappableProfileNamesForField(fieldName)));
                List<String> arrayConditions = Arrays.asList(helper.getAnnotatedConditionsForField(fieldName, RequiresMapField.class));
                returnConditions.removeAll(arrayConditions);
                List<String> setConditions = Arrays.asList(helper.getAnnotatedConditionsForField(fieldName, RequiresSetField.class));
                returnConditions.removeAll(setConditions);
            }
        } else {
            returnConditions.addAll(Arrays.asList(helper.getAllFieldMappableProfileNames()));
        }
        return returnConditions;
    }

    static List<String> getSupportedArrayConditionList(ClassRepositoryHelper helper, String fieldName) {
        FieldDefinition def = helper.getClassRepository().getFieldDefinitionByName(fieldName);
        if (def != null) {
            return Arrays.asList(helper.getAnnotatedConditionsForField(fieldName, RequiresMapField.class));
        }
        return Arrays.asList(helper.getAllFieldMappableProfileNames());
    }

    static List<String> getSupportedSetConditionList(ClassRepositoryHelper helper, String fieldName) {
        return Arrays.asList(helper.getAnnotatedConditionsForField(fieldName, RequiresSetField.class));
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        super.setClassRepository(repository);
        this.myHelper = new ClassRepositoryHelper(repository);
        this.checkFeaturesViaClassRepository(repository);
    }

    private void checkFeaturesViaClassRepository(ClassRepository repository) {
        List<String> enabledFeatures = ConstraintService.constrainFeatures(this, repository, FieldSelectionConditionProfile.getSupportedFeatures());
        this.myNewIndexSupportEnabled = enabledFeatures.contains(INDEX_VARIABLE_MAP_SUPPORT_FEATURE);
        this.myArrayBaseConditionSupport = enabledFeatures.contains(MAP_AND_ARRAY_BASE_CONDITION_SUPPORT);
        this.mySupportDateTimeInteroperability = enabledFeatures.contains(DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        StringBuffer indent = new StringBuffer();
        for (int ii = 0; ii < indentLevel + 1; ++ii) {
            indent.append(indentMarker);
        }
        String context = VarListUtil.getValueStringForName(variables, LBL_CONTEXT);
        String field = VarListUtil.getValueStringForName(variables, LBL_FIELD);
        String profile = VarListUtil.getValueStringForName(variables, LBL_PROFILE);
        ValueFieldCompositeObject vfco = this.createObjectForIndexVariable(VarListUtil.getVariableForKey(variables, LBL_INDEX));
        FieldSelectionConditionConfiguration config = new FieldSelectionConditionConfiguration(context, field, profile, vfco);
        PluginConfigurationHelper.writeXML(config, out, indentLevel, indentMarker);
        if (this.hasFields(variables) && this.mySelectedProfile instanceof AbstractConditionProfile) {
            ((AbstractConditionProfile)this.mySelectedProfile).printParametersImpl(out, indentLevel, indentMarker, variables);
        }
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String desc;
        if (this.hasFields(variables)) {
            String conditionInfo = VarListUtil.getValueStringForName(variables, LBL_PROFILE);
            desc = this.getDescription(variables);
            if (this.mySelectedProfile != null) {
                desc = desc + "\nCondition = " + conditionInfo;
            }
        } else {
            desc = this.getName() + " (No available fields found)";
        }
        return GuiUtil.descriptionToTooltip(desc, this.getName(), this.getComment(variables));
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String fieldName = VarListUtil.getValueStringForName(variables, LBL_FIELD);
        FieldHierarchyNode field = this.lookupFieldByName(fieldName);
        boolean fieldExistsInService = field != null;
        String conditionInfo = VarListUtil.getValueStringForName(variables, LBL_PROFILE);
        ValueFieldCompositeObject vfco = this.createObjectForIndexVariable(VarListUtil.getVariableForKey(variables, LBL_INDEX));
        String name = this.getName();
        String info = this.displayableNameWithMessage("No available fields found");
        if (!fieldExistsInService) {
            info = this.displayableNameWithMessage(fieldName);
        } else {
            String fieldNameWithIndex = FieldOrientedPluginProfileUtil.formatFieldNameStringWithIndexOrKeyIfPresent(field, vfco, this.myClassRepository);
            if (VarListUtil.getVariableForName(variables, LBL_ERROR) instanceof NotAllowedVariable) {
                info = this.displayableNameWithMessages(fieldNameWithIndex, conditionInfo);
            } else if (this.mySelectedProfile != null) {
                String re;
                String profileDesc;
                try {
                    profileDesc = this.mySelectedProfile.getDescription(variables);
                }
                catch (Exception e) {
                    profileDesc = null;
                }
                info = profileDesc == null || profileDesc.equals(name) ? this.displayableNameWithMessages(fieldNameWithIndex, conditionInfo) : (profileDesc.matches((re = "^" + name + "\\b") + ".*") ? this.displayableNameWithMessage(profileDesc.replaceFirst(re, Matcher.quoteReplacement(fieldNameWithIndex))) : this.displayableNameWithMessage(profileDesc));
            } else {
                info = this.displayableNameWithMessages(fieldNameWithIndex, "NO condition");
            }
        }
        return info;
    }

    private String displayableNameWithMessage(String str) {
        return this.getName() + " (" + str + ")";
    }

    private String displayableNameWithMessages(String str1, String str2) {
        return this.getName() + " (" + str1 + " " + str2 + ")";
    }

    private void removeAllAfter(List<Variable> vars, String label) {
        while (!vars.get(vars.size() - 1).getLabel().equals(label)) {
            vars.remove(vars.size() - 1);
        }
    }

    @Override
    public boolean parameterChanged(String label, Variable value, List<Variable> vars) {
        String field;
        boolean changed = false;
        if (LBL_CONTEXT.equals(label)) {
            this.removeAllAfter(vars, label);
            String context = VarListUtil.getValueStringForName(vars, LBL_CONTEXT);
            List<FieldHierarchyNode> fieldList = this.extractFields(context);
            if (!fieldList.isEmpty()) {
                vars.add(FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(LBL_FIELD, null, fieldList, fieldList.get(0).getCanonicalName()));
                changed = true;
            } else {
                vars.add(this.myNoAvailableFieldsVar);
                return true;
            }
        }
        if (LBL_FIELD.equals(label) || changed) {
            if (!changed) {
                this.removeAllAfter(vars, label);
            }
            if (this.isArrayOrMapAndIsSupported(field = VarListUtil.getValueStringForName(vars, LBL_FIELD))) {
                vars.add(new BoolVariable(LBL_USE_INDEX, true));
            }
            changed = true;
        }
        if (LBL_USE_INDEX.equals(label) || changed) {
            if (!changed) {
                this.removeAllAfter(vars, label);
            }
            field = VarListUtil.getValueStringForName(vars, LBL_FIELD);
            boolean selectSingleValueConditions = this.addIndexVariableIfFieldIsComplexType(field, null, vars, false);
            Variable conditionVar = this.getConditionDropDown(field, selectSingleValueConditions);
            vars.add(conditionVar);
            changed = true;
        }
        if (LBL_PROFILE.equals(label) || changed) {
            Variable conditionVar;
            if (!changed) {
                this.removeAllAfter(vars, label);
            }
            field = VarListUtil.getValueStringForName(vars, LBL_FIELD);
            String profileName = VarListUtil.getValueStringForName(vars, LBL_PROFILE);
            boolean selectSingleValueConditions = true;
            if (this.isArrayOrMapAndIsSupported(field)) {
                selectSingleValueConditions = VarListUtil.getBooleanValueForName(vars, LBL_USE_INDEX);
            }
            if (!((conditionVar = this.getConditionDropDown(field, selectSingleValueConditions)) instanceof NotAllowedVariable)) {
                vars.addAll(this.getVariablesForConditionProfile(field, profileName, null, selectSingleValueConditions));
            }
            StatusPanel.getInstance().setStatusMsg("");
            changed = true;
        }
        if (!changed && this.mySelectedProfile != null) {
            changed = this.mySelectedProfile.parameterChanged(label, value, vars);
        }
        return changed;
    }

    private Variable getConditionDropDown(String field, boolean selectSingleValueConditions) {
        Object[] profileNames = this.extractConditionList(field, selectSingleValueConditions);
        Object[] profileAliases = this.fetchConditionAliases((String[])profileNames);
        BaseVariable conditionVar = profileNames.length > 0 ? new DropDownVariable(LBL_PROFILE, profileAliases, profileNames, (Object)this.getDefaultProfileName(this, field, (String[])profileNames)) : this.myNoAvailableConditionsVar;
        return conditionVar;
    }

    private List<Variable> getVariablesForConditionProfile(String field, String profileName, Node config, boolean selectSingleValueConditions) {
        String profileToUse = profileName == null ? this.extractConditionList(field, selectSingleValueConditions)[0] : profileName;
        ArrayList<Variable> vars = new ArrayList<Variable>();
        this.mySelectedProfile = this.myHelper.getConditionProfile(field, profileToUse);
        if (this.mySelectedProfile != null) {
            if (this.mySelectedProfile instanceof TestCaseGenerationConditionInterface) {
                FieldDefinition fieldDefinition = this.lookupField(field);
                ((TestCaseGenerationConditionInterface)((Object)this.mySelectedProfile)).setTestFieldDefinition(fieldDefinition);
            }
            try {
                vars.addAll(config != null ? this.mySelectedProfile.getVariables(config) : this.mySelectedProfile.getVariables());
            }
            catch (Exception e) {
                long logNum = ExceptionUtil.handleException(e, "ratingRuleFrame", 1, "The base condition profile failed to create variables.", false);
                String msg = String.format("Failed to initialize the base condition. Please see log entry %d for more details.", logNum);
                vars.add(new NotAllowedVariable(LBL_ERROR, msg));
            }
        } else {
            vars.add(new NotAllowedVariable("", "Selected condition is not compatible with selected field"));
        }
        return vars;
    }

    private List<FieldHierarchyNode> extractFields(String context) {
        AvailableFieldListBuilder builder = AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myClassRepository).withHierarchicalFields().withConstraints(this, null).withContext(context).withFilter(new FieldSelectionFilter());
        return builder.buildList();
    }

    private boolean isComplexFieldInComplexFieldStructure(FieldDefinition field) {
        return field.getComplexType() != FieldHierarchyNode.ComplexType.NONE && field.getParent() != null && field.getParent().getComplexType() != FieldHierarchyNode.ComplexType.NONE;
    }

    private static boolean isFieldOrAncestorMap(FieldHierarchyNode node) {
        boolean isMap = false;
        if (node != null) {
            isMap = node.getComplexType() == FieldHierarchyNode.ComplexType.MAP || FieldSelectionConditionProfile.isFieldOrAncestorMap(node.getParent());
        }
        return isMap;
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        if (this.mySelectedProfile instanceof TestCaseGenerationConditionInterface) {
            return ((TestCaseGenerationConditionInterface)((Object)this.mySelectedProfile)).getTestVariables(variableValueIterator, testSettingsIterator);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        if (this.mySelectedProfile instanceof TestCaseGenerationConditionInterface) {
            return ((TestCaseGenerationConditionInterface)((Object)this.mySelectedProfile)).getTestSimulationFieldValues(variableValueIterator, testSettingsIterator);
        }
        return Collections.emptyMap();
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
        if (this.mySelectedProfile instanceof TestCaseGenerationConditionInterface) {
            ((TestCaseGenerationConditionInterface)((Object)this.mySelectedProfile)).printTestVariables(out, vars);
        }
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        if (this.mySelectedProfile instanceof TestCaseGenerationConditionInterface) {
            return ((TestCaseGenerationConditionInterface)((Object)this.mySelectedProfile)).testParameterChanged(reference, value, vars);
        }
        return false;
    }

    @Override
    public boolean supportsProductTag(ClassRepository repository, List<Variable> stateVariables) {
        if (this.mySelectedProfile instanceof ProductTagClassProfile) {
            return ((ProductTagClassProfile)((Object)this.mySelectedProfile)).supportsProductTag(repository, stateVariables);
        }
        return false;
    }

    private String getDefaultProfileName(ClassProfile profile, String fieldName, String[] candidateList) {
        ConstraintContext ctx = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, fieldName).build();
        return ConstraintService.constrainDefaultItem(this, ctx, this.myClassRepository, candidateList);
    }

    static List<String> getSupportedFeatures() {
        return Arrays.asList(SUPPORTED_FEATURES);
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = this.createMapIfNonExisting(prev);
        Element fieldElement = XMLUtil.getNamedElement("Field", data.getChildNodes());
        displayValuesMap.put(LBL_PROFILE, fieldElement.getAttribute("condition"));
        displayValuesMap.put(LBL_FIELD, fieldElement.getAttribute("field"));
        Element indexElement = XMLUtil.getNamedElement("Index", fieldElement.getChildNodes());
        if (indexElement != null) {
            Element indexValueElement = XMLUtil.getNamedElement("Value", indexElement.getChildNodes());
            displayValuesMap.put(LBL_INDEX, XMLUtil.getFirstTextContent(indexValueElement));
        }
        if (this.mySelectedProfile instanceof ClassProfileV2) {
            return ((ClassProfileV2)((Object)this.mySelectedProfile)).getDisplayValues(data, displayValuesMap);
        }
        return displayValuesMap;
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = this.createMapIfNonExisting(prev);
        String field = VarListUtil.getValueStringForName(variables, LBL_FIELD);
        displayValuesMap.put(LBL_FIELD, field);
        String condition = VarListUtil.getValueStringForName(variables, LBL_PROFILE);
        displayValuesMap.put(LBL_PROFILE, condition);
        if (this.mySelectedProfile instanceof ClassProfileV2) {
            return ((ClassProfileV2)((Object)this.mySelectedProfile)).getDisplayValues(variables, displayValuesMap);
        }
        return displayValuesMap;
    }

    private Map<String, Object> createMapIfNonExisting(Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = prev;
        if (displayValuesMap == null) {
            displayValuesMap = new HashMap<String, Object>();
        }
        return displayValuesMap;
    }

    @Override
    public String[] getTreeDefinedFieldInUse(List<Variable> profileState) {
        HashSet<String> usedTDFs = new HashSet<String>();
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForName(profileState, LBL_FIELD), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForName(profileState, LBL_INDEX), this.myClassRepository, true));
        String[] usedByProfile = new String[]{};
        if (this.mySelectedProfile instanceof TreeDefinedFieldUser2) {
            usedByProfile = ((TreeDefinedFieldUser2)((Object)this.mySelectedProfile)).getTreeDefinedFieldInUse(profileState);
        } else if (this.mySelectedProfile instanceof TreeDefinedFieldUser) {
            usedByProfile = ((TreeDefinedFieldUser)((Object)this.mySelectedProfile)).getTreeDefinedFieldInUse();
        }
        usedTDFs.addAll(Arrays.asList(usedByProfile));
        return usedTDFs.toArray(new String[usedTDFs.size()]);
    }

    private class FieldSelectionFilter
    implements HierarchicalFieldFilter {
        private FieldSelectionFilter() {
        }

        @Override
        public boolean isAllowed(FieldHierarchyNode field) {
            boolean allowed = true;
            if (field.isLeaf()) {
                FieldDefinition fieldDefinition = (FieldDefinition)field;
                allowed = fieldDefinition.isFieldOriented();
                allowed &= !field.isKey();
                allowed &= !FieldSelectionConditionProfile.this.isComplexFieldInComplexFieldStructure(fieldDefinition);
                if (!FieldSelectionConditionProfile.this.myNewIndexSupportEnabled) {
                    allowed &= !FieldSelectionConditionProfile.isFieldOrAncestorMap(field);
                }
            }
            return allowed;
        }
    }
}

