/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.field;

import com.ericsson.ere.annotations.ConfigurationClass;
import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.SelectionTreeNodeFactoryImpl;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.selectiontree.conditions.field.FieldSelectionConditionConfiguration;
import com.ericsson.ere.selectiontree.conditions.field.FieldSelectionParseContext;
import com.ericsson.ere.selectiontree.interfaces.EnumMap;
import com.ericsson.ere.selectiontree.interfaces.FieldArraySupport;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexSupport;
import com.ericsson.ere.selectiontree.interfaces.MutableCondition;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.trace.TracePoint;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.Map;
import org.w3c.dom.Node;

@Immutable
@ConfigurationClass(value=FieldSelectionConditionConfiguration.class)
public final class FieldSelectionCondition
extends ImmutableCondition {
    private static final TariffStructureNode[] EMPTY_CHILDREN = new TariffStructureNode[0];
    public static final String ATTR_CONTEXT = "Context";
    public static final String TAG_FIELD = "Field";
    public static final String TAG_INDEX = "Index";
    public static final String ATTR_FIELD = "field";
    public static final String ATTR_CONDITION = "condition";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_INDEX = "index";

    private FieldSelectionCondition() {
        super(null);
    }

    public static TariffStructureNode create(ParseContext context, TariffStructureNode[] notused) {
        TariffStructureNode condition;
        Node config = context.getXMLNode();
        ClassRepository repository = context.getClassRepository();
        FieldSelectionConditionConfiguration conf = new FieldSelectionConditionConfiguration(context);
        conf.requireMandatoryParameters();
        String fieldName = conf.getFieldName();
        if (repository.getFieldRepository().getFieldByName(fieldName) == null) {
            throw new PluginCreationException("Referenced field " + fieldName + " does not exist.");
        }
        Map<String, String> enumMap = FieldSelectionCondition.extractEnumerationMap(repository, fieldName);
        CustomNodeFactory factory = new CustomNodeFactory(repository, conf.getBaseConditionName(), fieldName, enumMap, conf.getKeyIndex());
        try {
            condition = factory.createCondition(config, EMPTY_CHILDREN);
        }
        catch (Exception e) {
            throw new PluginCreationException(e.getCause());
        }
        return condition;
    }

    private static Map<String, String> extractEnumerationMap(ClassRepository repository, String fieldName) {
        FieldDefinition field = repository.getFieldDefinitionByName(fieldName);
        return field != null ? field.getEnumMap() : null;
    }

    @Override
    public boolean test(DataSet theData) {
        throw new IllegalArgumentException("Not to be used.");
    }

    @Override
    public String describeTrace(TracePoint tp) {
        throw new IllegalArgumentException("Not to be used.");
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
        throw new IllegalArgumentException("Not to be used.");
    }

    private static class CustomNodeFactory
    extends SelectionTreeNodeFactoryImpl {
        private final String myBaseConditionName;
        private final Map<String, String> myEnumMap;
        private final String myFieldName;
        private final FieldIndexKeyContainer myKeyIndex;

        CustomNodeFactory(ClassRepository rep, String baseConditionName, String fieldName, Map<String, String> enumMap, FieldIndexKeyContainer keyIndex) {
            super(rep);
            this.myBaseConditionName = baseConditionName;
            this.myFieldName = fieldName;
            this.myEnumMap = enumMap;
            this.myKeyIndex = keyIndex;
        }

        @Override
        protected ParseContext createParseContext(final ClassRepository repository, final String ratingPlan, final Node config) {
            return new FieldSelectionParseContext(){

                @Override
                public Map<String, String> getEnumMap() {
                    return myEnumMap;
                }

                @Override
                public FieldIndexKeyContainer getKeyIndex() {
                    return myKeyIndex;
                }

                @Override
                public ClassRepository getClassRepository() {
                    return repository;
                }

                @Override
                public String getRatingPlanName() {
                    return ratingPlan;
                }

                @Override
                public Node getXMLNode() {
                    return config;
                }

                @Override
                public String getFieldName() {
                    return myFieldName;
                }
            };
        }

        @Override
        protected String getConditionClassName(ClassRepository repository, String name) {
            String useName = this.myBaseConditionName;
            String classname = repository.getBaseConditionClass(useName);
            if (classname == null) {
                classname = repository.getFieldStructureBaseConditionClass(useName);
            }
            if (classname == null) {
                classname = repository.getConditionClassName(useName);
            }
            return classname;
        }

        @Override
        protected String getConditionFieldName(ClassRepository repository, String name) {
            return this.myFieldName;
        }

        @Override
        protected void initMutableCondition(String name, MutableCondition mc) {
            super.initMutableCondition(name, mc);
            if (this.myKeyIndex != null) {
                if (mc instanceof FieldKeyIndexSupport) {
                    ((FieldKeyIndexSupport)((Object)mc)).setKeyIndex(this.myKeyIndex);
                } else if (mc instanceof FieldArraySupport) {
                    Key key = this.myKeyIndex.getFirstKey(null);
                    ((FieldArraySupport)((Object)mc)).setIndex(key.getIndex());
                }
            }
            if (mc instanceof EnumMap && this.myEnumMap != null) {
                ((EnumMap)((Object)mc)).setEnumMap(this.myEnumMap);
            }
        }
    }
}

