/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.field;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.EreXmlException;
import ericsson.ere.xml.XMLUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public final class DoesFieldExistCondition
extends ImmutableCondition
implements TraceableV2 {
    public static final String TAG_FIELD = "Field";
    private final ClassRepository myRepository;
    private final FieldIndexKeyContainer myKeyContainer;
    private final FieldHierarchyNode myFieldHierarchyNode;
    private final DataSetField myPlainField;

    private DoesFieldExistCondition(ParseContext ctx) {
        super(ctx, DoesFieldExistCondition.getFieldNameToUse(ctx));
        this.myRepository = ctx.getClassRepository();
        Element fieldElement = DoesFieldExistCondition.getConditionSettingsElement(ctx);
        String fieldName = XMLUtil.getFirstTextContent(fieldElement);
        this.myFieldHierarchyNode = this.myRepository.getFieldRepository().getFieldByName(fieldName);
        try {
            Element indexElement = XMLUtil.getFirstElementNamed("Index", fieldElement);
            this.myKeyContainer = FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(indexElement, this.myRepository, this.myFieldHierarchyNode);
        }
        catch (IllegalArgumentException iae) {
            throw new PluginCreationException(iae);
        }
        FieldOrientedPluginUtil.checkMissingFields(this, this.myRepository);
        this.myPlainField = this.usesOnlyNonHierarchicalFields() && this.myFieldHierarchyNode != null ? new DataSetField((FieldDefinition)this.myFieldHierarchyNode) : null;
    }

    private boolean usesOnlyNonHierarchicalFields() {
        boolean retVal = true;
        for (String usedField : this.getUsedFields()) {
            FieldHierarchyNode def = this.myRepository.getFieldRepository().getFieldByName(usedField);
            if (def.isLeaf() && def.getParent() == null) continue;
            retVal = false;
            break;
        }
        return retVal;
    }

    private static String getFieldNameToUse(ParseContext ctx) {
        return XMLUtil.getFirstTextContent(DoesFieldExistCondition.getConditionSettingsElement(ctx));
    }

    private static Element getConditionSettingsElement(ParseContext ctx) {
        Node configNode = ctx.getXMLNode();
        Element fieldElement = XMLUtil.getFirstElementNamed(TAG_FIELD, (Element)configNode);
        if (fieldElement == null) {
            throw new EreXmlException("The tag Field is missing");
        }
        return fieldElement;
    }

    @Override
    public boolean test(DataSet theData) {
        boolean retVal;
        if (this.myPlainField != null) {
            retVal = this.myKeyContainer != null ? this.myPlainField.doesDataExistInDataSet(theData, FieldOrientedPluginUtil.extractFirstKeyFromSet(this.myKeyContainer.getKeySet(theData))) : this.myPlainField.doesDataExistInDataSet(theData);
        } else {
            List<Key> list = this.myKeyContainer == null ? null : Arrays.asList(FieldOrientedPluginUtil.extractFirstKeyFromSet(this.myKeyContainer.getKeySet(theData)));
            retVal = theData.getAccessor().hasValue(this.myFieldHierarchyNode, list);
        }
        return retVal;
    }

    public static DoesFieldExistCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new DoesFieldExistCondition(ctx);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myFieldHierarchyNode == null ? 0 : this.myFieldHierarchyNode.hashCode());
        result = 31 * result + (this.myKeyContainer == null ? 0 : this.myKeyContainer.hashCode());
        result = 31 * result + (this.myRepository == null ? 0 : this.myRepository.hashCode());
        result = 31 * result + (this.myPlainField == null ? 0 : this.myPlainField.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoesFieldExistCondition other = (DoesFieldExistCondition)obj;
        if (this.myFieldHierarchyNode == null ? other.myFieldHierarchyNode != null : !this.myFieldHierarchyNode.equals(other.myFieldHierarchyNode)) {
            return false;
        }
        if (this.myKeyContainer == null ? other.myKeyContainer != null : !this.myKeyContainer.equals(other.myKeyContainer)) {
            return false;
        }
        if (this.myRepository == null ? other.myRepository != null : !this.myRepository.equals(other.myRepository)) {
            return false;
        }
        return !(this.myPlainField == null ? other.myPlainField != null : !this.myPlainField.equals(other.myPlainField));
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        StringBuilder buf = new StringBuilder();
        buf.append("DoesFieldExist : ");
        buf.append(this.myKeyContainer == null ? this.getKey() : FieldOrientedPluginUtil.formatFieldNameWithKeyInformation(this.getKey(), this.myKeyContainer, dataSet));
        buf.append(" exists");
        return buf.toString();
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        if (this.myFieldHierarchyNode.isLeaf()) {
            PluginTraceHelper.addFieldValueAsPreDataInTracePoint(new DataSetField((FieldDefinition)this.myFieldHierarchyNode), this.myKeyContainer, tp);
        } else {
            PluginTraceHelper.addFieldKeysAsPreDataInTracePoint(this.myKeyContainer, tp);
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> list = super.getUsedFields();
        if (this.myKeyContainer != null) {
            list.addAll(this.myKeyContainer.getUsedFields());
        }
        return list;
    }
}

