/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.datelist;

public class SpecialDate
implements Cloneable,
Comparable<SpecialDate> {
    public static final int WILDCARD = -1;
    private short year;
    private byte month;
    private byte day;

    public SpecialDate(int y, int m, int d) {
        if (y < Short.MIN_VALUE || y > Short.MAX_VALUE || m < -128 || m > 127 || d < -128 || d > 127 || !this.isValidDate((short)y, (byte)m, (byte)d)) {
            throw new IllegalArgumentException("Illegal date value: [" + y + ", " + m + ", " + d + "]");
        }
        this.year = (short)y;
        this.month = (byte)m;
        this.day = (byte)d;
    }

    public SpecialDate(short y, byte m, byte d) {
        if (!this.isValidDate(y, m, d)) {
            throw new IllegalArgumentException("Illegal date value: [" + y + ", " + m + ", " + d + "]");
        }
        this.year = y;
        this.month = m;
        this.day = d;
    }

    private boolean isValidDate(short y, byte m, byte d) {
        if ((y == -1 || y > 999 && y <= 9999) && (m == -1 || m > 0 && m <= 12)) {
            if (d == -1 || d > 0 && d <= 28) {
                return true;
            }
            if (d == 29) {
                return m != 2 || SpecialDate.isLeap(y);
            }
            if (d == 30 && m != 2) {
                return true;
            }
            if (d == 31 && (m == -1 || m == 1 || m == 3 || m == 5 || m == 7 || m == 8 || m == 10 || m == 12)) {
                return true;
            }
        }
        return false;
    }

    public SpecialDate clone() {
        return new SpecialDate(this.year, this.month, this.day);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpecialDate other = (SpecialDate)obj;
        if (this.day != other.day) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        return this.year == other.year;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.day;
        result = 31 * result + this.month;
        result = 31 * result + this.year;
        return result;
    }

    @Override
    public int compareTo(SpecialDate other) {
        if (this.year != other.year) {
            return this.year - other.year;
        }
        if (this.month != other.month) {
            return this.month - other.month;
        }
        if (this.day != other.day) {
            return this.day - other.day;
        }
        return 0;
    }

    public boolean matches(SpecialDate other) {
        return !(-1 != this.year && this.year != other.year || -1 != this.month && this.month != other.month || -1 != this.day && this.day != other.day);
    }

    public SpecialDate next() {
        if (this.year <= 0 || this.month <= 0 || this.day <= 0) {
            throw new IllegalArgumentException("It is not possible to increment a wildcarded date.");
        }
        if (this.day < 28) {
            this.day = (byte)(this.day + 1);
        } else if (this.day == 28) {
            if (this.month == 2 && !SpecialDate.isLeap(this.year)) {
                this.month = (byte)3;
                this.day = 1;
            } else {
                this.day = (byte)(this.day + 1);
            }
        } else if (this.day == 29) {
            if (this.month == 2 && SpecialDate.isLeap(this.year)) {
                this.month = (byte)3;
                this.day = 1;
            } else {
                this.day = (byte)(this.day + 1);
            }
        } else if (this.day == 30) {
            if (this.month == 4 || this.month == 6 || this.month == 9 || this.month == 11) {
                this.month = (byte)(this.month + 1);
                this.day = 1;
            } else {
                this.day = (byte)(this.day + 1);
            }
        } else if (this.day == 31) {
            if (this.month == 12) {
                this.year = (short)(this.year + 1);
                this.month = 1;
                this.day = 1;
            } else {
                this.month = (byte)(this.month + 1);
                this.day = 1;
            }
        } else {
            throw new RuntimeException("Internal error, day should be [1,31], was: " + this.day);
        }
        return this;
    }

    public static boolean isLeap(int year) {
        if (year % 100 == 0 && year % 400 != 0) {
            return false;
        }
        return year % 4 == 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(8);
        if (this.year < 0) {
            buf.append("*");
        } else {
            buf.append(String.valueOf(this.year));
        }
        if (this.month < 0) {
            buf.append("*");
        } else {
            if (this.month < 10) {
                buf.append("0");
            }
            buf.append(String.valueOf(this.month));
        }
        if (this.day < 0) {
            buf.append("*");
        } else {
            if (this.day < 10) {
                buf.append("0");
            }
            buf.append(String.valueOf(this.day));
        }
        return buf.toString();
    }

    public boolean willMatchLater(SpecialDate other) {
        return !(-1 != this.year && this.year < other.year || -1 != this.month && this.month < other.month || -1 != this.day && this.day < other.day);
    }
}

