/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.date;

import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.selectiontree.AbstractBaseConditionProfile;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import com.ericsson.ere.selectiontree.util.OperatorUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresNonMapField
public class DateConditionProfile
extends AbstractBaseConditionProfile
implements FieldMappable,
TestCaseGenerationConditionInterface {
    public static final String LABEL_DATE_OPERATOR = "Operator";
    public static final String LABEL_DATE_VALUE = "Date";
    private FieldDefinition myTestCaseGenFieldDefinition;

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        this.addInputVariables(l, OperatorUtil.operatorString[0], null);
        return l;
    }

    private void addInputVariables(List<Variable> l, String selection, String value) {
        l.add(new DropDownVariable(LABEL_DATE_OPERATOR, (Object)selection, (Object[])OperatorUtil.operatorString));
        l.add(this.createInputVariable(LABEL_DATE_VALUE, LABEL_DATE_VALUE, value, DataType.DATE));
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        NodeList childNodes = iterator.getChildNodes();
        Element operatorNode = XMLUtil.getNamedElement(LABEL_DATE_OPERATOR, childNodes);
        String operator = XMLUtil.getFirstTextContent(operatorNode);
        String valueField = null;
        Element valueFieldNode = XMLUtil.getNamedElement("DateValue", childNodes);
        if (valueFieldNode != null) {
            valueField = XMLUtil.getFirstTextContent(valueFieldNode);
        }
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        this.addInputVariables(l, OperatorUtil.tokenToOperator(operator), valueField);
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        int i;
        String operator = VarListUtil.getValueStringForName(variables, LABEL_DATE_OPERATOR);
        String value = VarListUtil.getValueStringForName(variables, LABEL_DATE_VALUE);
        String operatorAsString = OperatorUtil.operatorToToken(operator);
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<Operator>" + operatorAsString + "</" + LABEL_DATE_OPERATOR + ">");
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<DateValue>" + value + "</" + "DateValue" + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String data = VarListUtil.getValueStringForName(variables, LABEL_DATE_OPERATOR);
        String value = this.makeDisplayString(VarListUtil.getVariableForKey(variables, LABEL_DATE_VALUE));
        data = data + " " + value;
        StringBuffer buf = new StringBuffer("<b>").append(name).append("</b> (");
        buf.append(GuiUtil.replaceSubString(data, "<", "&lt;")).append(")\n").append(this.getComment(variables));
        return GuiUtil.multilineTooltipWrapper(buf.toString());
    }

    private String makeDisplayString(Variable valueVar) {
        String value = valueVar.toString();
        if (EREDateUtil.isBoundaryDate(valueVar.getValueObject())) {
            value = this.makeDisplayString(value, DataType.DATE);
        }
        return value;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String operator = VarListUtil.getValueStringForName(variables, LABEL_DATE_OPERATOR);
        String value = this.makeDisplayString(VarListUtil.getVariableForKey(variables, LABEL_DATE_VALUE));
        return name + " " + operator + " " + value;
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myTestCaseGenFieldDefinition = fieldDefinition;
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element operatorNode = XMLUtil.getFirstElementNamed(LABEL_DATE_OPERATOR, (Element)variableValueIterator);
        Element valueNode = XMLUtil.getFirstElementNamed("DateValue", (Element)variableValueIterator);
        String fieldName = this.myTestCaseGenFieldDefinition.getFieldName();
        HashMap<String, Object> testCaseData = new HashMap<String, Object>(2);
        if (operatorNode != null && valueNode != null) {
            String operatorString = operatorNode.getTextContent();
            String valueString = valueNode.getTextContent();
            if (operatorString.equals("GT")) {
                if (!valueString.equals(this.getMaximumValue())) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTimeInMillis(Integer.MAX_VALUE);
                    testCaseData.put(fieldName, cal);
                }
            } else if (operatorString.equals("LT")) {
                if (!valueString.equals(this.getMinimumValue())) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTimeInMillis(-3600L);
                    testCaseData.put(fieldName, cal);
                }
            } else {
                testCaseData.put(fieldName, valueString);
            }
        }
        if (testCaseData.size() == 0) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        return testCaseData;
    }

    private Object getMaximumValue() {
        return "19700101T000000000";
    }

    private Object getMinimumValue() {
        return "99991231T000000000";
    }

    @Override
    public boolean needsRepository() {
        return true;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        this.myRepository = repository;
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        return null;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }

    private Map<String, Object> createMapIfNonExisting(Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = prev;
        if (displayValuesMap == null) {
            displayValuesMap = new HashMap<String, Object>();
        }
        return displayValuesMap;
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = this.createMapIfNonExisting(prev);
        Element operatorElement = XMLUtil.getNamedElement(LABEL_DATE_OPERATOR, data.getChildNodes());
        Element valueElement = XMLUtil.getNamedElement("DateValue", data.getChildNodes());
        String operatorValue = operatorElement.getTextContent();
        String value = valueElement.getTextContent();
        displayValuesMap.put(LABEL_DATE_OPERATOR, OperatorUtil.tokenToOperator(operatorValue));
        displayValuesMap.put(LABEL_DATE_VALUE, this.makeDisplayString(value, DataType.DATE));
        return displayValuesMap;
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = this.createMapIfNonExisting(prev);
        String op = VarListUtil.getValueStringForName(variables, LABEL_DATE_OPERATOR);
        displayValuesMap.put(LABEL_DATE_OPERATOR, op);
        Variable valueVar = VarListUtil.getVariableForKey(variables, LABEL_DATE_VALUE);
        String value = this.makeDisplayString(valueVar);
        displayValuesMap.put(LABEL_DATE_VALUE, value);
        return displayValuesMap;
    }

    @Override
    public boolean handlesCachedPrint(Node xmlNode) {
        return false;
    }

    @Override
    public void cachedPrint(PrintWriter out, int indentLevel, String indent, TariffStructureNode tsNode, Node xmlNode) {
    }
}

