/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.bit;

import com.ericsson.ere.selectiontree.conditions.bit.AbstractBitPatternMatcher;

public class ValuePairMatcher
extends AbstractBitPatternMatcher {
    private Number myValue;
    private Number myMask;

    public ValuePairMatcher(Number value, Number mask) {
        this.myValue = value;
        this.myMask = mask;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myMask == null ? 0 : this.myMask.hashCode());
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValuePairMatcher other = (ValuePairMatcher)obj;
        if (this.myMask == null ? other.myMask != null : !this.myMask.equals(other.myMask)) {
            return false;
        }
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }

    @Override
    public boolean match(Number aValue) {
        return (aValue.longValue() & this.myMask.longValue()) == (this.myValue.longValue() & this.myMask.longValue());
    }

    @Override
    public boolean matchWithTrace(Number aValue, StringBuilder traceString) {
        boolean match;
        boolean bl = match = aValue != null && this.match(aValue);
        if (match) {
            traceString.append("(0x").append(ValuePairMatcher.getHexadecimalRepresentation(aValue)).append(") matches 0x").append(ValuePairMatcher.getHexadecimalRepresentation(this.myValue)).append(" (0x").append(ValuePairMatcher.getHexadecimalRepresentation(this.myMask)).append(")\n");
        }
        return match;
    }
}

