/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.bit;

import com.ericsson.ere.selectiontree.conditions.bit.AbstractBitPatternMatcher;

public class RangeMatcher
extends AbstractBitPatternMatcher {
    private Number myStartValue;
    private Number myStopValue;

    public RangeMatcher(Number aStartValue, Number aStopValue) {
        this.myStartValue = aStartValue;
        this.myStopValue = aStopValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myStartValue == null ? 0 : this.myStartValue.hashCode());
        result = 31 * result + (this.myStopValue == null ? 0 : this.myStopValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeMatcher other = (RangeMatcher)obj;
        if (this.myStartValue == null ? other.myStartValue != null : !this.myStartValue.equals(other.myStartValue)) {
            return false;
        }
        return !(this.myStopValue == null ? other.myStopValue != null : !this.myStopValue.equals(other.myStopValue));
    }

    @Override
    public boolean match(Number aValue) {
        return aValue.longValue() == this.myStartValue.longValue() || aValue.longValue() == this.myStopValue.longValue() || this.compareUnsignedGT(aValue.longValue(), this.myStartValue.longValue()) && this.compareUnsignedLT(aValue.longValue(), this.myStopValue.longValue());
    }

    @Override
    public boolean matchWithTrace(Number aValue, StringBuilder traceString) {
        boolean match;
        boolean bl = match = aValue != null && this.match(aValue);
        if (match) {
            traceString.append("(0x").append(RangeMatcher.getHexadecimalRepresentation(aValue)).append(") is in range between 0x").append(RangeMatcher.getHexadecimalRepresentation(this.myStartValue)).append(" and 0x").append(RangeMatcher.getHexadecimalRepresentation(this.myStopValue)).append("\n");
        }
        return match;
    }

    private boolean compareUnsignedGT(long paramOne, long paramTwo) {
        if (paramTwo >= 0L && paramOne >= 0L || paramTwo < 0L && paramOne < 0L) {
            return paramOne > paramTwo;
        }
        return paramOne <= paramTwo;
    }

    private boolean compareUnsignedLT(long paramOne, long paramTwo) {
        if (paramTwo >= 0L && paramOne >= 0L || paramTwo < 0L && paramOne < 0L) {
            return paramOne < paramTwo;
        }
        return paramOne >= paramTwo;
    }
}

