/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.bit;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.conditions.bit.AbstractBitPatternMatcher;
import com.ericsson.ere.selectiontree.conditions.bit.BitPatternMatcher;
import com.ericsson.ere.selectiontree.conditions.bit.BitPatternMatcherFactory;
import com.ericsson.ere.trace.TraceNodeCondition;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public final class BitPatternCondition
extends ImmutableFieldMappableCondition
implements TraceableV2 {
    private final List<BitPatternMatcher> myValues = new ArrayList<BitPatternMatcher>();
    private static final String TAG_DATATYPE = "DataType";
    private static final String TAG_VALUE = "Value";
    private static final Object FIELD_VALUE = new Object();

    public static BitPatternCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new BitPatternCondition(ctx);
    }

    private BitPatternCondition(ParseContext ctx) {
        super(ctx);
        Node config = ctx.getXMLNode();
        NodeList children = config.getChildNodes();
        Element dataTypeNode = XMLUtil.getNamedElement(TAG_DATATYPE, children);
        if (dataTypeNode == null) {
            throw new PluginCreationException("Missing element: DataType");
        }
        String aDataTypeString = XMLUtil.getFirstTextContent(dataTypeNode);
        Element valueNode = XMLUtil.getNamedElement(TAG_VALUE, children);
        if (valueNode == null) {
            throw new PluginCreationException("Missing element: Value");
        }
        String numberList = XMLUtil.getFirstTextContent(valueNode);
        try {
            ArrayList<BitPatternMatcher> aList = BitPatternMatcherFactory.createBitPatternMatchers(numberList, DataType.lookup(aDataTypeString));
            for (BitPatternMatcher currentValuePair : aList) {
                this.myValues.add(currentValuePair);
            }
        }
        catch (Exception e) {
            throw new PluginCreationException("Error in BitPatternCondition.create(...) when initiating data from XML\n" + config + "\n" + e.toString(), e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myValues == null ? 0 : this.myValues.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitPatternCondition other = (BitPatternCondition)obj;
        return !(this.myValues == null ? other.myValues != null : !this.myValues.equals(other.myValues));
    }

    @Override
    public boolean test(DataSet dataSet) {
        Number valueToTest = null;
        try {
            valueToTest = this.getNumberFromDataSet(dataSet);
        }
        catch (DataSetValueNotFoundException e) {
            return false;
        }
        for (int i = 0; i < this.myValues.size(); ++i) {
            BitPatternMatcher currentVP = this.myValues.get(i);
            if (!currentVP.match(valueToTest)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        Number valueToTest = (Number)tp.getInfo(FIELD_VALUE);
        StringBuilder traceBuilder = new StringBuilder("BitPattern : ").append(this.key);
        boolean result = (Boolean)tp.getInfo(TraceNodeCondition.TEST_RESULT);
        if (result) {
            for (BitPatternMatcher currentMatcher : this.myValues) {
                if (currentMatcher.matchWithTrace(valueToTest, traceBuilder)) break;
            }
        } else {
            traceBuilder.append("(");
            if (valueToTest != null) {
                traceBuilder.append("0x").append(AbstractBitPatternMatcher.getHexadecimalRepresentation(valueToTest));
            } else {
                traceBuilder.append("[VALUE NOT FOUND]");
            }
            traceBuilder.append(") matches any of the patterns");
        }
        return traceBuilder.toString();
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        try {
            tp.addInfo(FIELD_VALUE, this.getNumberFromDataSet(tp.getPreDataSet()));
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    private Number getNumberFromDataSet(DataSet theData) {
        return this.tagIsSet ? (Number)theData.getDataAsNumber(this.tag) : (Number)theData.getDataAsNumber(this.key);
    }
}

