/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree;

import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.TariffStructureVisitor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class TariffStructureNodeExtension<T>
implements InvocationHandler {
    private Class<T> myIfaceClass;
    private TariffStructureNode myTarget;
    private T myProxy;

    protected TariffStructureNodeExtension(Class<T> interfaceClass, TariffStructureNode target) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException(interfaceClass.getName() + " is not an interface.");
        }
        if (!interfaceClass.isInstance(this)) {
            throw new IllegalArgumentException(this.getClass().getName() + " must implement the interface " + interfaceClass.getName());
        }
        if (target == null) {
            throw new IllegalArgumentException("The target element cannot be null.");
        }
        this.myIfaceClass = interfaceClass;
        this.myTarget = target;
    }

    protected static <T> TariffStructureNode createExtension(TariffStructureNode element, TariffStructureNodeExtension<T> handler, Class<T> interfaceClass) {
        HashSet interfaceSet = new HashSet();
        TariffStructureNodeExtension.findAllInterfaces(element.getClass(), interfaceSet);
        interfaceSet.add(interfaceClass);
        TariffStructureNodeExtension.reduceInterfaces(interfaceSet);
        Class[] interfaces = interfaceSet.toArray(new Class[interfaceSet.size()]);
        TariffStructureNode proxy = (TariffStructureNode)Proxy.newProxyInstance(EreClassLoader.getClassLoader(), interfaces, handler);
        handler.myProxy = proxy;
        return proxy;
    }

    private static void reduceInterfaces(Set<Class<?>> interfaceSet) {
        ArrayList classes = new ArrayList(interfaceSet.size());
        for (Class clazz : interfaceSet) {
            Iterator it = classes.iterator();
            boolean doAdd = true;
            while (it.hasNext()) {
                Class c = (Class)it.next();
                if (c.isAssignableFrom(clazz)) {
                    it.remove();
                    continue;
                }
                if (!clazz.isAssignableFrom(c)) continue;
                doAdd = false;
                break;
            }
            if (!doAdd) continue;
            classes.add(clazz);
        }
        interfaceSet.retainAll(classes);
    }

    private static void findAllInterfaces(Class<?> class1, Set<Class<?>> interfaces) {
        if (class1.isInterface()) {
            interfaces.add(class1);
        }
        for (Class<?> iface : class1.getInterfaces()) {
            interfaces.add(iface);
        }
        Class<?> sclass = class1.getSuperclass();
        if (sclass != Object.class) {
            TariffStructureNodeExtension.findAllInterfaces(sclass, interfaces);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        Class<T> declaringClass = method.getDeclaringClass();
        if (this.isStartVisitMethod(declaringClass, methodName = method.getName())) {
            TariffStructureVisitor visitor = (TariffStructureVisitor)args[0];
            return this.startVisit((TariffStructureNode)proxy, visitor);
        }
        if (this.isEndVisitMethod(declaringClass, methodName)) {
            TariffStructureVisitor visitor = (TariffStructureVisitor)args[0];
            return this.endVisit((TariffStructureNode)proxy, visitor);
        }
        if (this.isGetNodeIdMethod(declaringClass, methodName, args)) {
            return this.myTarget.getNodeId();
        }
        if (this.isGetParentMethod(declaringClass, methodName, args)) {
            return this.myTarget.getParent();
        }
        if (declaringClass == this.myIfaceClass || declaringClass != Object.class && declaringClass.isAssignableFrom(this.myIfaceClass)) {
            return this.invokeWithInvocationTargetExceptionCatching(method, this, args);
        }
        if (this.isObjectEquals(declaringClass, methodName) && args.length == 1 && this.isProxyWithCompatibleHandler(args[0])) {
            Object[] newArgs = new Object[]{((TariffStructureNodeExtension)Proxy.getInvocationHandler((Object)args[0])).myTarget};
            args = newArgs;
        }
        return this.invokeImpl(proxy, method, args);
    }

    private boolean isEndVisitMethod(Class<?> declaringClass, String methodName) {
        return declaringClass == TariffStructureNode.class && "endVisit".equals(methodName);
    }

    private boolean isStartVisitMethod(Class<?> declaringClass, String methodName) {
        return declaringClass == TariffStructureNode.class && "startVisit".equals(methodName);
    }

    private boolean isGetParentMethod(Class<?> declaringClass, String methodName, Object[] args) {
        return declaringClass == DAGNode.class && "getParent".equals(methodName) && args == null;
    }

    private boolean isGetNodeIdMethod(Class<?> declaringClass, String methodName, Object[] args) {
        return (declaringClass == TariffStructureNode.class || declaringClass == ExecutableNode.class) && "getNodeId".equals(methodName) && args == null;
    }

    private boolean isObjectEquals(Class<?> declaringClass, String methodName) {
        return declaringClass == Object.class && "equals".equals(methodName);
    }

    private boolean isProxyWithCompatibleHandler(Object obj) {
        return obj instanceof Proxy && Proxy.getInvocationHandler(obj).getClass() == this.getClass();
    }

    private Void endVisit(TariffStructureNode proxy, TariffStructureVisitor visitor) throws Exception {
        switch (proxy.getNodeType()) {
            case 0: {
                visitor.leaveTariffStructure(proxy);
                break;
            }
            case 1: {
                visitor.leaveNode(proxy);
                break;
            }
            case 2: {
                visitor.leaveCondition(proxy);
                break;
            }
            case 3: {
                visitor.leaveModifier(proxy);
                break;
            }
            default: {
                throw new AssertionError(proxy.getNodeType());
            }
        }
        return null;
    }

    private Void startVisit(TariffStructureNode proxy, TariffStructureVisitor visitor) throws Exception {
        switch (proxy.getNodeType()) {
            case 0: {
                visitor.enterTariffStructure(proxy);
                break;
            }
            case 1: {
                visitor.enterNode(proxy);
                break;
            }
            case 2: {
                visitor.enterCondition(proxy);
                break;
            }
            case 3: {
                visitor.enterModifier(proxy);
                break;
            }
            default: {
                throw new AssertionError(proxy.getNodeType());
            }
        }
        return null;
    }

    protected TariffStructureNode getTarget() {
        return this.myTarget;
    }

    protected T getThis() {
        return this.myProxy;
    }

    protected Object invokeImpl(Object proxy, Method method, Object[] args) throws Throwable {
        return this.invokeWithInvocationTargetExceptionCatching(method, this.myTarget, args);
    }

    private Object invokeWithInvocationTargetExceptionCatching(Method method, Object target, Object[] args) throws Throwable {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

