/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree;

import com.ericsson.ere.selectiontree.SelectionTreeBuilder;
import com.ericsson.ere.selectiontree.interfaces.SelectionTreeNodeFactory;
import com.ericsson.ere.selectiontree.statements.AbstractNodeStatement;
import ericsson.ere.interfaces.RatingRuleBuilderErrorHandler;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.xml.XMLUtil;
import java.io.InputStream;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class StreamBasedSelectionTreeBuilder {
    private static final Logger log = Logger.getLogger(StreamBasedSelectionTreeBuilder.class.getName());
    private static final TariffStructureNode[] EMPTY_CHILDREN = new TariffStructureNode[0];
    private static final String TAG_CONDITIONS = "Conditions";
    private static final String TAG_LEAF = "Leaf";
    private static final String TAG_SUBNODES = "SubNodes";
    private SelectionTreeNodeFactory myNodeFactory;
    private RatingRuleBuilderErrorHandler myErrorHandler;
    private static SAXParserFactory mySAXParserFactory;
    private static ThreadLocal<SAXParser> myTLSAXParser;

    public StreamBasedSelectionTreeBuilder(SelectionTreeNodeFactory fact, RatingRuleBuilderErrorHandler err) {
        this.myNodeFactory = fact;
        this.myErrorHandler = err;
    }

    public TariffStructureNode build(InputStream stream, ProgressIndicator progress) throws Exception {
        return this.build(new InputSource(stream), progress);
    }

    public TariffStructureNode build(Reader reader, ProgressIndicator progress) throws Exception {
        return this.build(new InputSource(reader), progress);
    }

    private TariffStructureNode build(InputSource source, ProgressIndicator progress) throws Exception {
        TariffStructureNode ret;
        ProgressIndicator[] pis = progress == null ? null : progress.splitProgress(new int[]{60, 20, 20});
        SAXParser parser = this.getParser();
        if (pis != null) {
            pis[0].setInfo("Building selection tree...");
            pis[0].progressStart();
        }
        CustomHandler handler = new CustomHandler(XMLUtil.createEmptyDocument(), this.myErrorHandler, this.myNodeFactory);
        try {
            parser.parse(source, (DefaultHandler)handler);
        }
        catch (BuildFinishedException buildFinishedException) {
        }
        catch (BuildInterruptedException ex) {
            throw new InterruptedException("Build interrupted.");
        }
        TariffStructureNode tn = handler.getResult();
        List<TariffStructureNode> linkNodes = handler.getLinkNodes();
        this.detachHandlerFromParser(parser);
        if (pis != null) {
            pis[0].progressFinished();
            pis[1].setInfo("Resolving links...");
            pis[1].progressStart();
        }
        if (tn != null && tn.getChildCount() > 0 && !linkNodes.isEmpty()) {
            SelectionTreeBuilder.resolveLinks(tn, linkNodes);
        }
        if (pis != null) {
            pis[1].progressFinished();
            pis[2].setInfo("Finalizing tree structure...");
            pis[2].progressStart();
        }
        TariffStructureNode tariffStructureNode = ret = tn != null ? this.myNodeFactory.finish(tn) : tn;
        if (pis != null) {
            pis[2].progressFinished();
        }
        return ret;
    }

    private void detachHandlerFromParser(SAXParser parser) throws SAXException {
        XMLReader reader = parser.getXMLReader();
        reader.setContentHandler(null);
        reader.setEntityResolver(null);
        reader.setErrorHandler(null);
        reader.setDTDHandler(null);
    }

    protected SAXParser getParser() throws ParserConfigurationException, SAXException {
        SAXParser parser = myTLSAXParser.get();
        if (parser == null) {
            parser = mySAXParserFactory.newSAXParser();
            myTLSAXParser.set(parser);
        } else {
            parser.reset();
        }
        return parser;
    }

    static {
        myTLSAXParser = new ThreadLocal();
        mySAXParserFactory = SAXParserFactory.newInstance();
    }

    private static class BuildInterruptedException
    extends SAXException {
        BuildInterruptedException() {
        }
    }

    private static class BuildFinishedException
    extends SAXException {
        BuildFinishedException() {
        }
    }

    private static class NodeData {
        TariffStructureNode node;
        int level;

        NodeData(TariffStructureNode node, int level) {
            this.node = node;
            this.level = level;
        }
    }

    private static class CustomHandler
    extends DefaultHandler {
        private static final int INITIAL_CHAR_BUF_SIZE = 16384;
        private Document myDocument;
        private Stack<Node> myNodeStack;
        private int myLevel;
        private List<NodeData> myCreatedNodes;
        private List<TariffStructureNode> myLinkNodes;
        private Element myStructureConfig;
        private CharBuffer myBuffer;
        private Locator myLocator;
        private RatingRuleBuilderErrorHandler myErrorHandler;
        private SelectionTreeNodeFactory myNodeFactory;

        CustomHandler(Document doc, RatingRuleBuilderErrorHandler errorHandler, SelectionTreeNodeFactory nodeFactory) {
            this.myDocument = doc;
            this.myErrorHandler = errorHandler;
            this.myNodeFactory = nodeFactory;
            this.myBuffer = CharBuffer.allocate(16384);
        }

        TariffStructureNode getResult() {
            if (this.myCreatedNodes.isEmpty()) {
                IllegalStateException e = new IllegalStateException("No <TariffStructure> tag was found.");
                this.myErrorHandler.handleError(e, null, "", e.toString());
                return null;
            }
            if (this.myCreatedNodes.size() != 1) {
                IllegalStateException e = new IllegalStateException("Failed to build the entire tree structure (unbalanced structure).");
                this.myErrorHandler.handleError(e, null, "", e.toString());
            }
            return this.myCreatedNodes.remove((int)0).node;
        }

        List<TariffStructureNode> getLinkNodes() {
            return this.myLinkNodes;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.myLocator = locator;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.myErrorHandler.handleError(e, null, "", "SAX error on line " + e.getLineNumber());
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.myErrorHandler.handleError(e, null, "", "Fatal SAX error on line " + e.getLineNumber());
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("Parse warning: " + e.getMessage());
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.myLevel = -1;
            this.myNodeStack = new Stack();
            this.myCreatedNodes = new ArrayList<NodeData>(500);
            this.myLinkNodes = new ArrayList<TariffStructureNode>(1000);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.myLevel < 0) {
                return;
            }
            boolean isEmpty = this.myBuffer.position() == 0;
            int nonWS = this.indexOfNonWS(ch, start, length);
            if (isEmpty && nonWS < 0) {
                return;
            }
            int newStart = start;
            int newLen = length;
            if (isEmpty) {
                newStart += nonWS;
                newLen -= nonWS;
            }
            if (this.myBuffer.remaining() < newLen) {
                this.growBuffer(length);
            }
            this.myBuffer.put(ch, newStart, newLen);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.myLevel < 0) {
                return;
            }
            assert (!this.myNodeStack.isEmpty()) : "Found XML end tag without start tag - SAX parser failure?";
            this.commitCharData();
            if (this.isSkipOverElement(qName)) {
                return;
            }
            Node current = this.myNodeStack.pop();
            assert (qName.equals(current.getNodeName())) : "XML end tag doesn't match start tag - SAX parser failure?";
            boolean finished = false;
            if (this.isTreeElement(qName)) {
                try {
                    TariffStructureNode tn = this.build(qName, current);
                    NodeData data = new NodeData(tn, this.myLevel);
                    this.myCreatedNodes.add(data);
                    if (tn.isLink()) {
                        this.myLinkNodes.add(tn);
                    }
                }
                catch (Exception ex) {
                    this.myErrorHandler.handleError(ex, current, "", "Build failure on line " + this.myLocator.getLineNumber());
                }
                finished = this.isStructure(qName);
            } else {
                Node parent = this.myNodeStack.peek();
                parent.appendChild(current);
            }
            --this.myLevel;
            if (finished) {
                throw new BuildFinishedException();
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (Thread.interrupted()) {
                throw new BuildInterruptedException();
            }
            boolean isStructure = this.isStructure(qName);
            if (this.myLevel >= 0 || isStructure) {
                ++this.myLevel;
            }
            if (this.myLevel < 0) {
                return;
            }
            this.commitCharData();
            if (this.isSkipOverElement(qName)) {
                --this.myLevel;
                return;
            }
            boolean isTreeElement = this.isTreeElement(qName);
            Element elem = this.myDocument.createElement(qName);
            int attrLen = attributes.getLength();
            for (int i = 0; i < attrLen; ++i) {
                String attrName = attributes.getQName(i);
                String attrValue = attributes.getValue(i);
                elem.setAttribute(attrName, attrValue);
            }
            if (isStructure) {
                this.myStructureConfig = elem;
            } else if (isTreeElement && this.myStructureConfig != null) {
                this.myNodeFactory.prepare(this.myStructureConfig);
                this.myStructureConfig = null;
            }
            this.myNodeStack.push(elem);
        }

        private TariffStructureNode build(String name, Node current) throws Exception {
            TariffStructureNode tn;
            if (this.isModifier(name)) {
                tn = this.myNodeFactory.createModifier(current, this.getChildren());
            } else if (this.isCondition(name)) {
                tn = this.myNodeFactory.createCondition(current, this.getChildren());
            } else if (this.isNode(name)) {
                tn = this.myNodeFactory.createNode(current, this.getChildren());
                if (tn instanceof AbstractNodeStatement) {
                    ((AbstractNodeStatement)tn).buildFinished();
                }
            } else if (this.isStructure(name)) {
                tn = this.myNodeFactory.createTariffStructure(current, this.getChildren());
            } else {
                throw new AssertionError((Object)("Unexpected node name in build: " + name));
            }
            return tn;
        }

        private TariffStructureNode[] getChildren() {
            int minLevel = this.myLevel + 1;
            int i = this.myCreatedNodes.size();
            int count = 0;
            while (--i >= 0) {
                NodeData data = this.myCreatedNodes.get(i);
                if (data.level < minLevel) break;
                ++count;
            }
            if (count == 0) {
                return EMPTY_CHILDREN;
            }
            TariffStructureNode[] children = new TariffStructureNode[count];
            i = this.myCreatedNodes.size();
            while (count-- > 0) {
                NodeData removed = this.myCreatedNodes.remove(--i);
                children[count] = removed.node;
            }
            return children;
        }

        private void growBuffer(int length) {
            int minSize;
            int newCap = 2 * (this.myBuffer.capacity() + 1);
            if (newCap < (minSize = this.myBuffer.position() + length)) {
                newCap = minSize;
            }
            CharBuffer buf = CharBuffer.allocate(newCap);
            this.myBuffer.flip();
            buf.put(this.myBuffer);
            this.myBuffer = buf;
        }

        private void commitCharData() {
            if (this.myBuffer.position() > 0) {
                if (!this.myNodeStack.isEmpty()) {
                    String str = this.bufferToString();
                    Node current = this.myNodeStack.peek();
                    Text txt = this.myDocument.createTextNode(str);
                    current.appendChild(txt);
                }
                this.myBuffer.clear();
            }
        }

        private String bufferToString() {
            char[] data = this.myBuffer.array();
            int len = this.myBuffer.position();
            while (data[len - 1] <= ' ') {
                --len;
            }
            return new String(data, 0, len);
        }

        private int indexOfNonWS(char[] ch, int offset, int length) {
            int idx = -1;
            for (int i = 0; i < length; ++i) {
                if (ch[offset + i] <= ' ') continue;
                idx = i;
                break;
            }
            return idx;
        }

        private boolean isModifier(String name) {
            return "Modifier".equals(name) || "Action".equals(name) || "Tariff".equals(name);
        }

        private boolean isCondition(String name) {
            return "Condition".equals(name);
        }

        private boolean isNode(String name) {
            return "Node".equals(name);
        }

        private boolean isStructure(String name) {
            return "TariffStructure".equals(name);
        }

        private boolean isTreeElement(String name) {
            if (!this.isTreeElement0(name)) {
                return false;
            }
            if (this.isStructure(name)) {
                return true;
            }
            if (this.myNodeStack.isEmpty()) {
                return false;
            }
            String stackName = this.myNodeStack.peek().getNodeName();
            return this.isTreeElement0(stackName);
        }

        private boolean isTreeElement0(String name) {
            return this.isCondition(name) || this.isNode(name) || this.isModifier(name) || this.isStructure(name);
        }

        private boolean isSkipOverElement(String name) {
            return StreamBasedSelectionTreeBuilder.TAG_CONDITIONS.equals(name) || StreamBasedSelectionTreeBuilder.TAG_LEAF.equals(name) || StreamBasedSelectionTreeBuilder.TAG_SUBNODES.equals(name);
        }
    }
}

