/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree;

import com.ericsson.ere.selectiontree.interfaces.SelectionTreeNodeFactory;
import com.ericsson.ere.selectiontree.statements.AbstractNodeStatement;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.RatingRuleBuilderErrorHandler;
import ericsson.ere.interfaces.TariffNodeLink;
import ericsson.ere.interfaces.TariffStructureConstants;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.ratingrules.CycleDetectedException;
import ericsson.ere.ratingrules.FatalParsingError;
import ericsson.ere.ratingrules.LinkHandler;
import ericsson.ere.ratingrules.UnresolvableLinkException;
import ericsson.ere.xml.NodeListWrapper;
import ericsson.ere.xml.XMLUtil;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectionTreeBuilder
implements TariffStructureConstants {
    public static final TariffStructureNode[] EMPTY_ARRAY = new TariffStructureNode[0];
    public static final String TAG_CONDITIONS = "Conditions";
    public static final String TAG_LEAF = "Leaf";
    public static final String TAG_SUBNODES = "SubNodes";
    private final SelectionTreeNodeFactory myNodeFactory;
    private final RatingRuleBuilderErrorHandler myErrorHandler;
    private List<TariffStructureNode> myLinkNodes = new ArrayList<TariffStructureNode>();
    private static final String[] CONDITION_TAGS = new String[]{"Condition"};
    private static final String[] MODIFIER_TAGS = new String[]{"Tariff", "Action", "Modifier"};

    public SelectionTreeBuilder(SelectionTreeNodeFactory fact, RatingRuleBuilderErrorHandler err) {
        this.myNodeFactory = fact;
        this.myErrorHandler = err;
    }

    public TariffStructureNode buildFromFile(File file, ProgressIndicator progress) throws Exception {
        if (progress != null) {
            progress.progressStart(2);
            progress.setInfo("Parsing XML");
        }
        Document doc = XMLUtil.buildDocumentFromFile(file);
        if (progress != null) {
            progress.progressIncrement();
        }
        TariffStructureNode result = this.build(doc, progress);
        if (progress != null) {
            progress.progressIncrement();
        }
        return result;
    }

    public TariffStructureNode buildFromElement(Element tariffXML, ProgressIndicator progress) throws Exception {
        if (progress != null) {
            progress.progressStart(1);
            progress.setInfo("Parsing XML");
        }
        TariffStructureNode result = this.build(tariffXML, progress);
        if (progress != null) {
            progress.progressIncrement();
        }
        return result;
    }

    public TariffStructureNode buildFromString(String s, ProgressIndicator progress) throws Exception {
        if (progress != null) {
            progress.progressStart(2);
            progress.setInfo("Parsing XML");
        }
        Document doc = XMLUtil.buildDocumentFromString(s);
        if (progress != null) {
            progress.progressIncrement();
        }
        TariffStructureNode result = this.build(doc, progress);
        if (progress != null) {
            progress.progressIncrement();
        }
        return result;
    }

    public TariffStructureNode build(InputStream in) throws Exception {
        Document doc = XMLUtil.buildDocument(in);
        return this.build(doc);
    }

    public TariffStructureNode build(Reader in) throws Exception {
        Document doc = XMLUtil.buildDocument(in);
        return this.build(doc);
    }

    public TariffStructureNode build(Document doc) throws Exception {
        return this.build(doc, null);
    }

    public TariffStructureNode build(Document doc, ProgressIndicator progress) throws Exception {
        NodeList structure = doc.getElementsByTagName("TariffStructure");
        if (structure != null && structure.getLength() == 1) {
            Node ts = structure.item(0);
            return this.build(ts.getNodeName(), NodeListWrapper.wrapNode(ts), progress);
        }
        return this.build(doc.getDocumentElement().getNodeName(), doc.getChildNodes(), progress);
    }

    public TariffStructureNode build(Element element, ProgressIndicator progress) throws Exception {
        return this.build(element.getNodeName(), NodeListWrapper.wrapNode(element), progress);
    }

    public TariffStructureNode build(String nodeName, NodeList children, ProgressIndicator progress) throws Exception {
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            if ("TariffStructure".equals(name)) {
                return this.buildTariffStructure(node, progress);
            }
            if ("Node".equals(name)) {
                return this.buildNode(node);
            }
            if ("Condition".equals(name)) {
                return this.buildCondition(node);
            }
            if (TAG_LEAF.equals(name)) {
                return this.buildLeaf(node);
            }
            if (!"Tariff".equals(name) && !"Modifier".equals(name) && !"Action".equals(name)) continue;
            return this.buildTariff(node);
        }
        throw new FatalParsingError("Not a Rating Rule Tree structure, failed to parse element with name '" + nodeName + "'");
    }

    public TariffStructureNode build(Node node) throws Exception {
        return this.build(node, null);
    }

    public TariffStructureNode build(Node node, ProgressIndicator progress) throws Exception {
        String name;
        if (node.getNodeType() == 1 && "TariffStructure".equals(name = node.getNodeName())) {
            return this.buildTariffStructure(node, progress);
        }
        throw new FatalParsingError("Not a Selection Tree structure, failed to parse element with name '" + node.getNodeName() + "'");
    }

    private TariffStructureNode buildTariffStructure(Node iterator, ProgressIndicator progress) throws CycleDetectedException, Exception {
        this.checkForInterruption();
        TariffStructureNode tariffStructureNode = null;
        this.myNodeFactory.prepare(iterator);
        this.myLinkNodes.clear();
        try {
            NodeList childNodes = iterator.getChildNodes();
            ArrayList<TariffStructureNode> children = new ArrayList<TariffStructureNode>(childNodes.getLength());
            if (progress != null) {
                progress.setInfo("Parsing Selection Tree...");
                progress.progressStart(childNodes.getLength());
            }
            int len = childNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() == 1) {
                    String name = child.getNodeName();
                    if (TAG_SUBNODES.equals(name)) {
                        List<TariffStructureNode> nodes = this.buildSubNodes(child);
                        children.addAll(nodes);
                    } else if ("Node".equals(name)) {
                        TariffStructureNode childnode = this.buildNode(child);
                        children.add(childnode);
                    }
                }
                if (progress == null || progress.getProgressGoal() >= childNodes.getLength()) continue;
                progress.progressIncrement(1);
            }
            tariffStructureNode = this.myNodeFactory.createTariffStructure(iterator, children.toArray(EMPTY_ARRAY));
            if (tariffStructureNode.getChildCount() > 0 && this.myLinkNodes.size() > 0) {
                SelectionTreeBuilder.resolveLinks(tariffStructureNode, this.myLinkNodes);
            }
            tariffStructureNode = this.myNodeFactory.finish(tariffStructureNode);
        }
        catch (FatalParsingError e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e, iterator, "buildTariffStructure");
            tariffStructureNode = null;
        }
        return tariffStructureNode;
    }

    static void resolveLinks(TariffStructureNode tariffStructureNode, List<TariffStructureNode> linkNodes) throws Exception {
        SelectionTreeBuilder.privResolveLinks(tariffStructureNode, linkNodes);
        SelectionTreeBuilder.detectCycles(linkNodes);
    }

    private static void detectCycles(List<TariffStructureNode> linkNodes) {
        HashSet<String> checkedPaths = new HashSet<String>();
        DAGNode[] nodes = null;
        for (TariffStructureNode linkNode : linkNodes) {
            String path = ((TariffNodeLink)((Object)linkNode)).getLinkPath();
            if (!checkedPaths.add(path) || (nodes = DAGUtil.findCycle(linkNode)) == null) continue;
            throw new CycleDetectedException("Illegal tariff, detected cycle at path:", nodes);
        }
    }

    private static void privResolveLinks(TariffStructureNode tariffStructureNode, List<TariffStructureNode> linkNodes) throws Exception {
        LinkHandler linkHandler = new LinkHandler(tariffStructureNode);
        int maxLoops = 10;
        int resolved = 0;
        int max = linkNodes.size();
        List<TariffStructureNode> links = linkNodes;
        int offset = 0;
        while (resolved < max && maxLoops-- >= 0) {
            int res = SelectionTreeBuilder.resolveLinksOnePass(links, linkHandler, offset);
            if (res <= 0 || (resolved += res) >= max) continue;
            offset = resolved;
        }
        if (resolved < max) {
            throw new UnresolvableLinkException("Could not resolve link or links.");
        }
    }

    private static int resolveLinksOnePass(List<TariffStructureNode> linkNodes, LinkHandler linkHandler, int offset) throws Exception {
        int len = linkNodes.size();
        int resolved = 0;
        int swap = len - 1;
        int cursor = offset;
        while (cursor < len) {
            TariffStructureNode linkNode = linkNodes.get(cursor);
            try {
                linkHandler.resolveLink(linkNode);
                ++resolved;
                ++cursor;
            }
            catch (UnresolvableLinkException e) {
                if (cursor == swap) break;
                TariffStructureNode temp = linkNodes.get(swap);
                linkNodes.set(swap, linkNode);
                linkNodes.set(cursor, temp);
                --swap;
            }
        }
        return resolved;
    }

    protected void handleException(Exception e, Node config, String method) throws Exception {
        if (e instanceof InterruptedException) {
            throw e;
        }
        this.myErrorHandler.handleError(e, config, method, e.toString());
    }

    private void checkForInterruption() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException("Interrupted while building selection tree.");
        }
    }

    private TariffStructureNode buildNode(Node iterator) throws Exception {
        this.checkForInterruption();
        TariffStructureNode node = null;
        try {
            NodeList childNodes = iterator.getChildNodes();
            int len = childNodes.getLength();
            ArrayList<TariffStructureNode> children = new ArrayList<TariffStructureNode>(len);
            for (int i = 0; i < len; ++i) {
                TariffStructureNode childnode;
                List<TariffStructureNode> nodes;
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1) continue;
                String name = child.getNodeName();
                if (TAG_CONDITIONS.equals(name)) {
                    nodes = this.buildConditions(child);
                    children.addAll(nodes);
                    continue;
                }
                if ("Condition".equals(name)) {
                    childnode = this.buildCondition(child);
                    children.add(childnode);
                    continue;
                }
                if (TAG_SUBNODES.equals(name)) {
                    nodes = this.buildSubNodes(child);
                    children.addAll(nodes);
                    continue;
                }
                if ("Node".equals(name)) {
                    childnode = this.buildNode(child);
                    children.add(childnode);
                    continue;
                }
                if (TAG_LEAF.equals(name)) {
                    childnode = this.buildLeaf(child);
                    children.add(childnode);
                    continue;
                }
                if (!"Tariff".equals(name) && !"Modifier".equals(name) && !"Action".equals(name)) continue;
                childnode = this.buildTariff(child);
                children.add(childnode);
            }
            node = this.myNodeFactory.createNode(iterator, children.toArray(EMPTY_ARRAY));
            if (node.isLink()) {
                this.myLinkNodes.add(node);
            }
            if (node instanceof AbstractNodeStatement) {
                ((AbstractNodeStatement)node).buildFinished();
            }
        }
        catch (FatalParsingError e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e, iterator, "buildNode");
            node = null;
        }
        return node;
    }

    private List<TariffStructureNode> buildSubNodes(Node iterator) throws Exception {
        this.checkForInterruption();
        ArrayList<TariffStructureNode> l = null;
        try {
            NodeList children = iterator.getChildNodes();
            int len = children.getLength();
            l = new ArrayList<TariffStructureNode>(len);
            for (int i = 0; i < len; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                if ("Node".equals(child.getNodeName())) {
                    TariffStructureNode node = this.buildNode(child);
                    l.add(node);
                    continue;
                }
                if (!TAG_LEAF.equals(child.getNodeName())) continue;
                TariffStructureNode mod = this.buildLeaf(child);
                l.add(mod);
            }
        }
        catch (FatalParsingError e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e, iterator, "buildSubNodes");
            l = null;
        }
        return l;
    }

    private List<TariffStructureNode> buildConditions(Node iterator) throws Exception {
        this.checkForInterruption();
        ArrayList<TariffStructureNode> l = null;
        try {
            NodeList children = iterator.getChildNodes();
            int len = children.getLength();
            l = new ArrayList<TariffStructureNode>(len);
            for (int i = 0; i < len; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !"Condition".equals(child.getNodeName())) continue;
                TariffStructureNode cond = this.buildCondition(child);
                l.add(cond);
            }
        }
        catch (FatalParsingError e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e, iterator, "buildConditions");
            l = null;
        }
        return l;
    }

    private int countTags(NodeList childNodes, String[] tags) {
        int val = 0;
        int len = childNodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            for (String t : tags) {
                if (!t.equals(child.getNodeName())) continue;
                ++val;
            }
        }
        return val;
    }

    private TariffStructureNode buildCondition(Node iterator) throws Exception {
        this.checkForInterruption();
        TariffStructureNode cond = null;
        try {
            NodeList childNodes = iterator.getChildNodes();
            int ncond = this.countTags(childNodes, CONDITION_TAGS);
            ArrayList<TariffStructureNode> children = ncond == 0 ? null : new ArrayList<TariffStructureNode>(ncond);
            int len = childNodes.getLength();
            for (int i = 0; i < len; ++i) {
                String name;
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1 || !"Condition".equals(name = child.getNodeName())) continue;
                TariffStructureNode childCond = this.buildCondition(child);
                children.add(childCond);
            }
            TariffStructureNode[] array = children == null ? EMPTY_ARRAY : children.toArray(EMPTY_ARRAY);
            cond = this.myNodeFactory.createCondition(iterator, array);
            if (cond.isLink()) {
                this.myLinkNodes.add(cond);
            }
        }
        catch (FatalParsingError e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e, iterator, "buildCondition");
            cond = null;
        }
        return cond;
    }

    private TariffStructureNode buildLeaf(Node iterator) throws Exception {
        this.checkForInterruption();
        TariffStructureNode mod = null;
        try {
            String name;
            Node child;
            NodeList children = iterator.getChildNodes();
            int len = children.getLength();
            for (int i = 0; !(i >= len || (child = children.item(i)).getNodeType() == 1 && ("Tariff".equals(name = child.getNodeName()) || "Modifier".equals(name) || "Action".equals(name)) && (mod = this.buildTariff(child)) != null); ++i) {
            }
        }
        catch (FatalParsingError e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e, iterator, "buildLeaf");
            mod = null;
        }
        return mod;
    }

    private TariffStructureNode buildTariff(Node iterator) throws Exception {
        this.checkForInterruption();
        TariffStructureNode mod = null;
        try {
            NodeList childNodes = iterator.getChildNodes();
            int nmod = this.countTags(childNodes, MODIFIER_TAGS);
            ArrayList<TariffStructureNode> children = nmod == 0 ? null : new ArrayList<TariffStructureNode>(nmod);
            int len = childNodes.getLength();
            for (int i = 0; i < len; ++i) {
                String name;
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1 || !"Tariff".equals(name = child.getNodeName()) && !"Modifier".equals(name) && !"Action".equals(name)) continue;
                TariffStructureNode childMod = this.buildTariff(child);
                children.add(childMod);
            }
            TariffStructureNode[] array = children == null ? EMPTY_ARRAY : children.toArray(EMPTY_ARRAY);
            mod = this.myNodeFactory.createModifier(iterator, array);
            if (mod.isLink()) {
                this.myLinkNodes.add(mod);
            }
        }
        catch (FatalParsingError e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e, iterator, "buildTariff");
            mod = null;
        }
        return mod;
    }
}

