/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree;

import com.ericsson.ere.selectiontree.ProgressiveTariffStructureNodeCache;
import com.ericsson.ere.selectiontree.SelectionTreeNodeFactoryImpl;
import com.ericsson.ere.selectiontree.TariffStructureNodeCache;
import com.ericsson.ere.selectiontree.WrappingSelectionTreeNodeFactory;
import com.ericsson.ere.selectiontree.interfaces.SelectionTreeNodeFactory;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.interfaces.TariffStructureNode;
import org.w3c.dom.Node;

public class ProgressiveCacheSelectionTreeNodeFactory
extends WrappingSelectionTreeNodeFactory {
    private ProgressiveTariffStructureNodeCache myProgressiveCache;

    public ProgressiveCacheSelectionTreeNodeFactory(ClassRepository repository, SelectionTreeNodeFactory delegate) {
        super(delegate);
        TariffStructureNodeCache cache = SelectionTreeNodeFactoryImpl.createCache(repository);
        if (cache instanceof ProgressiveTariffStructureNodeCache) {
            this.myProgressiveCache = (ProgressiveTariffStructureNodeCache)cache;
        }
    }

    @Override
    protected TariffStructureNode createWrapper(TariffStructureNode tn, Node config) {
        if (this.myProgressiveCache != null) {
            return this.myProgressiveCache.optimizeSingle(tn);
        }
        return tn;
    }

    @Override
    protected void updateParentOfChildren(TariffStructureNode tn) {
        tn.setParent(null);
        int len = tn.getChildCount();
        for (int i = 0; i < len; ++i) {
            tn.getChildAt(i).setParent(null);
        }
    }

    @Override
    public TariffStructureNode finish(TariffStructureNode structure) {
        if (this.myProgressiveCache != null) {
            return this.myProgressiveCache.optimize(structure);
        }
        return super.finish(structure);
    }
}

