/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree;

import com.ericsson.ere.annotations.IdentityBasedEquality;
import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.mbean.TariffStructureNodeCacheInfo;
import com.ericsson.ere.mbean.TariffStructureNodeCacheInfoMBean;
import com.ericsson.ere.selectiontree.ProgressiveTariffStructureNodeCache;
import com.ericsson.ere.selectiontree.TariffStructureNodeCache;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.XMLInitializable;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GlobalNodeCache
implements ProgressiveTariffStructureNodeCache,
TariffStructureNodeCache,
XMLInitializable {
    private static final AtomicIntegerFieldUpdater<CacheData> ourReferenceCountFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(CacheData.class, "refcount");
    private static final AtomicInteger CEILING = new AtomicInteger(Integer.MAX_VALUE);
    private static final int CAPACITY = new BigInteger("60000").nextProbablePrime().intValue();
    private static final Map<TariffStructureNode, CacheData> CACHE = Collections.synchronizedMap(new WeakHashMap(CAPACITY));
    private static final Map<DAGNode, Integer> cleanedNodes = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<TariffStructureNode, Integer> countedNodes = Collections.synchronizedMap(new WeakHashMap());
    private static final Comparator<CacheData> DESCENDING_REFCOUNT_COMPARATOR;
    private static final Comparator<Integer> INT_COMPARATOR;

    public static void limitCacheSize(int size) {
        int oldval = CEILING.get();
        if (size < oldval) {
            CEILING.compareAndSet(oldval, size);
        }
    }

    @Override
    public TariffStructureNode optimizeSingle(TariffStructureNode n) {
        TariffStructureNode cached = this.getReplacement(CACHE.get(n), n, false);
        return cached != null ? cached : n;
    }

    @Override
    public TariffStructureNode optimize(TariffStructureNode n) {
        if (CEILING.get() <= 0) {
            return n;
        }
        this.removeParentAndReferers(n);
        this.checkAndReplaceChildren(n);
        this.prune();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prune() {
        int deadWood = CACHE.size() - CEILING.get();
        if (deadWood > 0) {
            Map<TariffStructureNode, CacheData> map = CACHE;
            synchronized (map) {
                TreeSet<CacheData> surplus = new TreeSet<CacheData>(new MaxNodesOfMinReferences());
                for (CacheData data : CACHE.values()) {
                    int size = surplus.size();
                    if (size < deadWood) {
                        surplus.add(data);
                        continue;
                    }
                    CacheData last = (CacheData)surplus.last();
                    if (surplus.comparator().compare(data, last) >= 0) continue;
                    surplus.remove(last);
                    surplus.add(data);
                }
                for (CacheData data : surplus) {
                    TariffStructureNode node = (TariffStructureNode)data.node.get();
                    if (node == null) continue;
                    CACHE.remove(node);
                }
            }
        }
    }

    private void removeParentAndReferers(DAGNode n) {
        if (!cleanedNodes.containsKey(n)) {
            int len = n.getChildCount();
            for (int i = 0; i < len; ++i) {
                this.removeParentAndReferers(n.getChildAt(i));
            }
            n.setParent(null);
            n.removeAllReferers();
            cleanedNodes.put(n, 1);
        }
    }

    private int countNodes(TariffStructureNode n) {
        int sum = this.countNodes0(n);
        if (sum > 0 && n.getNodeType() == 1) {
            --sum;
        }
        return sum;
    }

    private int countNodes0(TariffStructureNode n) {
        if (countedNodes.containsKey(n)) {
            return countedNodes.get(n);
        }
        if (this.isUnresolvedLink(n)) {
            return -1;
        }
        if (!this.isImmutableCacheableElement(n) && !n.isLink()) {
            countedNodes.put(n, -2);
            return -2;
        }
        int sum = n.getNodeType() == 1 ? 1 : 0;
        int len = n.getChildCount();
        for (int i = 0; i < len; ++i) {
            TariffStructureNode child = (TariffStructureNode)n.getChildAt(i);
            int subSum = this.countNodes0(child);
            if (subSum < 0) {
                countedNodes.put(n, subSum);
                return subSum;
            }
            sum += subSum;
        }
        countedNodes.put(n, sum);
        return sum;
    }

    private boolean isUnresolvedLink(TariffStructureNode n) {
        return n.isLink() && n.getChildCount() == 0;
    }

    private boolean isImmutableCacheableElement(TariffStructureNode n) {
        Class<?> cls = n.getClass();
        return cls.isAnnotationPresent(Immutable.class) && !cls.isAnnotationPresent(IdentityBasedEquality.class);
    }

    private void checkAndReplaceChildren(TariffStructureNode n) {
        int len = n.getChildCount();
        for (int i = 0; i < len; ++i) {
            boolean continueCache;
            CacheData childCacheData;
            TariffStructureNode replacement;
            TariffStructureNode child = (TariffStructureNode)n.getChildAt(i);
            if (child != (replacement = this.getReplacement(childCacheData = CACHE.get(child), child, true)) && replacement != null) {
                n.replace(child, replacement);
                continue;
            }
            boolean bl = childCacheData != null ? childCacheData.node.get() != child : (continueCache = true);
            if (!continueCache) continue;
            this.checkAndReplaceChildren(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TariffStructureNode getReplacement(CacheData data, TariffStructureNode node, boolean addToCache) {
        int weight;
        TariffStructureNode replacement = null;
        if (data != null) {
            replacement = (TariffStructureNode)data.node.get();
        }
        if (replacement == null && addToCache && (weight = this.countNodes(node)) >= 0) {
            CacheData newVal = new CacheData(new WeakReference<TariffStructureNode>(node), 1, weight);
            Map<TariffStructureNode, CacheData> map = CACHE;
            synchronized (map) {
                CacheData old = CACHE.get(node);
                if (old == null) {
                    CACHE.put(node, newVal);
                    data = newVal;
                    replacement = node;
                } else {
                    data = old;
                    replacement = (TariffStructureNode)old.node.get();
                    if (replacement == null) {
                        CACHE.put(node, newVal);
                        data = newVal;
                        replacement = node;
                    }
                }
            }
        }
        if (node != replacement && replacement != null && data != null && addToCache) {
            ourReferenceCountFieldUpdater.incrementAndGet(data);
        }
        return replacement;
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        Node val;
        NamedNodeMap attr = iterator.getAttributes();
        if (attr != null && (val = attr.getNamedItem("limit")) != null) {
            int limit = Integer.parseInt(val.getNodeValue());
            GlobalNodeCache.limitCacheSize(limit);
        }
        return this;
    }

    @Override
    public void setClassRepository(ClassRepository rep) {
    }

    static {
        new TariffStructureNodeCacheInfo(new GlobalNodeCacheInfoBridge());
        DESCENDING_REFCOUNT_COMPARATOR = new Comparator<CacheData>(){

            @Override
            public int compare(CacheData o1, CacheData o2) {
                return -(o1.refcount - o2.refcount);
            }
        };
        INT_COMPARATOR = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (o2 == null) {
                    return o1 == null ? 0 : -1;
                }
                if (o1 == null) {
                    return 1;
                }
                return o1 - o2;
            }
        };
    }

    private static class GlobalNodeCacheInfoBridge
    implements TariffStructureNodeCacheInfoMBean {
        private static final long MAX_DATA_AGE_MS = 40L;
        private double myAverageRefCount;
        private double myAverageWeight;
        private double myMedianRefCount;
        private double myMedianWeight;
        private int myMaxRefCount;
        private int myMaxWeight;
        private int[] myNodeCounts = new int[4];
        private long myLastRefresh = -1L;
        private List<String> myMostReferredElements;

        private GlobalNodeCacheInfoBridge() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCacheSize() {
            Map map = CACHE;
            synchronized (map) {
                return CACHE.size();
            }
        }

        @Override
        public int getCacheCeiling() {
            return CEILING.get();
        }

        @Override
        public double getAverageReferenceCount() {
            this.ensureDataUpdated();
            return this.myAverageRefCount;
        }

        @Override
        public double getAverageWeight() {
            this.ensureDataUpdated();
            return this.myAverageWeight;
        }

        @Override
        public int getMaximumReferenceCount() {
            this.ensureDataUpdated();
            return this.myMaxRefCount;
        }

        @Override
        public int getMaximumWeight() {
            this.ensureDataUpdated();
            return this.myMaxWeight;
        }

        @Override
        public double getMedianReferenceCount() {
            this.ensureDataUpdated();
            return this.myMedianRefCount;
        }

        @Override
        public double getMedianWeight() {
            this.ensureDataUpdated();
            return this.myMedianWeight;
        }

        @Override
        public int getReusedConditionCount() {
            this.ensureDataUpdated();
            return this.myNodeCounts[2];
        }

        @Override
        public int getReusedModifierCount() {
            this.ensureDataUpdated();
            return this.myNodeCounts[3];
        }

        @Override
        public int getReusedNodeCount() {
            this.ensureDataUpdated();
            return this.myNodeCounts[1];
        }

        @Override
        public List<String> getMostReusedElements() {
            this.ensureDataUpdated();
            return Collections.unmodifiableList(this.myMostReferredElements);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void ensureDataUpdated() {
            long now = System.currentTimeMillis();
            if (now - this.myLastRefresh > 40L) {
                Map map = CACHE;
                synchronized (map) {
                    this.updateData();
                }
                this.myLastRefresh = now;
            }
        }

        private void updateData() {
            Collection values = CACHE.values();
            Integer[] refCounts = new Integer[values.size()];
            Integer[] weights = new Integer[values.size()];
            int count = 0;
            this.myNodeCounts[3] = 0;
            this.myNodeCounts[2] = 0;
            this.myNodeCounts[1] = 0;
            this.myNodeCounts[0] = 0;
            LinkedList<CacheData> mostReferred = new LinkedList<CacheData>();
            int NUM_MOST_REFERRED = 10;
            for (CacheData v : values) {
                TariffStructureNode tn = (TariffStructureNode)v.node.get();
                if (tn == null) continue;
                int weight = v.weight;
                int rc = v.refcount;
                refCounts[++count - 1] = rc;
                weights[count - 1] = weight;
                if (rc < 2) continue;
                int n = tn.getNodeType();
                this.myNodeCounts[n] = this.myNodeCounts[n] + 1;
                int mrs = mostReferred.size();
                if (mrs < 10) {
                    mostReferred.add(v);
                } else {
                    CacheData last = (CacheData)mostReferred.get(mrs - 1);
                    if (rc > last.refcount) {
                        mostReferred.remove(mrs - 1);
                        mostReferred.add(v);
                    }
                }
                Collections.sort(mostReferred, DESCENDING_REFCOUNT_COMPARATOR);
            }
            Object[] rcStats = this.calcMedianMaxAvg(refCounts, count);
            Object[] weightStats = this.calcMedianMaxAvg(weights, count);
            this.myMedianRefCount = (Double)rcStats[0];
            this.myMaxRefCount = (Integer)rcStats[1];
            this.myAverageRefCount = (Double)rcStats[2];
            this.myMedianWeight = (Double)weightStats[0];
            this.myMaxWeight = (Integer)weightStats[1];
            this.myAverageWeight = (Double)weightStats[2];
            this.myMostReferredElements = new ArrayList<String>(mostReferred.size());
            for (CacheData data : mostReferred) {
                this.myMostReferredElements.add(this.describe(data));
            }
        }

        private Object[] calcMedianMaxAvg(Integer[] nums, int count) {
            Arrays.sort(nums, INT_COMPARATOR);
            int sum = 0;
            for (int i = 0; i < count; ++i) {
                sum += nums[i].intValue();
            }
            int max = nums[count - 1];
            double avg = (double)sum / (double)count;
            double median = count % 2 == 0 ? (double)(nums[count / 2 - 1] + nums[count / 2]) / 2.0 : (double)nums[count / 2].intValue();
            Object[] ret = new Object[]{median, max, avg};
            return ret;
        }

        private String describe(CacheData data) {
            TariffStructureNode node = (TariffStructureNode)data.node.get();
            if (node == null) {
                return "(garbage collected)";
            }
            return String.format("%s (%s), refcount = %d, weight = %d", node.getNodeId(), this.getElementType(node), data.refcount, data.weight);
        }

        private String getElementType(TariffStructureNode node) {
            switch (node.getNodeType()) {
                case 2: {
                    return "condition";
                }
                case 3: {
                    return "modifier";
                }
                case 1: {
                    return "node";
                }
                case 0: {
                    return "structure";
                }
            }
            return "unknown";
        }
    }

    public static final class MaxNodesOfMinReferences
    implements Comparator<CacheData> {
        @Override
        public int compare(CacheData o1, CacheData o2) {
            int i = o1.refcount - o2.refcount;
            if (i == 0) {
                i = o2.weight - o1.weight;
            }
            if (i == 0) {
                i = System.identityHashCode(o1.node) - System.identityHashCode(o2.node);
            }
            return i;
        }
    }

    public static final class CacheData {
        final WeakReference<TariffStructureNode> node;
        volatile int refcount;
        final int weight;

        public CacheData(WeakReference<TariffStructureNode> n, AtomicInteger i, int w) {
            this(n, i.get(), w);
        }

        public CacheData(WeakReference<TariffStructureNode> n, int i, int w) {
            this.node = n;
            this.refcount = i;
            this.weight = w;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheData other = (CacheData)obj;
            return !(this.node == null ? other.node != null : !this.node.equals(other.node));
        }
    }
}

