/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.ProgressWrapper;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.event.ProxyStructureEvent;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.settingsmap.SettingsMap;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;

public class ServiceProviderListProxy
extends AbstractEreProxy {
    private transient Vector<ServiceProviderProxy> serviceProviderList = new Vector();
    private transient RatingManagerProxy parent = null;

    public ServiceProviderListProxy(AbstractConnector connector, RatingManagerProxy parentProxy) {
        this.connector = connector;
        this.parent = parentProxy;
        this.setName("");
        this.myURI = this.buildURI(AbstractEreProxy.URIScheme.SERVICEPROVIDERLIST);
        if (this.getAbortRefresh()) {
            return;
        }
        this.refresh();
    }

    @Override
    public void refresh() {
        this.serviceProviderList.clear();
        try {
            List<String> serviceProviderNameList = this.connector.getServiceProviderList();
            ProgressWrapper[] progressArray = EreProxyManager.getInstance().getProgressWrapper().splitProgress(serviceProviderNameList.size());
            for (String serviceProviderName : serviceProviderNameList) {
                EreProxyManager.getInstance().setProgressWrapper(progressArray[serviceProviderNameList.indexOf(serviceProviderName)]);
                progressArray[serviceProviderNameList.indexOf(serviceProviderName)].progressStart();
                this.serviceProviderList.add(this.connector.getProxyFactory().createServiceProviderProxy(this.connector, this, serviceProviderName));
                progressArray[serviceProviderNameList.indexOf(serviceProviderName)].progressFinished();
            }
        }
        catch (EreCommunicationException ereCommunicationException) {
            // empty catch block
        }
    }

    public Vector<ServiceProviderProxy> getServiceProviderList() {
        return this.serviceProviderList;
    }

    public String getProperty(String propertyName) {
        return this.connector.getProperty(propertyName);
    }

    public String getId() {
        return this.connector.getId();
    }

    public ServiceProviderProxy createServiceProvider(Element serviceProvider) throws EreCommunicationException {
        String serviceProviderName = serviceProvider.getAttribute("Name");
        SettingsMap properties = new SettingsMap();
        properties.setParameter("Name", serviceProviderName);
        ServiceProviderProxy result = this.createServiceProvider(properties);
        return result;
    }

    public ServiceProviderProxy createServiceProvider(SettingsMap properties) throws EreCommunicationException {
        this.connector.createServiceProvider(properties);
        this.getEreProxy().refreshRatingManagerDocument();
        this.refresh();
        this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(this));
        return this.getServiceProvider(properties.getParameterAsString("Name"));
    }

    public void deleteServiceProvider(ServiceProviderProxy serviceProviderProxy) throws EreCommunicationException {
        this.connector.removeServiceProvider(serviceProviderProxy);
        this.getEreProxy().refreshRatingManagerDocument();
        this.refresh();
        this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(this));
    }

    public ServiceProviderProxy getServiceProvider(String serviceProviderName) {
        for (ServiceProviderProxy tProxy : this.serviceProviderList) {
            if (!tProxy.getName().equalsIgnoreCase(serviceProviderName)) continue;
            return tProxy;
        }
        return null;
    }

    public boolean serviceProviderExists(String parameterAsString) {
        return this.getServiceProvider(parameterAsString) != null;
    }

    @Override
    protected AbstractEreProxy getAbstractParentProxy() {
        return this.parent;
    }

    @Override
    public RatingManagerProxy getRatingManagerProxy() {
        return this.parent;
    }

    @Override
    public boolean isImportableUnder(AbstractEreProxy destination) {
        if (destination instanceof ServiceProviderListProxy) {
            return true;
        }
        return destination instanceof RatingManagerProxy;
    }
}

