/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.ProgressWrapper;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.ere.proxy.event.ProxyStructureEvent;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.connector.EreConnector;
import ericsson.ere.integration.settingsmap.Parameter;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.xml.XMLUtil;
import java.io.File;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceListProxy
extends AbstractEreProxy {
    public static final String ELEMENT_TYPE = "ServiceList";
    private transient Vector<ServiceProxy> serviceProxies = new Vector();
    private transient RatingManagerProxy parentProxy = null;

    public ServiceListProxy(AbstractConnector anyConnector, RatingManagerProxy parentProxy) {
        this.connector = anyConnector;
        this.parentProxy = parentProxy;
        this.setName("");
        this.myURI = this.buildURI(AbstractEreProxy.URIScheme.SERVICELIST);
        if (this.getAbortRefresh()) {
            return;
        }
        this.refresh();
    }

    @Override
    public RatingManagerProxy getRatingManagerProxy() {
        return this.parentProxy;
    }

    @Override
    public void refresh() {
        String[] availableServices;
        ProgressWrapper progress = EreProxyManager.getInstance().getProgressWrapper();
        progress.setInfo("Building ServiceListProxy");
        this.serviceProxies.clear();
        try {
            availableServices = this.connector.getServiceList();
        }
        catch (EreCommunicationException ex) {
            ExceptionUtil.handleException(ex, "service", 2, "Failed to retrieve service list.", false);
            return;
        }
        for (String serviceName : availableServices) {
            try {
                ServiceProxy serviceProxy = this.connector.getProxyFactory().createServiceProxy(this.connector, this, serviceName);
                this.serviceProxies.add(serviceProxy);
                progress.progressIncrement();
            }
            catch (EreCommunicationException ex) {
                ExceptionUtil.handleException(ex, "service", 2, "Failed to load service '" + serviceName + "'.", false);
            }
        }
    }

    public Vector<ServiceProxy> getServiceList() {
        return this.serviceProxies;
    }

    public String getId() {
        return this.connector.getId();
    }

    public Element getXML() {
        Document resultDocument = null;
        try {
            resultDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element result = resultDocument.createElement(ELEMENT_TYPE);
            resultDocument.appendChild(result);
            for (ServiceProxy currentService : this.serviceProxies) {
                try {
                    Element serviceXML = currentService.getServiceXML();
                    Node importedNode = resultDocument.importNode(serviceXML, true);
                    result.appendChild(importedNode);
                }
                catch (EreCommunicationException e) {
                    ExceptionUtil.handleException(e, "service", 1, "Failed to fetch service XML for '" + currentService.getName() + "'.", false);
                }
            }
        }
        catch (DOMException e) {
            ExceptionUtil.handleException(e, "service", 2, "Error when parsing service XML.", false);
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        return resultDocument == null ? null : (Element)resultDocument.getFirstChild();
    }

    public void createService(SettingsMap propertyMap, Element structureElement, Element conditionElement) throws EreCommunicationException {
        Parameter definitionParameter = propertyMap.getParameter("Service definition file");
        String file = definitionParameter.getValue();
        if (file.contains(File.separator)) {
            file = file.substring(file.lastIndexOf(File.separator) + 1, file.length());
        }
        definitionParameter.setLocked(false);
        definitionParameter.setValue(file);
        definitionParameter.setLocked(true);
        this.connector.createService(this, propertyMap, structureElement, conditionElement);
        this.getEreProxy().refreshRatingManagerDocument();
        this.refresh();
        this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(this));
    }

    public void createService(Element serviceElement) throws EreCommunicationException {
        SettingsMap propertyMap = new SettingsMap();
        String serviceName = serviceElement.getAttribute("Name");
        propertyMap.setParameter("Name", serviceName);
        propertyMap.setParameter("Service definition file", serviceName);
        propertyMap.setParameter("Service condition file", "");
        Element definition = XMLUtil.getNamedElement("ServiceDefinition", serviceElement.getChildNodes());
        Element settings = XMLUtil.getNamedElement("Settings", definition.getChildNodes());
        if (settings == null) {
            throw new IllegalArgumentException("No Settings element found.");
        }
        this.createService(propertyMap, definition, settings);
    }

    public ServiceProxy createEmptyServiceSkeleton() throws EreCommunicationException {
        SettingsMap properties = new SettingsMap();
        properties.setParameter("Name", "Default Service Name");
        try {
            Document tDocument = XMLUtil.documentFromString("<UNDEFINED></UNDEFINED>");
            Element structureElement = tDocument.createElement("ServiceDefinition");
            Element conditionElement = tDocument.createElement("Settings");
            this.createService(properties, structureElement, conditionElement);
            this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(this));
        }
        catch (EreCommunicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this.connector, e.getMessage(), e);
        }
        return this.getServiceProxy(properties.getParameterAsString("Name"));
    }

    public boolean serviceExists(String serviceName) {
        for (ServiceProxy service : this.serviceProxies) {
            if (!service.getName().equalsIgnoreCase(serviceName)) continue;
            return true;
        }
        return false;
    }

    public void deleteService(ServiceProxy someServiceProxy) throws EreCommunicationException {
        this.connector.removeService(someServiceProxy);
        this.getEreProxy().refreshRatingManagerDocument();
        this.refresh();
        this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(this));
    }

    public ServiceProxy getServiceProxy(String serviceName) {
        for (ServiceProxy serviceProxy : this.serviceProxies) {
            if (!serviceProxy.getName().equalsIgnoreCase(serviceName)) continue;
            return serviceProxy;
        }
        return null;
    }

    @Override
    protected AbstractEreProxy getAbstractParentProxy() {
        return this.parentProxy;
    }

    @Override
    public boolean isImportableUnder(AbstractEreProxy destination) {
        return destination instanceof ServiceListProxy;
    }

    public final void createNewService(SettingsMap newSettings) throws Exception {
        String newServiceName = newSettings.getParameterAsString("Name");
        Element structureElement = this.getNewServiceDefinition(newServiceName);
        Element conditionElement = this.getNewServiceSettings();
        ServiceProxy.createFileRef(newSettings);
        this.createService(newSettings, structureElement, conditionElement);
    }

    protected Element getNewServiceDefinition(String name) throws Exception {
        return ServiceProxy.createDefaultServiceDefinitionXML(name);
    }

    protected Element getNewServiceSettings() throws Exception {
        return ServiceProxy.createDefaultServiceConditionXML();
    }
}

