/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.ActiveSavedRatingPeriodProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.ProgressWrapper;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.xml.ElementIterator;
import java.util.Vector;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SavedListProxy
extends AbstractEreProxy {
    private transient RatingPlanProxy parentProxy = null;
    private transient Vector<RatingPeriodProxy> ratingPeriodList = new Vector();

    public SavedListProxy(AbstractConnector connector, RatingPlanProxy parentProxy, String ratingPlanName) {
        this.connector = connector;
        this.parentProxy = parentProxy;
        this.setName(ratingPlanName);
        this.myURI = this.buildURI(AbstractEreProxy.URIScheme.PLAN);
        if (this.getAbortRefresh()) {
            return;
        }
        this.refresh();
    }

    @Override
    public void refresh() {
        try {
            this.ratingPeriodList.clear();
            Element rpElement = this.connector.getRatingPlanElement(this.parentProxy.getServiceProviderProxy().getName(), this.getName());
            XPath xpath = XPathFactory.newInstance().newXPath();
            String activePeriodPath = "Saved/RatingPeriod";
            NodeList activePeriodNodes = (NodeList)xpath.evaluate(activePeriodPath, rpElement, XPathConstants.NODESET);
            ElementIterator eIter = new ElementIterator(activePeriodNodes);
            ProgressWrapper[] progressArray = EreProxyManager.getInstance().getProgressWrapper().splitProgress(eIter.getElementCount());
            int progressIdCounter = 0;
            for (Element ratingPeriod : eIter) {
                EreProxyManager.getInstance().setProgressWrapper(progressArray[progressIdCounter]);
                progressArray[progressIdCounter].progressStart();
                ActiveSavedRatingPeriodProxy newPeriodProxy = new ActiveSavedRatingPeriodProxy(this.connector, this, ratingPeriod.getAttribute("Name"), ratingPeriod.getAttribute("StartDate"));
                this.ratingPeriodList.add(newPeriodProxy);
                progressArray[progressIdCounter].progressFinished();
                ++progressIdCounter;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector<RatingPeriodProxy> getRatingPeriodList() {
        return this.ratingPeriodList;
    }

    public RatingPeriodProxy getRatingPeriodProxy(String ratingPeriodName, String startTime) {
        for (RatingPeriodProxy ratingPeriodProxy : this.ratingPeriodList) {
            if (!ratingPeriodProxy.getName().equalsIgnoreCase(ratingPeriodName) || !ratingPeriodProxy.getRatingPeriodStartTime().equals(startTime)) continue;
            return ratingPeriodProxy;
        }
        return null;
    }

    @Override
    public RatingManagerProxy getRatingManagerProxy() {
        return this.parentProxy.getRatingManagerProxy();
    }

    public String getRatingPlanName() {
        return this.parentProxy.getName();
    }

    public String getServiceName() {
        return this.parentProxy.getServiceName();
    }

    public String getId() {
        return this.connector.getId();
    }

    public ServiceProviderProxy getServiceProviderProxy() {
        return this.parentProxy.getServiceProviderProxy();
    }

    public RatingPeriodProxy getRatingPeriod(String ratingPeriodName, String startTime) {
        for (RatingPeriodProxy ratingPeriodProxy : this.ratingPeriodList) {
            if (!(ratingPeriodProxy.isStartTimeUsed() ? ratingPeriodProxy.getName().equalsIgnoreCase(ratingPeriodName) && ratingPeriodProxy.getRatingPeriodStartTime().equals(startTime) : ratingPeriodProxy.getName().equals(ratingPeriodName))) continue;
            return ratingPeriodProxy;
        }
        return null;
    }

    public void copyCreateRatingPeriodProxy(RatingPeriodProxy proxy) {
        System.out.println("-- copyCreateRatingPeriodProxy(RatingPeriodProxy proxy) has not been implemented");
    }

    public RatingPlanProxy getRatingPlanProxy() {
        return this.parentProxy;
    }

    @Override
    protected AbstractEreProxy getAbstractParentProxy() {
        return this.parentProxy;
    }

    @Override
    public boolean isImportableUnder(AbstractEreProxy destination) {
        return destination instanceof SavedListProxy ? this.getServiceName().equalsIgnoreCase(((SavedListProxy)destination).getServiceName()) : (destination instanceof RatingPlanProxy ? this.getServiceName().equalsIgnoreCase(((RatingPlanProxy)destination).getServiceName()) : destination instanceof RatingPeriodProxy && this.getServiceName().equalsIgnoreCase(((RatingPeriodProxy)destination).getServiceName()));
    }

    @Override
    protected String getURIPath() {
        String path = "";
        if (this.parentProxy != null) {
            path = this.parentProxy.getURIPath();
        }
        return path + "/Saved";
    }
}

