/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.InternalEreProxyLogReceiver;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.event.ProxyStructureEvent;
import com.ericsson.ere.proxy.exception.ProxyInstantiationException;
import ericsson.ere.gui.Config;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.ConnectorFactory;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.connector.EreConnector;
import ericsson.ere.integration.receiver.PoolHttpServer;
import ericsson.ere.integration.settingsmap.Parameter;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.integration.settingsmap.propertyio.XMLInput;
import ericsson.ere.integration.util.FileHandling;
import ericsson.ere.management.EreManager;
import ericsson.ere.management.RatingManager;
import ericsson.ere.progress.NullProgressIndicator;
import ericsson.ere.progress.ProgressIndicator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class InternalEreProxy
extends EreProxy {
    public static final String INTERNAL_SERVER_WORKING_DIR = "internalERE/";
    public static final String INTERNAL_TYPE = "Internal ERE";
    public static final String ATTR_TYPE = "type";
    public static final String PAR_NAME = "Name";
    public static final String PAR_RATING_MANAGER = "Rating Manager File";
    public static final String PAR_PORT = "Port";
    public static final String PAR_USERNAME = "Username";
    public static final String PAR_PASSWORD = "Password";
    public static final String PAR_ENABLED = "Enabled";
    transient PoolHttpServer myServer = null;
    private transient EreManager myEreManager = null;

    public InternalEreProxy(Element configElement) throws InstantiationException {
        String ereType = configElement.getAttribute(ATTR_TYPE);
        if (ereType == null || ereType.length() <= 0) {
            throw new InstantiationException("Failed to create ERE node. Type could not be found in config. Config data:\n" + configElement.toString());
        }
        try {
            this.myEreSettings = XMLInput.readFromElement(configElement);
            this.myEreSettings.setParameter(ATTR_TYPE, ereType, 1, true);
            if (this.myEreSettings.getParameterAsString(PAR_NAME) == null) {
                throw new InstantiationException("Failed to create internal ERE node. Name could not be found in config. Config data:\n" + configElement.toString());
            }
            this.connector = (AbstractConnector)ConnectorFactory.getInstance().createConnector(ereType);
            this.connector.init(ereType, this.myEreSettings);
        }
        catch (InstantiationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstantiationException("Failed to create internal ERE node. Reason: " + e);
        }
        this.myURI = this.buildURI(AbstractEreProxy.URIScheme.MANAGER);
    }

    public InternalEreProxy(String type) throws InstantiationException {
        if (type == null || type.length() == 0) {
            throw new InstantiationException("Failed to create internal ERE node. Supplied type is empty or null.");
        }
        this.connector = (AbstractConnector)ConnectorFactory.getInstance().createConnector(type);
        this.myEreSettings.mergeParametersFrom(this.connector.getErePropertyMap());
        this.myEreSettings.setParameter(ATTR_TYPE, type, 1, true);
        if (this.myEreSettings.getParameterAsString(PAR_NAME) == null) {
            throw new InstantiationException("Failed to create ERE node. Name could not be found in config. Config data:\n" + this.myEreSettings.toString());
        }
        if (!this.isEnabled()) {
            this.myConnectionState = 1;
        }
        this.myURI = this.buildURI(AbstractEreProxy.URIScheme.MANAGER);
    }

    public void startInternalERE(ProgressIndicator progress) throws ProxyInstantiationException {
        ProgressIndicator pi = progress != null ? progress : new NullProgressIndicator();
        pi.progressStart();
        pi.setInfo("Starting the internal ERE.");
        try {
            if (!this.isEnabled()) {
                this.myConnectionState = 1;
                return;
            }
            String[] args = this.createServerArguments();
            if (args == null) {
                this.myConnectionState = 1;
                return;
            }
            this.createAndStartServer(progress, args);
            this.myConnectionState = 3;
        }
        catch (Exception e) {
            this.myConnectionState = 2;
            throw new ProxyInstantiationException("Internal ERE could not be started", e);
        }
        finally {
            pi.progressFinished();
        }
    }

    private void createAndStartServer(ProgressIndicator progress, String[] args) throws IOException, Exception {
        EreManager manager = new EreManager();
        PoolHttpServer server = new PoolHttpServer(manager);
        this.myServer = server.startServer(args, progress, new InternalEreProxyLogReceiver());
        this.myEreManager = manager;
        RatingManager.createInstance(this.myEreManager);
    }

    private String[] createServerArguments() {
        File file;
        String ratingFile;
        ArrayList<String> lparams = new ArrayList<String>();
        String workingDir = ratingFile = this.getErePropertyMap().getParameter(PAR_RATING_MANAGER).getValue();
        String filename = "RatingManager.xml";
        if (ratingFile == null || ratingFile.length() == 0 || ratingFile.equalsIgnoreCase("default")) {
            if (ratingFile == null || ratingFile.length() == 0) {
                this.getErePropertyMap().setParameter(PAR_RATING_MANAGER, "Default", 1, false);
            }
            workingDir = Config.getInstance().getUserDir() + File.separatorChar + INTERNAL_SERVER_WORKING_DIR;
        } else {
            file = new File(workingDir);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    filename = file.getName();
                    workingDir = file.getParent() + File.separatorChar;
                } else {
                    workingDir = file.getPath() + File.separatorChar;
                }
            } else if (ratingFile.endsWith(".xml")) {
                filename = file.getName();
                workingDir = file.getParent() + File.separatorChar;
            } else if (ratingFile.endsWith("\\") || ratingFile.endsWith("/")) {
                workingDir = file.getPath() + File.separatorChar;
            } else {
                filename = file.getName();
                workingDir = file.getParent() + File.separatorChar;
            }
        }
        file = new File(workingDir + filename);
        if (!file.exists()) {
            File dir = new File(workingDir);
            if (!dir.exists() && !dir.mkdirs()) {
                DialogFactory.getErrorDialog("Starting Internal ERE", "Failed to start the internal ERE node as \nthe current working directory could not be created.\n" + workingDir);
                return null;
            }
            if (!InternalEreProxy.createDefaultRatingManagerXML(file)) {
                return null;
            }
        }
        lparams.add("-w");
        lparams.add(workingDir);
        lparams.add("-r");
        lparams.add(filename);
        try {
            int port = Integer.parseInt(this.getErePropertyMap().getParameter(PAR_PORT).getValue());
            lparams.add("-p");
            lparams.add(Integer.toString(port));
        }
        catch (NumberFormatException port) {
            // empty catch block
        }
        String user = this.getErePropertyMap().getParameter(PAR_USERNAME).getValue();
        String psw = this.getErePropertyMap().getParameter(PAR_PASSWORD).getValue();
        if (user != null && user.length() > 0 && psw != null && psw.length() > 0) {
            lparams.add("-u");
            lparams.add(user + "," + psw);
        }
        return lparams.toArray(new String[lparams.size()]);
    }

    public void stopInternalERE() {
        this.shutdownServer();
        this.cleanupEreManager();
        this.myConnectionState = 1;
    }

    private void cleanupEreManager() {
        if (this.myEreManager != null) {
            this.myEreManager.clearAll();
        }
    }

    private void shutdownServer() {
        if (this.myServer != null) {
            this.myServer.shutDown();
            this.myServer = null;
        }
    }

    private static boolean printRatingManagerXML(File file) {
        try {
            StringBuilder contents = new StringBuilder();
            contents.append("<Manager Name=\"Rating Manager\">\n");
            contents.append("<ServiceList>\n");
            contents.append("</ServiceList>\n");
            contents.append("<ServiceProviderList>\n");
            contents.append("</ServiceProviderList>\n");
            contents.append("</Manager>\n");
            FileHandling.writeToFile(contents.toString(), file);
        }
        catch (Exception e) {
            DialogFactory.getErrorDialog("Create RatingManager", "Failed to create Rating Manager configuration file. Reason:\n" + e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean createDefaultRatingManagerXML(File file) {
        if (GuiServiceCenter.getInstance().getSplash() != null) {
            GuiServiceCenter.getInstance().getSplash().dispose();
        }
        Logger.getLogger("rma").info("A RatingManager configuration file could not be found at the specified location:\n" + file.getPath() + "\nCreated a default (empty) configuration.");
        return InternalEreProxy.printRatingManagerXML(file);
    }

    @Override
    public boolean isEnabled() {
        Parameter parameter = this.getErePropertyMap().getParameter(PAR_ENABLED);
        if (parameter != null) {
            return Boolean.valueOf(parameter.getValue());
        }
        return false;
    }

    public SettingsMap getErePropertyMap() {
        return this.myEreSettings;
    }

    @Override
    public boolean isAlive() {
        return this.connector.isAlive();
    }

    @Override
    public String getType() {
        return this.myEreSettings.getParameterAsString(ATTR_TYPE);
    }

    @Override
    public RatingManagerProxy getRatingManagerProxy() {
        if (this.myRatingManagerProxy == null) {
            this.myRatingManagerProxy = this.connector.getProxyFactory().createRatingManagerProxy(this.connector, this);
            this.fireProxyStructureEvent(new ProxyStructureEvent(this));
        }
        return this.myRatingManagerProxy;
    }

    public EreManager getEreManager() {
        return this.myEreManager;
    }

    @Override
    public EreProxy getEreProxy() {
        return this;
    }

    public void restartInternalEre(ProgressIndicator progress) throws ProxyInstantiationException, EreCommunicationException {
        ProgressIndicator pi = progress != null ? progress : new NullProgressIndicator();
        ProgressIndicator[] slices = pi.splitProgress(new int[]{10, 40, 40, 10});
        this.startProgressWithInfo(slices[0], "Shutting down the internal ERE.");
        this.stopInternalERE();
        slices[0].progressFinished();
        this.myRatingManagerProxy = null;
        this.startInternalERE(slices[1]);
        if (this.myConnectionState == 3) {
            this.startProgressWithInfo(slices[2], "Refreshing internal ERE structure");
            EreProxyManager.getInstance().setProgressIndicator(slices[2]);
            this.refreshRatingManagerDocument();
            this.getRatingManagerProxy();
            slices[2].progressFinished();
        }
        this.startProgressWithInfo(slices[3], "Restart complete.");
        this.fireProxyStructureEvent(new ProxyStructureEvent(this));
        slices[3].progressFinished();
    }

    @Override
    public void refreshRatingManagerDocument() throws EreCommunicationException {
        if (this.myServer == null) {
            String[] args = this.createServerArguments();
            if (args == null) {
                this.myConnectionState = 1;
                throw new EreCommunicationException(this.connector, "Cannot start the internal ERE; unable to create configuration settings.");
            }
            try {
                this.createAndStartServer(null, args);
                this.myConnectionState = 2;
            }
            catch (Exception e) {
                throw new EreCommunicationException((EreConnector)this.connector, "Cannot start the internal ERE", e);
            }
        }
        super.refreshRatingManagerDocument();
    }

    private void startProgressWithInfo(ProgressIndicator pi, String info) {
        pi.progressStart();
        pi.setInfo(info);
    }
}

