/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.InternalEreProxy;
import com.ericsson.ere.proxy.ProgressWrapper;
import com.ericsson.ere.proxy.event.ProxyManagementEvent;
import com.ericsson.ere.proxy.event.ProxyManagementListener;
import com.ericsson.ere.proxy.exception.ProxyInstantiationException;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.progress.ProgressIndicator;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Element;

public class EreProxyManager {
    private InternalEreProxy internalEreProxy = null;
    private Vector<EreProxy> ereProxyList = new Vector();
    private static EreProxyManager myInstance = new EreProxyManager();
    private ProgressWrapper progressWrapper = null;
    protected EventListenerList managementListenerList = new EventListenerList();

    private EreProxyManager() {
    }

    public static EreProxyManager getInstance() {
        return myInstance;
    }

    public InternalEreProxy instantiateInternalEre(Element rootElement) throws InstantiationException, EreCommunicationException, ProxyInstantiationException {
        InternalEreProxy newEreProxy = rootElement != null ? new InternalEreProxy(rootElement) : new InternalEreProxy("Internal ERE");
        this.internalEreProxy = newEreProxy;
        this.internalEreProxy.startInternalERE(null);
        if (this.internalEreProxy.isAlive() && newEreProxy.getConnectAtStartup()) {
            this.internalEreProxy.refreshRatingManagerDocument();
            this.internalEreProxy.getRatingManagerProxy();
        }
        this.internalFireEreProxyAddedEvent(new ProxyManagementEvent(this.internalEreProxy));
        return newEreProxy;
    }

    public InternalEreProxy instantiateInternalEre() throws InstantiationException, EreCommunicationException, ProxyInstantiationException {
        return this.instantiateInternalEre(null);
    }

    public void instantiateRemoteEre(Element ereConfigElement) throws InstantiationException, EreCommunicationException {
        EreProxy newEreProxy = new EreProxy(ereConfigElement, 2);
        try {
            if (newEreProxy.getConnectAtStartup()) {
                newEreProxy.refreshRatingManagerDocument();
                newEreProxy.getRatingManagerProxy();
            }
        }
        finally {
            this.internalFireEreProxyAddedEvent(new ProxyManagementEvent(newEreProxy));
            this.ereProxyList.add(newEreProxy);
        }
    }

    public EreProxy instantiateNewRemoteEre(String ereType) throws InstantiationException {
        EreProxy newEreProxy = new EreProxy(ereType);
        this.ereProxyList.add(newEreProxy);
        this.internalFireEreProxyAddedEvent(new ProxyManagementEvent(newEreProxy));
        return newEreProxy;
    }

    public InternalEreProxy getInternalEreProxy() {
        return this.internalEreProxy;
    }

    public Vector<EreProxy> getRemoteEreList() {
        return (Vector)this.ereProxyList.clone();
    }

    @Deprecated
    public AbstractConnector getConnectorForEreProxy(EreProxy ereProxy) {
        AbstractConnector result = null;
        if (this.internalEreProxy == ereProxy) {
            result = ereProxy.connector;
        }
        for (EreProxy proxy : this.ereProxyList) {
            if (proxy != ereProxy) continue;
            result = ereProxy.connector;
        }
        return result;
    }

    public void setProgressIndicator(ProgressIndicator progressIndicator) {
        this.setProgressWrapper(new ProgressWrapper(progressIndicator));
    }

    public void setProgressWrapper(ProgressWrapper aProgressWrapper) {
        this.progressWrapper = aProgressWrapper;
    }

    public ProgressWrapper getProgressWrapper() {
        if (this.progressWrapper == null) {
            this.progressWrapper = new ProgressWrapper();
        }
        return this.progressWrapper;
    }

    public void removeEre(EreProxy newProxy) {
        if (this.internalEreProxy == newProxy) {
            this.internalEreProxy = null;
        } else {
            this.ereProxyList.remove(newProxy);
            this.internalFireEreProxyRemovedEvent(new ProxyManagementEvent(newProxy));
        }
    }

    public void addProxyManagementListener(ProxyManagementListener listener) {
        this.managementListenerList.add(ProxyManagementListener.class, listener);
    }

    public void removeProxyPropertyEventListener(ProxyManagementListener listener) {
        this.managementListenerList.remove(ProxyManagementListener.class, listener);
    }

    protected void internalFireEreProxyAddedEvent(ProxyManagementEvent event) {
        Object[] listeners = this.managementListenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ProxyManagementListener.class) continue;
            ((ProxyManagementListener)listeners[i + 1]).ereProxyAdded(event);
        }
    }

    @Deprecated
    public void fireEreProxyAddedEvent(ProxyManagementEvent event) {
        this.internalFireEreProxyAddedEvent(event);
    }

    protected void internalFireEreProxyRemovedEvent(ProxyManagementEvent event) {
        Object[] listeners = this.managementListenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ProxyManagementListener.class) continue;
            ((ProxyManagementListener)listeners[i + 1]).ereProxyRemoved(event);
        }
    }

    @Deprecated
    public void fireEreProxyRemovedEvent(ProxyManagementEvent event) {
        this.internalFireEreProxyRemovedEvent(event);
    }
}

