/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.ProgressWrapper;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.event.ProxyPropertyEvent;
import com.ericsson.ere.proxy.event.ProxyPropertyListener;
import com.ericsson.ere.proxy.event.ProxyStructureEvent;
import com.ericsson.ere.proxy.event.ProxyStructureListener;
import com.ericsson.ere.util.HashUtil;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.ConnectorFactory;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.settingsmap.Parameter;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.integration.settingsmap.propertyio.XMLInput;
import java.util.Objects;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Element;

public class EreProxy
extends AbstractEreProxy {
    public static final int INITIATION_IMMEDIATE = 1;
    public static final int INITIATION_LAZY = 2;
    public static final int INITIATED = 0;
    public static final int DISABLED = 1;
    public static final int OFFLINE = 2;
    public static final int ONLINE = 3;
    public static final int CONNECTED = 4;
    protected static final String ATTR_TYPE = "type";
    protected static final String PAR_NAME = "Name";
    public static final String PAR_CONNECT_AT_STARTUP = "Connect at startup";
    public static final String PAR_PASSWORD = "Password";
    public static final String PAR_ENABLED = "Enabled";
    protected transient int initiationApproach = 2;
    protected transient RatingManagerProxy myRatingManagerProxy = null;
    protected volatile transient int myConnectionState = 2;
    protected transient EventListenerList structureListenerList = new EventListenerList();
    protected transient EventListenerList propertyListenerList = new EventListenerList();

    protected EreProxy() {
        this.setName("ERE");
    }

    public EreProxy(Element ereConfigElement, int initiationApproach) throws InstantiationException {
        ProgressWrapper progress = EreProxyManager.getInstance().getProgressWrapper();
        progress.setInfo("Building EreProxy");
        String myType = ereConfigElement.getAttribute(ATTR_TYPE);
        if (myType.length() > 0) {
            try {
                this.myEreSettings = XMLInput.readFromElement(ereConfigElement);
                this.myEreSettings.setParameter(ATTR_TYPE, myType, 1, true);
                this.connector = (AbstractConnector)ConnectorFactory.getInstance().createConnector(myType);
                this.connector.init(myType, this.myEreSettings);
                if (this.myEreSettings.getParameter(PAR_NAME).getValue() == null) {
                    throw new InstantiationException("Failed to create ERE node. Name could not be found in config. Config data:\n" + ereConfigElement.toString());
                }
                switch (initiationApproach) {
                    case 2: {
                        break;
                    }
                    default: {
                        this.refresh();
                        this.myConnectionState = 4;
                    }
                }
                this.initiationApproach = initiationApproach;
                progress.progressIncrement();
            }
            catch (Exception e) {
                throw new InstantiationException("Failed to create ERE node. Reason: " + e);
            }
        } else {
            throw new InstantiationException("Failed to create ERE node. Type could not be found in config. Config data:\n" + ereConfigElement.toString());
        }
        this.myURI = this.buildURI(AbstractEreProxy.URIScheme.MANAGER);
    }

    public EreProxy(String ereType) throws InstantiationException {
        this.connector = (AbstractConnector)ConnectorFactory.getInstance().createConnector(ereType);
        SettingsMap defaultMap = this.connector.getErePropertyMap();
        defaultMap.setParameter(ATTR_TYPE, ereType, 1, true);
        this.myEreSettings = (SettingsMap)defaultMap.clone();
        this.initiationApproach = 2;
    }

    private void checkInitiation() {
        if (this.myRatingManagerProxy == null && this.initiationApproach == 2) {
            this.myRatingManagerProxy = this.connector.getProxyFactory().createRatingManagerProxy(this.connector, this);
            this.fireProxyStructureEvent(new ProxyStructureEvent(this));
        }
    }

    private void updateSettingsMapIfPasswordModified(SettingsMap newPropertyModel, String oldPassword) {
        String password;
        this.myEreSettings.mergeParametersFrom(newPropertyModel);
        if (Objects.nonNull(this.myEreSettings.getParameter(PAR_PASSWORD)) && !oldPassword.equals(password = this.myEreSettings.getParameter(PAR_PASSWORD).getValue())) {
            this.myEreSettings.setParameter(PAR_PASSWORD, HashUtil.hash(password.toCharArray()));
        }
    }

    @Override
    public RatingManagerProxy getRatingManagerProxy() {
        this.checkInitiation();
        return this.myRatingManagerProxy;
    }

    public boolean isEnabled() {
        return Boolean.valueOf(this.connector.getErePropertyMap().getParameter(PAR_ENABLED).getValue());
    }

    @Override
    public void setSettingsMap(SettingsMap newPropertyModel) throws Exception {
        String oldPassword = this.myEreSettings.getParameterAsString(PAR_PASSWORD);
        this.myEreSettings.clear();
        this.updateSettingsMapIfPasswordModified(newPropertyModel, oldPassword);
        this.connector.init(this.myEreSettings.getParameterAsString(ATTR_TYPE), this.myEreSettings);
        this.getEreProxy().fireProxyPropertyEvent(new ProxyPropertyEvent(this));
    }

    public boolean isAlive() {
        return this.connector.isAlive();
    }

    public boolean isConnected() {
        return this.myConnectionState == 4;
    }

    public int getConnectionState() {
        return this.myConnectionState;
    }

    public void init(String type, SettingsMap settings) throws EreCommunicationException {
        this.connector.init(type, settings);
    }

    @Override
    public String toString() {
        return this.getName() + " (" + this.getType() + ")";
    }

    public String getType() {
        return this.myEreSettings.getParameterAsString(ATTR_TYPE);
    }

    public void addProxyStructureEventListener(ProxyStructureListener listener) {
        this.structureListenerList.add(ProxyStructureListener.class, listener);
    }

    public void removeProxyStructureEventListener(ProxyStructureListener listener) {
        this.structureListenerList.remove(ProxyStructureListener.class, listener);
    }

    public void addProxyPropertyEventListener(ProxyPropertyListener listener) {
        this.propertyListenerList.add(ProxyPropertyListener.class, listener);
    }

    public void removeProxyPropertyEventListener(ProxyPropertyListener listener) {
        this.propertyListenerList.remove(ProxyPropertyListener.class, listener);
    }

    public void fireProxyStructureEvent(ProxyStructureEvent event) {
        Object[] listeners = this.structureListenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ProxyStructureListener.class) continue;
            ((ProxyStructureListener)listeners[i + 1]).proxyStructureChanged(event);
        }
    }

    public void fireProxyPropertyEvent(ProxyPropertyEvent event) {
        Object[] listeners = this.propertyListenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ProxyPropertyListener.class) continue;
            ((ProxyPropertyListener)listeners[i + 1]).proxyPropertyChanged(event);
        }
    }

    @Override
    protected AbstractEreProxy getAbstractParentProxy() {
        return null;
    }

    @Override
    public EreProxy getEreProxy() {
        return this;
    }

    @Override
    public boolean getAbortRefresh() {
        return this.abortRefresh;
    }

    public int getConnectorIdentity() {
        return System.identityHashCode(this.connector);
    }

    public boolean getConnectAtStartup() {
        Parameter tProperty = this.myEreSettings.getParameter(PAR_CONNECT_AT_STARTUP);
        return Boolean.parseBoolean(tProperty.getValue());
    }

    public void refreshRatingManagerDocument() throws EreCommunicationException {
        if (this.myConnectionState == 2) {
            this.connector.init(this.myEreSettings.getParameterAsString(ATTR_TYPE), this.myEreSettings);
        }
        this.myRatingManagerProxy = null;
        this.connector.refreshRatingManagerDocument();
        this.myConnectionState = 4;
    }

    @Override
    public void refresh() {
        this.myRatingManagerProxy = this.connector.getProxyFactory().createRatingManagerProxy(this.connector, this);
        this.myConnectionState = 4;
        this.fireProxyStructureEvent(new ProxyStructureEvent(this));
    }

    public void disconnect() {
        this.myConnectionState = 2;
        this.initiationApproach = 2;
        this.myRatingManagerProxy = null;
        this.connector.disConnect();
        this.fireProxyStructureEvent(new ProxyStructureEvent(this));
    }

    @Override
    public boolean isImportableUnder(AbstractEreProxy destination) {
        return false;
    }
}

