/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.ActiveListProxy;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.SavedListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.event.ProxyStructureEvent;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.ActiveSavedConnector;

public class ActiveSavedRatingPeriodProxy
extends RatingPeriodProxy {
    private transient ActiveListProxy myActiveListParentProxy = null;
    private transient SavedListProxy mySavedListParentProxy = null;

    public ActiveSavedRatingPeriodProxy(AbstractConnector connector, ActiveListProxy parentProxy, String ratingPeriodName, String startDate) {
        super(connector, null, ratingPeriodName, startDate);
        this.myActiveListParentProxy = parentProxy;
        this.myURI = this.buildURI(AbstractEreProxy.URIScheme.PERIOD);
        if (!this.getAbortRefresh()) {
            this.refresh();
        }
    }

    @Override
    protected void init(AbstractConnector connector, String ratingPeriodName, String startDate) {
        this.connector = connector;
        this.setName(ratingPeriodName);
        boolean bl = this.myIsStartTimeUsed = startDate != null && !startDate.isEmpty();
        if (this.myIsStartTimeUsed) {
            this.myEreSettings.setParameter("Start date", startDate, 4, false);
        }
    }

    public ActiveSavedRatingPeriodProxy(AbstractConnector connector, SavedListProxy parentProxy, String ratingPeriodName, String startDate) {
        super(connector, null, ratingPeriodName, startDate);
        this.mySavedListParentProxy = parentProxy;
        this.myURI = this.buildURI(AbstractEreProxy.URIScheme.PERIOD);
    }

    @Override
    public Object getParentProxy() {
        AbstractEreProxy val = null;
        if (this.myActiveListParentProxy != null) {
            val = this.myActiveListParentProxy;
        } else if (this.mySavedListParentProxy != null) {
            val = this.mySavedListParentProxy;
        }
        return val;
    }

    @Override
    public boolean hasActiveOrSavedParentProxy() {
        return this.myActiveListParentProxy != null || this.mySavedListParentProxy != null;
    }

    @Override
    public boolean isSelectedActive() {
        return this.myActiveListParentProxy != null;
    }

    @Override
    public RatingPlanProxy getParentRatingPlanProxy() {
        RatingPlanProxy plan = null;
        if (this.myActiveListParentProxy != null) {
            plan = this.myActiveListParentProxy.getRatingPlanProxy();
        } else if (this.mySavedListParentProxy != null) {
            plan = this.mySavedListParentProxy.getRatingPlanProxy();
        }
        return plan;
    }

    @Override
    protected AbstractEreProxy getAbstractParentProxy() {
        return (AbstractEreProxy)this.getParentProxy();
    }

    @Override
    public RatingManagerProxy getRatingManagerProxy() {
        RatingManagerProxy mgrProxy = null;
        if (this.myActiveListParentProxy != null) {
            mgrProxy = this.myActiveListParentProxy.getRatingManagerProxy();
        } else if (this.mySavedListParentProxy != null) {
            mgrProxy = this.mySavedListParentProxy.getRatingManagerProxy();
        }
        return mgrProxy;
    }

    @Override
    public String getDefaultWindowTitle() {
        String prefix = "";
        if (this.getParentProxy() instanceof ActiveListProxy) {
            prefix = "Active ";
        }
        return prefix + super.getDefaultWindowTitle();
    }

    @Override
    protected String getPathToRatingPeriods() {
        String pathToRatingPeriods = "";
        pathToRatingPeriods = this.myActiveListParentProxy != null ? "Active/RatingPeriod[@Name='" + this.getName() + "'" + this.getDatePath() + "]" : "Saved/RatingPeriod[@Name='" + this.getName() + "'" + this.getDatePath() + "]";
        return pathToRatingPeriods;
    }

    @Override
    public void activateRatingPeriod() {
        RatingPlanProxy ratingPlanProxy = this.getParentRatingPlanProxy();
        try {
            if (this.connector instanceof ActiveSavedConnector) {
                ((ActiveSavedConnector)((Object)this.connector)).activateRatingPeriod(this);
                this.getEreProxy().refreshRatingManagerDocument();
                ratingPlanProxy.refresh();
                this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(ratingPlanProxy));
            }
        }
        catch (Exception e) {
            this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(ratingPlanProxy));
            String msg = "Could not activate the selected Rating period.\nCheck if not already activated\nReason:" + e.getMessage();
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Problem activating Rating period", msg);
        }
    }

    @Override
    public void deActivateRatingPeriod() {
        try {
            if (this.connector instanceof ActiveSavedConnector) {
                ((ActiveSavedConnector)((Object)this.connector)).deActivateRatingPeriod(this);
                ServiceProviderProxy serviceProviderProxy = this.getParentRatingPlanProxy().getServiceProviderProxy();
                this.getEreProxy().refreshRatingManagerDocument();
                serviceProviderProxy.refresh();
                this.getEreProxy().fireProxyStructureEvent(new ProxyStructureEvent(serviceProviderProxy));
            }
        }
        catch (Exception e) {
            String msg = "Could not deactivate the selected Rating period.\nReason:" + e.getMessage();
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Problem deactivating Rating period", msg);
        }
    }
}

